/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.engine;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.commons.bayesnet.BayesianNetwork;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.BayesNetWrapper;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.rcp.models.archive.ZipPoolableModelFactory;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallNetZipModelFactory
extends ZipPoolableModelFactory<IType, IObjectMethodCallsNet> {
    private static final long MAX_MODEL_SIZE = 0x4000000L;
    private final JavaElementResolver jdtResolver;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CallNetZipModelFactory(File zip, JavaElementResolver jdtResolver) throws IOException {
        super(zip);
        this.jdtResolver = jdtResolver;
    }

    public CallNetZipModelFactory(ZipFile zip, JavaElementResolver jdtResolver) throws IOException {
        super(zip);
        this.jdtResolver = jdtResolver;
    }

    public void destroyModel(IType key, IObjectMethodCallsNet obj) {
        super.destroyModel((Object)key, (Object)obj);
        this.log.debug("Destroying model for '{}'", (Object)key.getElementName());
    }

    public boolean hasModel(IType key) {
        return this.getEntry(key) != null;
    }

    private ZipEntry getEntry(IType jType) {
        ITypeName rType = this.toRecName(jType);
        String name = Zips.path((ITypeName)rType, (String)".data");
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        if (entry.getSize() > 0x4000000L) {
            return null;
        }
        return entry;
    }

    private ITypeName toRecName(IType jType) {
        ITypeName rType = this.jdtResolver.toRecType(jType);
        return rType;
    }

    public IObjectMethodCallsNet createModel(IType key) throws Exception {
        BayesNetWrapper bayesNetWrapper;
        this.log.debug("Loading model for '{}'", (Object)key.getElementName());
        InputStream is = null;
        try {
            is = this.zip.getInputStream(this.getEntry(key));
            BayesianNetwork net = BayesianNetwork.read((InputStream)is);
            ITypeName rKey = this.toRecName(key);
            bayesNetWrapper = new BayesNetWrapper(rKey, net);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(is);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)is);
        return bayesNetWrapper;
    }
}

