/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain;

import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class ChainElement {
    private final Binding element;
    private TypeBinding returnType;
    private int dimension;
    private ElementType elementType;
    private final boolean requireThis;

    public ChainElement(Binding binding, boolean requireThis) {
        this.element = (Binding)Checks.ensureIsNotNull((Object)binding);
        this.requireThis = requireThis;
        this.initializeReturnType();
    }

    private void initializeReturnType() {
        switch (this.element.kind()) {
            case 1: {
                this.returnType = ((FieldBinding)this.element).type;
                this.elementType = ElementType.FIELD;
                break;
            }
            case 2: {
                this.returnType = ((LocalVariableBinding)this.element).type;
                this.elementType = ElementType.LOCAL_VARIABLE;
                break;
            }
            case 8: {
                this.returnType = ((MethodBinding)this.element).returnType;
                this.elementType = ElementType.METHOD;
                break;
            }
            default: {
                RecommendersUtilsPlugin.logWarning((String)"Can't handle %s as return type.", (Object[])new Object[]{this.element});
            }
        }
        this.dimension = this.returnType.dimensions();
    }

    public <T extends Binding> T getElementBinding() {
        return (T)this.element;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public TypeBinding getReturnType() {
        return this.returnType;
    }

    public int getReturnTypeDimension() {
        return this.dimension;
    }

    public boolean requiresThisForQualification() {
        return this.requireThis;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChainElement) {
            ChainElement other = (ChainElement)obj;
            return this.element.equals(other.element);
        }
        return false;
    }

    public String toString() {
        if (this.elementType == ElementType.METHOD) {
            MethodBinding m = (MethodBinding)this.element;
            return "" + m.selector + m.signature();
        }
        return this.element.toString();
    }

    public static enum ElementType {
        METHOD,
        FIELD,
        LOCAL_VARIABLE;

    }
}

