/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.recommenders.internal.completion.rcp.chain.Chain;
import org.eclipse.recommenders.internal.completion.rcp.chain.ChainElement;
import org.eclipse.recommenders.utils.HashBag;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;
import org.eclipse.swt.graphics.Image;

public final class CompletionTemplateBuilder {
    private CompletionTemplateBuilder() {
    }

    public static TemplateProposal create(Chain chain, JavaContentAssistInvocationContext context) {
        String title = CompletionTemplateBuilder.createChainCode(chain, true, 0);
        String body = CompletionTemplateBuilder.createChainCode(chain, false, chain.getExpectedDimensions());
        Template template = new Template(title, String.valueOf(chain.getElements().size()) + " elements", "java", body, false);
        return CompletionTemplateBuilder.createTemplateProposal(template, context);
    }

    private static String createChainCode(Chain chain, boolean createAsTitle, int expectedDimension) {
        HashBag varNames = HashBag.newHashBag();
        StringBuilder sb = new StringBuilder(64);
        for (ChainElement edge : chain.getElements()) {
            switch (edge.getElementType()) {
                case FIELD: 
                case LOCAL_VARIABLE: {
                    CompletionTemplateBuilder.appendVariableString(edge, sb);
                    break;
                }
                case METHOD: {
                    MethodBinding method = (MethodBinding)edge.getElementBinding();
                    if (createAsTitle) {
                        sb.append(method.readableName());
                        break;
                    }
                    sb.append(method.selector);
                    CompletionTemplateBuilder.appendParameters(sb, method, (HashBag<String>)varNames);
                    break;
                }
                default: {
                    RecommendersUtilsPlugin.logWarning((String)"Can't handle %s's element type.", (Object[])new Object[]{edge});
                }
            }
            boolean appendVariables = !createAsTitle;
            CompletionTemplateBuilder.appendArrayDimensions(sb, edge.getReturnTypeDimension(), expectedDimension, appendVariables, (HashBag<String>)varNames);
            sb.append(".");
        }
        CompletionTemplateBuilder.deleteLastChar(sb);
        return sb.toString();
    }

    private static void appendVariableString(ChainElement edge, StringBuilder sb) {
        if (edge.requiresThisForQualification() && sb.length() == 0) {
            sb.append("this.");
        }
        sb.append(((VariableBinding)edge.getElementBinding()).name);
    }

    private static void appendParameters(StringBuilder sb, MethodBinding method, HashBag<String> varNames) {
        sb.append("(");
        TypeBinding[] typeBindingArray = method.parameters;
        int n = method.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding parameter = typeBindingArray[n2];
            String parameterName = StringUtils.uncapitalize((String)String.valueOf(parameter.shortReadableName()));
            parameterName = StringUtils.substringBefore((String)parameterName, (String)"<");
            CompletionTemplateBuilder.appendTemplateVariable(sb, parameterName, varNames);
            sb.append(", ");
            ++n2;
        }
        if (method.parameters.length > 0) {
            CompletionTemplateBuilder.deleteLastChar(sb);
            CompletionTemplateBuilder.deleteLastChar(sb);
        }
        sb.append(")");
    }

    private static void appendTemplateVariable(StringBuilder sb, String varname, HashBag<String> varNames) {
        varNames.add((Object)varname);
        sb.append("${").append(varname);
        int count = varNames.count((Object)varname);
        if (count > 1) {
            sb.append(count);
        }
        sb.append("}");
    }

    private static void appendArrayDimensions(StringBuilder sb, int dimension, int expectedDimension, boolean appendVariables, HashBag<String> varNames) {
        int i = dimension;
        while (i-- > expectedDimension) {
            sb.append("[");
            if (appendVariables) {
                CompletionTemplateBuilder.appendTemplateVariable(sb, "i", varNames);
            }
            sb.append("]");
        }
    }

    private static StringBuilder deleteLastChar(StringBuilder sb) {
        return sb.deleteCharAt(sb.length() - 1);
    }

    static TemplateProposal createTemplateProposal(Template template, JavaContentAssistInvocationContext contentAssistContext) {
        JavaContext templateContext = CompletionTemplateBuilder.createJavaContext(contentAssistContext);
        Region region = new Region(templateContext.getCompletionOffset(), templateContext.getCompletionLength());
        TemplateProposal proposal = new TemplateProposal(template, (TemplateContext)templateContext, (IRegion)region, CompletionTemplateBuilder.getChainCompletionIcon());
        return proposal;
    }

    static JavaContext createJavaContext(JavaContentAssistInvocationContext contentAssistContext) {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        TemplateContextType templateContextType = templateContextRegistry.getContextType("java");
        JavaContext javaTemplateContext = new JavaContext(templateContextType, contentAssistContext.getDocument(), contentAssistContext.getInvocationOffset(), contentAssistContext.getCoreContext().getToken().length, contentAssistContext.getCompilationUnit());
        javaTemplateContext.setForceEvaluation(true);
        return javaTemplateContext;
    }

    static Image getChainCompletionIcon() {
        return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_MISC_PUBLIC);
    }
}

