/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.templates;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.AbstractJavaContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.internal.completion.rcp.templates.JavaTemplateProposal;
import org.eclipse.recommenders.internal.completion.rcp.templates.PatternRecommendation;
import org.eclipse.recommenders.utils.Names;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.swt.graphics.Image;

public class ProposalBuilder {
    private final List<PatternRecommendation> patterns = Lists.newLinkedList();
    private final Image icon;
    private final IRecommendersCompletionContext rCtx;
    private JavaContext documentContext;
    private final JavaElementResolver resolver;
    private String variableName;

    public ProposalBuilder(Image icon, IRecommendersCompletionContext rCtx, JavaElementResolver resolver, String variableName) {
        this.icon = icon;
        this.rCtx = rCtx;
        this.resolver = resolver;
        this.variableName = variableName;
        this.createDocumentContext();
    }

    private void createDocumentContext() {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin == null) {
            throw new IllegalStateException("No default JavaPlugin found.");
        }
        AbstractJavaContextType type = (AbstractJavaContextType)plugin.getTemplateContextRegistry().getContextType("java");
        JavaContentAssistInvocationContext javaContext = this.rCtx.getJavaContext();
        Region region = this.rCtx.getReplacementRange();
        int offset = region.getOffset() - this.variableName.length();
        int length = Math.max(0, region.getLength() - 1);
        this.documentContext = new JavaContext((TemplateContextType)type, javaContext.getDocument(), offset, length, this.rCtx.getCompilationUnit());
        this.documentContext.setForceEvaluation(true);
    }

    public void addPattern(PatternRecommendation pattern) {
        this.patterns.add(pattern);
    }

    public List<JavaTemplateProposal> createProposals() {
        LinkedList result = Lists.newLinkedList();
        for (PatternRecommendation pattern : this.patterns) {
            try {
                result.add(new JavaTemplateProposal(this.createTemplate(pattern), (DocumentTemplateContext)this.documentContext, this.icon, pattern));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Template createTemplate(PatternRecommendation pattern) {
        String code = this.createTemplateCode(pattern);
        return new Template(pattern.getName(), pattern.getType().getClassName(), "java", code, false);
    }

    private String createTemplateCode(PatternRecommendation pattern) {
        TemplateCodeBuilder builder = new TemplateCodeBuilder();
        for (IMethodName method : pattern.getMethods()) {
            builder.addMethodCall(method);
        }
        return builder.build();
    }

    private class TemplateCodeBuilder {
        private final StringBuilder builder = new StringBuilder();
        private final String lineSeparator = System.getProperty("line.separator");
        private final Map<String, Integer> argumentCounter = Maps.newHashMap();

        private TemplateCodeBuilder() {
        }

        public void addMethodCall(IMethodName method) {
            this.appendVariableDeclaration(method);
            this.appendInvocationPrefix(method);
            this.appendMethodCall(method);
            this.builder.append(";");
            this.builder.append(this.lineSeparator);
        }

        private void appendVariableDeclaration(IMethodName method) {
            if (method.isInit()) {
                this.builder.append(String.format("${constructedType:newType(%s)}", this.getTypeIdentifier(method.getDeclaringType())));
                this.builder.append(" ");
                this.builder.append(this.getNewVariableNameFromMethod(method));
                this.builder.append(" = ");
            } else if (!method.isVoid()) {
                if (method.getReturnType().isPrimitiveType()) {
                    this.builder.append(this.getTypeIdentifier(method.getReturnType()));
                } else {
                    String typeIdentifier = this.getTypeIdentifier(method.getReturnType());
                    String returnTypeTemplateVariable = typeIdentifier.replaceAll("\\W", "_");
                    this.builder.append(String.format("${%s:newType(%s)}%s", returnTypeTemplateVariable, typeIdentifier, method.getReturnType().isArrayType() ? StringUtils.repeat((String)"[]", (int)method.getReturnType().getArrayDimensions()) : ""));
                }
                this.builder.append(" ");
                this.builder.append(this.getNewVariableNameFromMethod(method));
                this.builder.append(" = ");
            }
        }

        private void appendInvocationPrefix(IMethodName method) {
            if (method.isInit()) {
                this.builder.append("new ");
            } else if (!this.isImplicitThis() && !ProposalBuilder.this.variableName.isEmpty()) {
                this.builder.append(ProposalBuilder.this.variableName);
                this.builder.append(".");
            }
        }

        private void appendMethodCall(IMethodName method) {
            if (method.isInit()) {
                this.builder.append("${constructedType}");
            } else {
                this.builder.append(method.getName());
            }
            this.appendParameters(method);
        }

        private void appendParameters(IMethodName method) {
            Optional jdtMethod = ProposalBuilder.this.resolver.toJdtMethod(method);
            if (!jdtMethod.isPresent()) {
                throw new IllegalStateException("Method could not be resolved: " + method);
            }
            try {
                this.builder.append("(");
                String[] parameterNames = ((IMethod)jdtMethod.get()).getParameterNames();
                ITypeName[] parameterTypes = method.getParameterTypes();
                int i = 0;
                while (i < parameterNames.length) {
                    this.appendParameter(parameterNames[i], parameterTypes[i]);
                    if (i + 1 < parameterNames.length) {
                        this.builder.append(", ");
                    }
                    ++i;
                }
                this.builder.append(")");
            }
            catch (JavaModelException e) {
                throw new IllegalStateException(e);
            }
        }

        private void appendParameter(String parameterName, ITypeName parameterType) {
            String appendix = "";
            if (parameterType.isDeclaredType()) {
                if (!parameterType.getIdentifier().startsWith("Ljava")) {
                    String typeName = Names.vm2srcTypeName((String)parameterType.getIdentifier());
                    appendix = String.format(":var(%s)", typeName);
                }
            } else if (parameterType == VmTypeName.BOOLEAN) {
                appendix = ":link(false, true)";
            } else if (parameterType == VmTypeName.INT || parameterType == VmTypeName.DOUBLE || parameterType == VmTypeName.FLOAT || parameterType == VmTypeName.LONG || parameterType == VmTypeName.SHORT) {
                appendix = ":link(0)";
            }
            this.builder.append(String.format("${%s%s}", this.getParameterName(parameterName), appendix));
        }

        private String getParameterName(String parameterName) {
            String name;
            String string = name = parameterName.length() <= 5 && parameterName.startsWith("arg") ? "arg" : parameterName;
            if (this.argumentCounter.containsKey(name)) {
                Integer counter = this.argumentCounter.get(name);
                this.argumentCounter.put(name, counter + 1);
                return String.format("%s%s", name, counter + 1);
            }
            this.argumentCounter.put(name, 1);
            return name;
        }

        private String getNewVariableNameFromMethod(IMethodName method) {
            if (method.isInit()) {
                ProposalBuilder.this.variableName = "${unconstructed}";
                return String.format("${unconstructed:newName(%s)}", this.getTypeIdentifier(method.getDeclaringType()));
            }
            if (!method.isVoid()) {
                if (method.getName().startsWith("get")) {
                    return StringUtils.uncapitalize((String)method.getName().substring(3));
                }
                return StringUtils.uncapitalize((String)method.getReturnType().getClassName());
            }
            throw new IllegalStateException();
        }

        public String build() {
            return String.format("%s${cursor}", this.builder.toString());
        }

        private boolean isImplicitThis() {
            return !ProposalBuilder.this.rCtx.getReceiverType().isPresent() && ProposalBuilder.this.rCtx.getReceiverName().isEmpty();
        }

        private String getTypeIdentifier(ITypeName typeName) {
            return typeName.isPrimitiveType() ? Names.vm2srcSimpleTypeName((ITypeName)typeName) : typeName.getIdentifier().replace('/', '.').substring(1);
        }
    }
}

