/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.InternalExtendedCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnLocalName;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedAllocationExpression;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Region;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.internal.completion.rcp.ProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.eclipse.recommenders.utils.rcp.CompilerBindings;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRecommendersCompletionContext
implements IRecommendersCompletionContext {
    private static Logger log = LoggerFactory.getLogger(BaseRecommendersCompletionContext.class);
    public static ASTNode NULL = new ASTNode(){

        public StringBuffer print(int indent, StringBuffer output) {
            return output;
        }
    };
    private static Field fAssistScope;
    private static Field fAssistNode;
    private static Field fAssistNodeParent;
    private static Field fCompilationUnitDeclaration;
    private static Field fExtendedContext;
    private JavaContentAssistInvocationContext javaContext;
    private InternalCompletionContext coreContext;
    private IAstProvider astProvider;
    private ProposalCollectingCompletionRequestor collector;
    private InternalExtendedCompletionContext extCoreContext;
    private ASTNode assistNode;
    private ASTNode assistNodeParent;
    private Scope assistScope;
    private CompilationUnitDeclaration compilationUnitDeclaration;

    static {
        try {
            Class<InternalCompletionContext> clazzCtx = InternalCompletionContext.class;
            fExtendedContext = clazzCtx.getDeclaredField("extendedContext");
            fExtendedContext.setAccessible(true);
            Class<InternalExtendedCompletionContext> clazzExt = InternalExtendedCompletionContext.class;
            fAssistScope = clazzExt.getDeclaredField("assistScope");
            fAssistScope.setAccessible(true);
            fAssistNode = clazzExt.getDeclaredField("assistNode");
            fAssistNode.setAccessible(true);
            fAssistNodeParent = clazzExt.getDeclaredField("assistNodeParent");
            fAssistNodeParent.setAccessible(true);
            fCompilationUnitDeclaration = clazzExt.getDeclaredField("compilationUnitDeclaration");
            fCompilationUnitDeclaration.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BaseRecommendersCompletionContext(JavaContentAssistInvocationContext jdtContext, IAstProvider astProvider) {
        this.javaContext = jdtContext;
        this.astProvider = astProvider;
        this.coreContext = (InternalCompletionContext)Checks.cast((Object)jdtContext.getCoreContext());
        this.requestExtendedContext();
        this.initializeReflectiveFields();
    }

    private void initializeReflectiveFields() {
        try {
            this.extCoreContext = (InternalExtendedCompletionContext)fExtendedContext.get(this.coreContext);
            if (this.extCoreContext == null) {
                return;
            }
            this.assistNode = (ASTNode)fAssistNode.get(this.extCoreContext);
            this.assistNodeParent = (ASTNode)fAssistNodeParent.get(this.extCoreContext);
            this.assistScope = (Scope)fAssistScope.get(this.extCoreContext);
            this.compilationUnitDeclaration = (CompilationUnitDeclaration)fCompilationUnitDeclaration.get(this.extCoreContext);
        }
        catch (Exception e) {
            log.error("reflection initalizer failed.", (Throwable)e);
        }
    }

    private void requestExtendedContext() {
        ICompilationUnit cu = this.getCompilationUnit();
        this.collector = new ProposalCollectingCompletionRequestor(this.javaContext);
        try {
            cu.codeComplete(this.getInvocationOffset(), (CompletionRequestor)this.collector, (IProgressMonitor)new TimeoutProgressMonitor());
        }
        catch (Exception e) {
            RecommendersPlugin.logError((Exception)e, (String)"Exception during code completion", (Object[])new Object[0]);
        }
        this.coreContext = this.collector.getCoreContext();
    }

    public Optional<InternalCompletionContext> getCoreContext() {
        return Optional.fromNullable((Object)this.coreContext);
    }

    @Override
    public JavaContentAssistInvocationContext getJavaContext() {
        return this.javaContext;
    }

    @Override
    public IJavaProject getProject() {
        return this.javaContext.getProject();
    }

    @Override
    public int getInvocationOffset() {
        return this.javaContext.getInvocationOffset();
    }

    @Override
    public Region getReplacementRange() {
        int offset = this.getInvocationOffset();
        int length = this.getPrefix().length();
        return new Region(offset, length);
    }

    @Override
    public Optional<IMethod> getEnclosingMethod() {
        IJavaElement enclosing = (IJavaElement)this.getEnclosingElement().orNull();
        if (enclosing instanceof IMethod) {
            return Optional.of((Object)((IMethod)enclosing));
        }
        return Optional.absent();
    }

    @Override
    public Optional<IType> getEnclosingType() {
        IJavaElement enclosing = (IJavaElement)this.getEnclosingElement().orNull();
        if (enclosing instanceof IType) {
            return Optional.of((Object)((IType)enclosing));
        }
        return Optional.absent();
    }

    @Override
    public Optional<IJavaElement> getEnclosingElement() {
        if (this.coreContext == null) {
            return Optional.absent();
        }
        try {
            if (this.coreContext.isExtended()) {
                return Optional.fromNullable((Object)this.coreContext.getEnclosingElement());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return Optional.absent();
    }

    @Override
    public boolean hasEnclosingElement() {
        return this.getEnclosingElement().isPresent();
    }

    @Override
    public Optional<IType> getClosestEnclosingType() {
        if (!this.hasEnclosingElement()) {
            return Optional.absent();
        }
        IJavaElement enclosing = (IJavaElement)this.getEnclosingElement().get();
        if (enclosing instanceof IType) {
            return Optional.of((Object)((IType)enclosing));
        }
        IType type = (IType)enclosing.getAncestor(7);
        return Optional.fromNullable((Object)type);
    }

    @Override
    public boolean isCompletionInMethodBody() {
        return this.getEnclosingMethod().isPresent();
    }

    @Override
    public boolean isCompletionInTypeBody() {
        return this.getEnclosingType().isPresent();
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.javaContext.getCompilationUnit();
    }

    @Override
    public Optional<CompilationUnitDeclaration> getCompliationUnitDeclaration() {
        return Optional.fromNullable((Object)this.compilationUnitDeclaration);
    }

    @Override
    public Optional<Scope> getAssistScope() {
        return Optional.fromNullable((Object)this.assistScope);
    }

    @Override
    public CompilationUnit getAST() {
        return this.astProvider.get(this.getCompilationUnit());
    }

    @Override
    public Map<IJavaCompletionProposal, CompletionProposal> getProposals() {
        return this.collector.getProposals();
    }

    @Override
    public Optional<String> getExpectedTypeSignature() {
        if (this.coreContext == null) {
            return Optional.absent();
        }
        char[][] keys = this.coreContext.getExpectedTypesKeys();
        if (keys == null) {
            return Optional.absent();
        }
        if (keys.length < 1) {
            return Optional.absent();
        }
        String res = new String(keys[0]);
        return Optional.of((Object)res);
    }

    @Override
    public Set<ITypeName> getExpectedTypeNames() {
        ASTNode completion = (ASTNode)this.getCompletionNode().orNull();
        char[][] keys = this.isArgumentCompletion(completion) && this.getPrefix().isEmpty() ? this.simulateCompletionWithFakePrefix() : this.coreContext.getExpectedTypesKeys();
        return BaseRecommendersCompletionContext.createTypeNamesFromKeys(keys);
    }

    private boolean isArgumentCompletion(ASTNode completion) {
        return completion instanceof MessageSend || completion instanceof CompletionOnQualifiedAllocationExpression;
    }

    private char[][] simulateCompletionWithFakePrefix() {
        MutableObject res;
        block5: {
            res = new MutableObject(null);
            ICompilationUnit cu = this.getCompilationUnit();
            ICompilationUnit wc = null;
            int offset = this.getInvocationOffset();
            String fakePrefix = "___x";
            try {
                try {
                    wc = cu.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                    IBuffer buffer = wc.getBuffer();
                    String contents = buffer.getContents();
                    String newContents = String.valueOf(StringUtils.substring((String)contents, (int)0, (int)offset)) + fakePrefix + StringUtils.substring((String)contents, (int)offset, (int)contents.length());
                    buffer.setContents(newContents);
                    wc.codeComplete(offset + 1, new CompletionRequestor(true){

                        public boolean isExtendedContextRequired() {
                            return true;
                        }

                        public void acceptContext(CompletionContext context) {
                            res.setValue((Object)context.getExpectedTypesKeys());
                            super.acceptContext(context);
                        }

                        public void accept(CompletionProposal proposal) {
                        }
                    });
                }
                catch (JavaModelException x) {
                    RecommendersPlugin.log((CoreException)((Object)x));
                    this.discardWorkingCopy(wc);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.discardWorkingCopy(wc);
                throw throwable;
            }
            this.discardWorkingCopy(wc);
        }
        return (char[][])res.getValue();
    }

    private void discardWorkingCopy(ICompilationUnit wc) {
        try {
            if (wc != null) {
                wc.discardWorkingCopy();
            }
        }
        catch (JavaModelException x) {
            RecommendersPlugin.log((CoreException)((Object)x));
        }
    }

    public static Set<ITypeName> createTypeNamesFromKeys(char[][] keys) {
        if (keys == null) {
            return Collections.emptySet();
        }
        if (keys.length < 1) {
            return Collections.emptySet();
        }
        HashSet res = Sets.newHashSet();
        char[][] cArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            char[] key = cArray[n2];
            try {
                String descriptor = new String(key);
                descriptor = StringUtils.substringBeforeLast((String)descriptor, (String)";");
                res.add(VmTypeName.get((String)descriptor));
            }
            catch (Exception e) {
                log.error("Couldn't parse type name: '" + String.valueOf(key) + "'", (Throwable)e);
            }
            ++n2;
        }
        return res;
    }

    @Override
    public Optional<IType> getExpectedType() {
        IType res = this.javaContext.getExpectedType();
        return Optional.fromNullable((Object)res);
    }

    @Override
    public String getPrefix() {
        if (this.coreContext == null) {
            return "";
        }
        char[] token = this.coreContext.getToken();
        if (token == null) {
            return "";
        }
        return new String(token);
    }

    @Override
    public String getReceiverName() {
        ASTNode n = (ASTNode)this.getCompletionNode().orNull();
        if (n == null) {
            return "";
        }
        char[] name = null;
        if (n instanceof CompletionOnQualifiedNameReference) {
            CompletionOnQualifiedNameReference c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
            switch (c.binding.kind()) {
                case 1: 
                case 2: 
                case 3: {
                    VariableBinding b = (VariableBinding)c.binding;
                    name = b.name;
                }
            }
        } else if (n instanceof CompletionOnLocalName) {
            CompletionOnLocalName c = (CompletionOnLocalName)Checks.cast((Object)n);
            name = c.realName;
        } else if (n instanceof CompletionOnSingleNameReference) {
            CompletionOnSingleNameReference c = (CompletionOnSingleNameReference)Checks.cast((Object)n);
            name = c.token;
        } else if (n instanceof CompletionOnMemberAccess) {
            CompletionOnMemberAccess c = (CompletionOnMemberAccess)Checks.cast((Object)n);
            if (c.receiver instanceof ThisReference) {
                name = "this".toCharArray();
            } else if (c.receiver instanceof MessageSend) {
                name = null;
            } else if (c.fieldBinding() != null) {
                name = c.fieldBinding().name;
            } else if (c.localVariableBinding() != null) {
                name = c.localVariableBinding().name;
            }
        }
        return this.toString(name);
    }

    private String toString(char[] name) {
        if (name == null) {
            return "";
        }
        return new String(name).replace(" ", "");
    }

    @Override
    public Optional<String> getReceiverTypeSignature() {
        Optional<TypeBinding> opt = this.findReceiverTypeBinding();
        return this.toString((TypeBinding)opt.orNull());
    }

    private Optional<TypeBinding> findReceiverTypeBinding() {
        ASTNode n = (ASTNode)this.getCompletionNode().orNull();
        if (n == null) {
            return Optional.absent();
        }
        TypeBinding receiver = null;
        if (!(n instanceof CompletionOnLocalName)) {
            if (n instanceof CompletionOnSingleNameReference) {
                CompletionOnSingleNameReference c = (CompletionOnSingleNameReference)Checks.cast((Object)n);
                receiver = c.resolvedType;
            } else if (n instanceof CompletionOnQualifiedNameReference) {
                CompletionOnQualifiedNameReference c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
                switch (c.binding.kind()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        VariableBinding varBinding = (VariableBinding)c.binding;
                        receiver = varBinding.type;
                        break;
                    }
                    case 4: {
                        receiver = (TypeBinding)c.binding;
                    }
                }
            } else if (n instanceof CompletionOnMemberAccess) {
                CompletionOnMemberAccess c = (CompletionOnMemberAccess)Checks.cast((Object)n);
                receiver = c.actualReceiverType;
            }
        }
        return Optional.fromNullable(receiver);
    }

    private Optional<String> toString(TypeBinding receiver) {
        if (receiver == null) {
            return Optional.absent();
        }
        String res = new String(receiver.signature());
        return Optional.of((Object)res);
    }

    @Override
    public Optional<IType> getReceiverType() {
        Optional<TypeBinding> opt = this.findReceiverTypeBinding();
        if (!opt.isPresent()) {
            return Optional.absent();
        }
        TypeBinding b = (TypeBinding)opt.get();
        if (b instanceof MissingTypeBinding) {
            return Optional.absent();
        }
        return JdtUtils.createUnresolvedType((TypeBinding)b);
    }

    @Override
    public Optional<IMethodName> getMethodDef() {
        ASTNode node = (ASTNode)this.getCompletionNode().orNull();
        if (node == null) {
            return Optional.absent();
        }
        if (node instanceof CompletionOnMemberAccess) {
            CompletionOnMemberAccess n = (CompletionOnMemberAccess)Checks.cast((Object)node);
            if (n.receiver instanceof MessageSend) {
                MessageSend receiver = (MessageSend)n.receiver;
                MethodBinding binding = receiver.binding;
                return CompilerBindings.toMethodName((MethodBinding)binding);
            }
        }
        return Optional.absent();
    }

    private final class TimeoutProgressMonitor
    extends NullProgressMonitor {
        long limit = System.currentTimeMillis() + 5000L;

        private TimeoutProgressMonitor() {
        }

        public boolean isCanceled() {
            return System.currentTimeMillis() - this.limit > 0L;
        }
    }
}

