/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.providers;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.recommenders.extdoc.ClassSelfcallDirectives;
import org.eclipse.recommenders.extdoc.MethodSelfcallDirectives;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.internal.extdoc.rcp.wiring.ManualModelStoreWiring;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.TreeBag;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class SelfCallsProvider
extends ExtdocProvider {
    private final JavaElementResolver resolver;
    private final EventBus workspaceBus;
    private final ManualModelStoreWiring.ClassSelfcallsModelStore cStore;
    private final ManualModelStoreWiring.MethodSelfcallsModelStore mStore;

    @Inject
    public SelfCallsProvider(ManualModelStoreWiring.ClassSelfcallsModelStore cStore, ManualModelStoreWiring.MethodSelfcallsModelStore mStore, JavaElementResolver resolver, EventBus workspaceBus) {
        this.cStore = cStore;
        this.mStore = mStore;
        this.resolver = resolver;
        this.workspaceBus = workspaceBus;
    }

    @JavaSelectionSubscriber
    public void onTypeRootSelection(ITypeRoot root, JavaSelectionEvent event, Composite parent) throws ExecutionException {
        IType type = root.findPrimaryType();
        if (type != null) {
            this.onTypeSelection(type, event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onTypeSelection(IType type, JavaSelectionEvent event, Composite parent) throws ExecutionException {
        Optional model = this.cStore.aquireModel((IMember)type);
        if (model.isPresent()) {
            this.runSyncInUiThread(new TypeSelfcallDirectivesRenderer(type, (ClassSelfcallDirectives)model.get(), parent));
        }
    }

    @JavaSelectionSubscriber
    public void onMethodSelection(IMethod method, JavaSelectionEvent event, Composite parent) {
        IMethod current = method;
        while (current != null) {
            Optional selfcalls = this.mStore.aquireModel((IMember)current);
            if (selfcalls.isPresent()) {
                this.runSyncInUiThread(new MethodSelfcallDirectivesRenderer(method, (MethodSelfcallDirectives)selfcalls.get(), parent));
            }
            current = (IMethod)JdtUtils.findOverriddenMethod((IMethod)current).orNull();
        }
    }

    private class MethodSelfcallDirectivesRenderer
    implements Runnable {
        private final IMethod method;
        private final MethodSelfcallDirectives directive;
        private final Composite parent;
        private Composite container;

        public MethodSelfcallDirectivesRenderer(IMethod method, MethodSelfcallDirectives selfcalls, Composite parent) {
            this.method = method;
            this.directive = selfcalls;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            this.addDirectives();
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ExtdocUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
        }

        private void addHeader() {
            String message = String.format("Based on %d direct implementors of %s we created the following statistics. Implementors...", this.directive.getNumberOfDefinitions(), this.method.getElementName());
            ExtdocUtils.createLabel(this.container, message, true);
        }

        private void addDirectives() {
            int numberOfSubclasses = this.directive.getNumberOfDefinitions();
            TreeBag b = TreeBag.newTreeBag((Map)this.directive.getCalls());
            ExtdocUtils.renderMethodDirectivesBlock(this.container, (TreeBag<IMethodName>)b, numberOfSubclasses, SelfCallsProvider.this.workspaceBus, SelfCallsProvider.this.resolver, "calls ");
        }
    }

    private class TypeSelfcallDirectivesRenderer
    implements Runnable {
        private final IType type;
        private final ClassSelfcallDirectives directive;
        private final Composite parent;
        private Composite container;

        public TypeSelfcallDirectivesRenderer(IType type, ClassSelfcallDirectives selfcalls, Composite parent) {
            this.type = type;
            this.directive = selfcalls;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            this.addDirectives();
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ExtdocUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
        }

        private void addHeader() {
            String message = String.format("Based on %d direct subclasses of %s we created the following statistics:", this.directive.getNumberOfSubclasses(), this.type.getElementName());
            ExtdocUtils.createLabel(this.container, message, true);
        }

        private void addDirectives() {
            int numberOfSubclasses = this.directive.getNumberOfSubclasses();
            TreeBag b = TreeBag.newTreeBag((Map)this.directive.getCalls());
            ExtdocUtils.renderMethodDirectivesBlock(this.container, (TreeBag<IMethodName>)b, numberOfSubclasses, SelfCallsProvider.this.workspaceBus, SelfCallsProvider.this.resolver, "calls ");
        }
    }
}

