/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.repo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferResource;

public class TransferListener
extends AbstractTransferListener {
    private final IProgressMonitor monitor;
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();

    public TransferListener(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void transferInitiated(TransferEvent event) {
        String mode = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        String resourceName = String.valueOf(event.getResource().getRepositoryUrl()) + event.getResource().getResourceName();
        this.monitor.subTask(String.format("%s: %s", mode, resourceName));
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
    }

    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            this.monitor.subTask(this.getStatus(complete, total));
        }
    }

    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.remove(resource);
        this.monitor.subTask("Finished transfer: " + resource.getResourceName());
    }

    private String getStatus(long complete, long total) {
        String status = FileUtils.byteCountToDisplaySize((long)complete);
        if (total > 0L) {
            status = String.valueOf(status) + "/" + FileUtils.byteCountToDisplaySize((long)total);
        }
        return status;
    }

    public void transferFailed(TransferEvent event) {
        this.monitor.subTask("Transfer failed: " + event.getException().getLocalizedMessage());
    }

    public void transferCorrupted(TransferEvent event) {
        this.monitor.subTask("Transfer corrupted: " + event.getException().getLocalizedMessage());
    }
}

