/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.internal.rcp.repo.ClearModelRepositoryJob;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.repo.ModelRepositoryService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ModelsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public ModelsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(RecommendersPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.createRemoteRepositorySection();
        Button clearCaches = new Button(this.getFieldEditorParent(), 8);
        clearCaches.setText("Clear Caches");
        GridData data = new GridData(0x1000008, 0x1000000, false, false);
        data.horizontalSpan = 3;
        clearCaches.setLayoutData((Object)data);
        clearCaches.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ClearModelRepositoryJob(ModelRepositoryService.getRepository()).schedule();
            }
        });
    }

    private void createRemoteRepositorySection() {
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        layoutData.horizontalSpan = 3;
        Label headline = new Label(this.getFieldEditorParent(), 16384);
        headline.setText("Model Repository");
        headline.setLayoutData((Object)layoutData);
        headline.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Label description = new Label(this.getFieldEditorParent(), 16384);
        description.setText("All models used by Code Recommenders will be downloaded from this repository.");
        description.setLayoutData((Object)layoutData);
        StringButtonFieldEditor modelRepoFieldEditor = new StringButtonFieldEditor(RecommendersPlugin.P_REPOSITORY_URL, "URI:", this.getFieldEditorParent()){

            protected String changePressed() {
                InputDialog inputDialog = new InputDialog(this.getShell(), "Model Repository URI", "Please insert an URI for the Model Repository:", this.oldValue, new IInputValidator(){

                    public String isValid(String newText) {
                        if (ModelsPreferencePage.this.isValidRepoURI(newText)) {
                            return null;
                        }
                        return "Invalid URI";
                    }
                });
                if (inputDialog.open() == 0) {
                    return inputDialog.getValue();
                }
                return this.oldValue;
            }
        };
        modelRepoFieldEditor.getTextControl(this.getFieldEditorParent()).setEnabled(false);
        this.addField((FieldEditor)modelRepoFieldEditor);
        this.addField((FieldEditor)new BooleanFieldEditor(RecommendersPlugin.P_REPOSITORY_ENABLE_AUTO_DOWNLOAD, "Enable auto-download.", this.getFieldEditorParent()));
    }

    private boolean isValidRepoURI(String uri) {
        try {
            new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return true;
    }
}

