/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.osgi.framework.Bundle;

public class LoggingUtils {
    public static IStatus newStatus(int kind, Throwable exception, String pluginId, String messageFormat, Object ... messageArgs) {
        String message = messageFormat == null ? "" : String.format(messageFormat, messageArgs);
        Status res = new Status(kind, pluginId, message, exception);
        return res;
    }

    public static void logError(Throwable exception, Plugin plugin, String format, Object ... args) {
        IStatus error = LoggingUtils.newStatus(4, exception, LoggingUtils.getSymbolicName(plugin), format, args);
        LoggingUtils.log(error, plugin);
    }

    public static void logWarning(Throwable exception, Plugin plugin, String format, Object ... args) {
        IStatus status = LoggingUtils.newStatus(2, exception, LoggingUtils.getSymbolicName(plugin), format, args);
        LoggingUtils.log(status, plugin);
    }

    private static String getSymbolicName(Plugin plugin) {
        Checks.ensureIsNotNull((Object)plugin, (String)"logging requires a plug-in to be specified", (Object[])new Object[0]);
        Bundle bundle = plugin.getBundle();
        return bundle.getSymbolicName();
    }

    public static void log(IStatus status, Plugin plugin) {
        ILog log = plugin.getLog();
        try {
            log.log(status);
        }
        catch (Throwable throwable) {
            System.out.println(status);
        }
    }

    public static void log(CoreException exception, Plugin plugin) {
        IStatus status = exception.getStatus();
        LoggingUtils.log(status, plugin);
    }

    public static IStatus newInfo(Throwable exception, String pluginId, String messageFormat, Object ... methodArgs) {
        return LoggingUtils.newStatus(1, exception, pluginId, messageFormat, methodArgs);
    }

    public static IStatus newInfo(String pluginId, String messageFormat, Object ... methodArgs) {
        return LoggingUtils.newStatus(1, null, pluginId, messageFormat, methodArgs);
    }

    public static IStatus newError(Throwable exception, String pluginId, String messageFormat, Object ... methodArgs) {
        return LoggingUtils.newStatus(4, exception, pluginId, messageFormat, methodArgs);
    }

    public static IStatus newWarning(Throwable exception, String pluginId, String messageFormat, Object ... methodArgs) {
        return LoggingUtils.newStatus(2, exception, pluginId, messageFormat, methodArgs);
    }

    public static String toString(IStatus status) {
        StringBuilder sb = new StringBuilder();
        LoggingUtils.appendSeverityAndMessage(status, sb);
        LoggingUtils.appendException(status, sb);
        if (status.isMultiStatus()) {
            LoggingUtils.appendChildren(status, sb);
        }
        return sb.toString();
    }

    private static void appendSeverityAndMessage(IStatus status, StringBuilder sb) {
        sb.append(LoggingUtils.toSeverity(status)).append(": ").append(status.getMessage());
    }

    private static String toSeverity(IStatus status) {
        switch (status.getSeverity()) {
            case 8: {
                return "CANCEL";
            }
            case 4: {
                return "ERROR";
            }
            case 2: {
                return "WARN";
            }
            case 1: {
                return "INFO";
            }
            case 0: {
                return "OK";
            }
        }
        throw Throws.throwUnreachable();
    }

    private static void appendException(IStatus status, StringBuilder sb) {
        if (status.getException() != null) {
            sb.append(" ").append(status.getException());
        }
    }

    private static void appendChildren(IStatus status, StringBuilder sb) {
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            sb.append("\n").append(LoggingUtils.toString(child));
            ++n2;
        }
    }
}

