/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.console.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.rtp.core.model.SourceVersion;
import org.eclipse.rtp.core.util.ModelUtil;

public class CommandUtil {
    public SourceVersion getSourceVersions(List<String> parameter) {
        List<Source> sources = this.getSources();
        ArrayList<String> sourceName = new ArrayList<String>();
        sourceName.add(this.getSourceNameParameter(parameter));
        ModelUtil modelUtil = this.getModelUtil();
        List searchSources = modelUtil.searchSources(sourceName, sources);
        SourceVersion sourceVersion = modelUtil.searchSourceVerions(this.getVersionParameter(parameter), searchSources);
        return sourceVersion;
    }

    private String getSourceNameParameter(List<String> parameters) {
        return parameters.isEmpty() ? "" : parameters.get(0);
    }

    public List<SourceVersion> getSourceVersionsToUninstall(List<String> anyListOf) {
        ArrayList<SourceVersion> result = new ArrayList<SourceVersion>();
        List<Source> sources = this.getSources();
        ModelUtil modelUtil = this.getModelUtil();
        List sourceToUinstall = modelUtil.searchSources(anyListOf, sources);
        for (Source source : sourceToUinstall) {
            result.addAll(source.getVersions());
        }
        return result;
    }

    protected List<Source> getSources() {
        List sources = ModelUtil.getSourceProvider().getSources();
        return sources;
    }

    protected ModelUtil getModelUtil() {
        return new ModelUtil();
    }

    private String getVersionParameter(List<String> parameters) {
        return parameters.size() > 1 ? parameters.get(1) : "";
    }
}

