/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.modeling.ClassLocator;
import org.eclipse.sapphire.modeling.ResourceLocator;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.StandardLocalizationService;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.osgi.BundleLocator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResourceStore
extends UrlResourceStore {
    private final String bundleId;
    private final String path;
    private Bundle bundle;
    private ResourceLocator resourceLocator;
    private ClassLocator classLocator;

    public BundleResourceStore(String bundleId, String path) throws ResourceStoreException {
        super(BundleResourceStore.toUrl(bundleId, path, true));
        this.bundleId = bundleId;
        this.path = path;
    }

    public final Bundle bundle() {
        if (this.bundle == null) {
            this.bundle = BundleLocator.find(this.bundleId);
        }
        return this.bundle;
    }

    public boolean isOutOfDate() {
        return false;
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        return new StandardLocalizationService(locale){

            protected boolean load(Locale locale, Map<String, String> keyToText) {
                String bundleId = BundleResourceStore.this.bundleId;
                String path = BundleResourceStore.this.path;
                int lastDot = path.lastIndexOf(46);
                if (lastDot != -1) {
                    URL resFileUrl;
                    String resFilePath = path.substring(0, lastDot);
                    String localeString = locale.toString();
                    if (localeString.length() > 0) {
                        resFilePath = String.valueOf(resFilePath) + "_" + localeString;
                    }
                    if ((resFileUrl = BundleResourceStore.toUrl(bundleId, resFilePath = String.valueOf(resFilePath) + ".properties", false)) != null) {
                        boolean bl;
                        InputStream stream = resFileUrl.openStream();
                        try {
                            bl = 1.parse((InputStream)stream, keyToText);
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                return false;
                            }
                        }
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        return bl;
                    }
                }
                return false;
            }
        };
    }

    private static final URL toUrl(String bundleId, String path, boolean throwExceptionOnNotFound) {
        Bundle bundle = BundleLocator.find(bundleId);
        URL url = bundle.getResource(path);
        if (url == null && throwExceptionOnNotFound) {
            String msg = NLS.bind((String)Resources.couldNotFindBundleResource, (Object[])new Object[]{bundleId, path});
            throw new IllegalArgumentException(msg);
        }
        return url;
    }

    public <A> A adapt(Class<A> adapterType) {
        if (adapterType == ResourceLocator.class) {
            if (this.resourceLocator == null) {
                this.resourceLocator = new ResourceLocator(){

                    public URL find(String name) {
                        return BundleResourceStore.this.bundle().getResource(name);
                    }
                };
            }
            return adapterType.cast(this.resourceLocator);
        }
        if (adapterType == ClassLocator.class) {
            if (this.classLocator == null) {
                this.classLocator = new ClassLocator(){

                    public Class<?> find(String name) {
                        try {
                            return BundleResourceStore.this.bundle().loadClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return null;
                        }
                    }
                };
            }
            return adapterType.cast(this.classLocator);
        }
        if (adapterType == Bundle.class) {
            return adapterType.cast(this.bundle());
        }
        return (A)super.adapt(adapterType);
    }

    private static final class Resources
    extends NLS {
        public static String couldNotFindBundleResource;

        static {
            Resources.initializeMessages((String)BundleResourceStore.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

