/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.beans.FastBeanInfo;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.beans.IPropertyFilter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class BeanUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BeanUtility.class);
    private static final Object BEAN_INFO_CACHE_LOCK = new Object();
    private static final Map<CompositeObject, FastBeanInfo> BEAN_INFO_CACHE = new HashMap<CompositeObject, FastBeanInfo>();
    private static final Map<Class, Class> PRIMITIVE_COMPLEX_CLASS_MAP = new HashMap<Class, Class>();
    private static final Map<Class, Class> COMPLEX_PRIMITIVE_CLASS_MAP;

    static {
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Double.TYPE, Double.class);
        COMPLEX_PRIMITIVE_CLASS_MAP = new HashMap<Class, Class>();
        for (Map.Entry<Class, Class> entry : PRIMITIVE_COMPLEX_CLASS_MAP.entrySet()) {
            COMPLEX_PRIMITIVE_CLASS_MAP.put(entry.getValue(), entry.getKey());
        }
    }

    private BeanUtility() {
    }

    public static Map<String, Object> getProperties(Object from, Class<?> stopClazz, IPropertyFilter filter) throws ProcessingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            FastPropertyDescriptor[] props = BeanUtility.getFastPropertyDescriptors(from.getClass(), stopClazz, filter);
            int i = 0;
            while (i < props.length) {
                FastPropertyDescriptor fromProp = props[i];
                Method readMethod = fromProp.getReadMethod();
                if (readMethod != null) {
                    Object value = readMethod.invoke(from, null);
                    map.put(fromProp.getName(), value);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ProcessingException("object: " + from, e);
        }
        return map;
    }

    public static void setProperties(Object to, Map<String, Object> map, boolean lenient, IPropertyFilter filter) throws ProcessingException {
        FastBeanInfo toInfo = BeanUtility.getFastBeanInfo(to.getClass(), null);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                Method writeMethod;
                FastPropertyDescriptor desc = toInfo.getPropertyDescriptor(name);
                if (desc == null || filter != null && !filter.accept(desc) || (writeMethod = desc.getWriteMethod()) == null) continue;
                writeMethod.invoke(to, TypeCastUtility.castValue(value, writeMethod.getParameterTypes()[0]));
            }
            catch (Exception e) {
                if (lenient) {
                    LOG.warn("property " + name + " with value " + value, e);
                    continue;
                }
                throw new ProcessingException("property " + name + " with value " + value, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastBeanInfo getFastBeanInfo(Class<?> beanClass, Class<?> stopClass) {
        if (beanClass == null) {
            return new FastBeanInfo(beanClass, stopClass);
        }
        Object object = BEAN_INFO_CACHE_LOCK;
        synchronized (object) {
            CompositeObject key = new CompositeObject(beanClass, stopClass);
            FastBeanInfo info = BEAN_INFO_CACHE.get(key);
            if (info == null) {
                info = new FastBeanInfo(beanClass, stopClass);
                BEAN_INFO_CACHE.put(key, info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFastBeanInfoCache() {
        Object object = BEAN_INFO_CACHE_LOCK;
        synchronized (object) {
            BEAN_INFO_CACHE.clear();
        }
    }

    public static FastPropertyDescriptor[] getFastPropertyDescriptors(Class<?> clazz, Class<?> stopClazz, IPropertyFilter filter) throws IntrospectionException {
        FastBeanInfo info = BeanUtility.getFastBeanInfo(clazz, stopClazz);
        FastPropertyDescriptor[] a = info.getPropertyDescriptors();
        ArrayList<FastPropertyDescriptor> filteredProperties = new ArrayList<FastPropertyDescriptor>(a.length);
        int i = 0;
        while (i < a.length) {
            FastPropertyDescriptor pd = a[i];
            if (filter == null || filter.accept(pd)) {
                filteredProperties.add(pd);
            }
            ++i;
        }
        return filteredProperties.toArray(new FastPropertyDescriptor[filteredProperties.size()]);
    }

    public static <T> T createInstance(Class<T> c, Object ... parameters) throws ProcessingException {
        if (parameters == null || parameters.length == 0) {
            return BeanUtility.createInstance(c, null, null);
        }
        Class[] parameterTypes = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != null) {
                parameterTypes[i] = parameters[i].getClass();
            }
            ++i;
        }
        return BeanUtility.createInstance(c, parameterTypes, parameters);
    }

    public static <T> T createInstance(Class<T> c, Class<?>[] parameterTypes, Object[] parameters) throws ProcessingException {
        Constructor<T> ctor = BeanUtility.findConstructor(c, parameterTypes);
        if (ctor != null) {
            try {
                return ctor.newInstance(parameters);
            }
            catch (Throwable t) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Exception while instantiating new object [class=" + c + ", parameterTypes=" + Arrays.toString(parameterTypes) + ", parameters=" + Arrays.toString(parameters) + "]", t);
                }
                throw new ProcessingException("Exception while instantiating new object", t);
            }
        }
        return null;
    }

    public static <T> Constructor<T> findConstructor(Class<T> c, Class<?> ... parameterTypes) throws ProcessingException {
        if (c == null) {
            return null;
        }
        try {
            Constructor<T> ctor = c.getConstructor(parameterTypes);
            if (ctor != null) {
                return ctor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.debug("exact constructor does not exist");
        }
        if (parameterTypes == null || parameterTypes.length == 0) {
            return null;
        }
        TreeMap candidates = new TreeMap();
        Constructor<?>[] constructorArray = c.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            int distance = 0;
            Class<?>[] ctorParameters = ctor.getParameterTypes();
            if (ctorParameters.length == parameterTypes.length) {
                int i = 0;
                while (i < parameterTypes.length) {
                    int currentParamDistance = BeanUtility.computeTypeDistance(ctorParameters[i], parameterTypes[i]);
                    if (currentParamDistance == -1 && parameterTypes[i] != null) {
                        if (parameterTypes[i].isPrimitive()) {
                            currentParamDistance = BeanUtility.computeTypeDistance(ctorParameters[i], PRIMITIVE_COMPLEX_CLASS_MAP.get(parameterTypes[i]));
                        } else if (COMPLEX_PRIMITIVE_CLASS_MAP.containsKey(parameterTypes[i])) {
                            currentParamDistance = BeanUtility.computeTypeDistance(ctorParameters[i], COMPLEX_PRIMITIVE_CLASS_MAP.get(parameterTypes[i]));
                        }
                    }
                    if (currentParamDistance == -1) {
                        distance = -1;
                        break;
                    }
                    distance += currentParamDistance;
                    ++i;
                }
                if (distance >= 0) {
                    Constructor<?> candidate = ctor;
                    HashSet rankedCtors = (HashSet)candidates.get(distance);
                    if (rankedCtors == null) {
                        rankedCtors = new HashSet();
                        candidates.put(distance, rankedCtors);
                    }
                    rankedCtors.add(candidate);
                }
            }
            ++n2;
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Set ctors = (Set)candidates.firstEntry().getValue();
        if (ctors.isEmpty()) {
            return null;
        }
        if (ctors.size() == 1) {
            return (Constructor)CollectionUtility.firstElement(ctors);
        }
        throw new ProcessingException("More than one constructors found due to ambiguous parameter types [class=" + c + ", parameterTypes=" + Arrays.toString(parameterTypes) + "]");
    }

    public static int computeTypeDistance(Class<?> declaredType, Class<?> actualType) {
        Class<?>[] superClasses;
        if (declaredType == null) {
            return -1;
        }
        if (actualType == null) {
            return declaredType.isPrimitive() ? -1 : 0;
        }
        if (declaredType == actualType) {
            return 0;
        }
        if (!declaredType.isAssignableFrom(actualType)) {
            return -1;
        }
        Class<?> superClass = actualType.getSuperclass();
        Class<?>[] interfaces = actualType.getInterfaces();
        if (superClass == null) {
            superClasses = interfaces;
        } else {
            superClasses = new Class[interfaces.length + 1];
            superClasses[0] = superClass;
            System.arraycopy(interfaces, 0, superClasses, 1, interfaces.length);
        }
        int minSuperClassesDistance = -1;
        Class<?>[] classArray = superClasses;
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            int distance = BeanUtility.computeTypeDistance(declaredType, c);
            if (distance == 0) {
                minSuperClassesDistance = 0;
                break;
            }
            if (distance > 0) {
                minSuperClassesDistance = minSuperClassesDistance == -1 ? distance : Math.min(minSuperClassesDistance, distance);
            }
            ++n2;
        }
        if (minSuperClassesDistance == -1) {
            return -1;
        }
        return minSuperClassesDistance + 1;
    }
}

