/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.commons.exception.ProcessingException;

public class CompressedObjectReader {
    private ObjectInputStream in;
    private Object currentObject;

    public CompressedObjectReader(byte[] data) throws ProcessingException {
        try {
            this.currentObject = null;
            InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(data));
            this.in = new ObjectInputStream(iis);
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public boolean next() throws ProcessingException {
        try {
            this.currentObject = this.in.readObject();
            return true;
        }
        catch (EOFException eOFException) {
            this.currentObject = null;
            return false;
        }
        catch (Exception e) {
            this.currentObject = null;
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {}
    }
}

