/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;

public final class DateUtility {
    public static final long DAY_MILLIS = 86400000L;

    private DateUtility() {
    }

    public static String formatDate(Date d) {
        if (d == null) {
            return "";
        }
        Locale loc = LocaleThreadLocal.get();
        return DateFormat.getDateInstance(2, loc).format(d);
    }

    public static String formatTime(Date d) {
        if (d == null) {
            return "";
        }
        Locale loc = LocaleThreadLocal.get();
        return DateFormat.getTimeInstance(3, loc).format(d);
    }

    public static String formatDateTime(Date d) {
        if (d == null) {
            return "";
        }
        Locale loc = LocaleThreadLocal.get();
        return DateFormat.getDateTimeInstance(3, 3, loc).format(d);
    }

    public static String format(Date d, String pattern) {
        if (d == null || !StringUtility.hasText(pattern)) {
            return "";
        }
        Locale loc = LocaleThreadLocal.get();
        return new SimpleDateFormat(pattern, loc).format(d);
    }

    public static Date parse(String s, String pattern) {
        if (s == null) {
            return null;
        }
        try {
            Locale loc = LocaleThreadLocal.get();
            return new SimpleDateFormat(pattern, loc).parse(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("parse(\"" + s + "\",\"" + pattern + "\") failed", e);
        }
    }

    public static Date addHours(Date d, int hours) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date addDays(Date d, double count) {
        if (d == null) {
            return null;
        }
        int sec = (int)(count * 3600.0 * 24.0);
        int sign = 1;
        if (sec < 0) {
            sec = -sec;
            sign = -1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(5, sign * (sec / 3600 / 24));
        cal.add(11, sign * (sec / 3600 % 24));
        cal.add(12, sign * (sec / 60 % 60));
        cal.add(13, sign * (sec % 60));
        return cal.getTime();
    }

    public static Date addMonths(Date d, int count) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(2, count);
        return cal.getTime();
    }

    public static Date addYears(Date d, int count) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(1, count);
        return cal.getTime();
    }

    public static int getWeekday(Date d) {
        if (d == null) {
            return -1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int w = cal.get(7);
        return w;
    }

    public static Date truncDate(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendar(c);
        return new Date(c.getTime().getTime());
    }

    public static Date truncDateToMinute(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(13, 0);
        c.set(14, 0);
        return new Date(c.getTime().getTime());
    }

    public static Date truncDateToSecond(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(14, 0);
        return new Date(c.getTime().getTime());
    }

    public static Date truncDateToWeek(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToWeek(c, -1);
        return new Date(c.getTime().getTime());
    }

    public static Date truncDateToMonth(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToMonth(c);
        return new Date(c.getTime().getTime());
    }

    public static Date truncDateToYear(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToYear(c);
        return new Date(c.getTime().getTime());
    }

    public static void truncCalendar(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void truncCalendarToWeek(Calendar c, int adjustIncrement) {
        if (adjustIncrement < -1) {
            adjustIncrement = -1;
        }
        if (adjustIncrement > 1) {
            adjustIncrement = 1;
        }
        if (adjustIncrement == 0) {
            adjustIncrement = -1;
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int firstDayOfWeek = Calendar.getInstance().getFirstDayOfWeek();
        while (c.get(7) != firstDayOfWeek) {
            c.add(5, adjustIncrement);
        }
    }

    public static void truncCalendarToMonth(Calendar c) {
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void truncCalendarToYear(Calendar c) {
        c.set(2, 0);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static boolean isInRange(Date minDate, Date d, Date maxDate) {
        if (d == null || minDate == null || maxDate == null) {
            return false;
        }
        return minDate.compareTo(d) <= 0 && d.compareTo(maxDate) <= 0;
    }

    public static boolean intersects(Date fromDate, Date toDate, Date minDate, Date maxDate) {
        if (minDate == null || maxDate == null) {
            return false;
        }
        if (fromDate == null && toDate == null) {
            return false;
        }
        if (fromDate == null) {
            return toDate.compareTo(minDate) >= 0;
        }
        if (toDate == null) {
            return fromDate.compareTo(maxDate) <= 0;
        }
        return fromDate.compareTo(maxDate) <= 0 && toDate.compareTo(minDate) >= 0;
    }

    public static boolean isInDateRange(Date minDate, Date d, Date maxDate) {
        return DateUtility.isInRange(DateUtility.truncDate(minDate), DateUtility.truncDate(d), DateUtility.truncDate(maxDate));
    }

    public static Date nextDay(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(5, 1);
        Date dNew = new Date(c.getTime().getTime());
        return dNew;
    }

    public static Date max(Date ... a) {
        Date max = null;
        Date[] dateArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            if (d != null) {
                if (max == null) {
                    max = d;
                } else if (d.compareTo(max) > 0) {
                    max = d;
                }
            }
            ++n2;
        }
        return max;
    }

    public static Date min(Date ... a) {
        Date min = null;
        Date[] dateArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            if (d != null) {
                if (min == null) {
                    min = d;
                } else if (d.compareTo(min) < 0) {
                    min = d;
                }
            }
            ++n2;
        }
        return min;
    }

    public static boolean equals(Date a, Date b) {
        return a == b || a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isSameDay(Date a, Date b) {
        a = DateUtility.truncDate(a);
        b = DateUtility.truncDate(b);
        return DateUtility.equals(a, b);
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        int m1 = c.get(2);
        c.setTime(d2);
        int m2 = c.get(2);
        return m1 == m2;
    }

    public static boolean isWeekend(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        int dayOfWeek = c.get(7);
        return dayOfWeek == 7 || dayOfWeek == 1;
    }

    public static Date[] getCoveredDays(Date from, Date to) {
        if (from == null) {
            from = to;
        }
        if (to == null) {
            to = from;
        }
        if (from.compareTo(to) > 0) {
            to = from;
        }
        if (from.compareTo(to) == 0) {
            return new Date[]{DateUtility.truncDate(from)};
        }
        Calendar a = Calendar.getInstance();
        a.setTime(from);
        DateUtility.truncCalendar(a);
        Calendar b = Calendar.getInstance();
        b.setTime(to);
        b.add(14, -1);
        DateUtility.truncCalendar(b);
        long dayCount = (b.getTimeInMillis() + 43200000L - a.getTimeInMillis()) / 86400000L + 1L;
        Date[] array = new Date[(int)dayCount];
        int i = 0;
        while (i < array.length) {
            array[i] = a.getTime();
            a.add(5, 1);
            ++i;
        }
        return array;
    }

    public static <T> T nvl(T value, T valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull;
    }

    public static Date convertCalendar(Calendar c) {
        if (c == null) {
            return null;
        }
        return new Date(c.getTimeInMillis());
    }

    public static Calendar convertDate(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    public static Date toUtilDate(Date d) {
        if (d != null && d.getClass() != Date.class) {
            d = new Date(d.getTime());
        }
        return d;
    }

    public static Date createDateTime(Date date, Date time) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(time);
        cal1.set(11, cal2.get(11));
        cal1.set(12, cal2.get(12));
        cal1.set(13, cal2.get(13));
        cal1.set(14, cal2.get(14));
        return cal1.getTime();
    }

    public static Date convertDoubleTimeToDate(Number d) {
        if (d == null) {
            return null;
        }
        int m = d.doubleValue() < 0.0 ? (int)((long)(d.doubleValue() * 8.64E7 - 0.5) % 86400000L) : (int)((long)(d.doubleValue() * 8.64E7 + 0.5) % 86400000L);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(14, m % 1000);
        c.set(13, (m /= 1000) % 60);
        c.set(12, (m /= 60) % 60);
        c.set(11, (m /= 60) % 24);
        if (m < 0) {
            c.add(5, 1);
        }
        return c.getTime();
    }

    public static Double convertDateToDoubleTime(Date time) {
        if (time == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        double t = ((c.get(11) * 60 + c.get(12)) * 60 + c.get(13)) * 1000 + c.get(14);
        Double d = new Double(t / 8.64E7);
        if (d < 0.0) {
            d = new Double(0.0);
        }
        if (d > 1.0) {
            d = new Double(1.0);
        }
        return d;
    }
}

