/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.scout.commons.ArrayComparator;
import org.eclipse.scout.commons.CellRange;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.nls.NlsUtility;

public final class MatrixUtility {
    private MatrixUtility() {
    }

    public static Object[][] toTupels(Object data) {
        if (data == null) {
            return new Object[0][0];
        }
        if (data.getClass().isArray()) {
            if (data.getClass().getComponentType().isArray()) {
                if (Array.getLength(data) == 0) {
                    return new Object[0][0];
                }
                int rows = Array.getLength(data);
                int cols = Array.getLength(Array.get(data, 0));
                int count = rows * cols;
                Object[][] matrix = new Object[count / 2][2];
                int i = 0;
                while (i < matrix.length) {
                    int r = i * 2 / cols;
                    int c = i * 2 % cols;
                    matrix[i][0] = Array.get(Array.get(data, r), c);
                    r = (i * 2 + 1) / cols;
                    c = (i * 2 + 1) % cols;
                    matrix[i][1] = Array.get(Array.get(data, r), c);
                    ++i;
                }
                return matrix;
            }
            if (Array.getLength(data) == 0) {
                return new Object[0][0];
            }
            int n = Array.getLength(data);
            Object[][] matrix = new Object[n / 2][2];
            int i = 0;
            while (i < matrix.length) {
                matrix[i][0] = Array.get(data, i * 2);
                matrix[i][1] = Array.get(data, i * 2 + 1);
                ++i;
            }
            return matrix;
        }
        Object[][] matrix = new Object[1][2];
        matrix[0][1] = data;
        return matrix;
    }

    public static Object[][] union(Collection<Object> ... collections) {
        int rowCount = 0;
        int colCount = 0;
        Collection<Object>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<Object> list = collectionArray[n2];
            ++rowCount;
            if (list != null) {
                colCount = Math.max(colCount, list.size());
            }
            ++n2;
        }
        Object[][] matrix = new Object[rowCount][colCount];
        int r = 0;
        Collection<Object>[] collectionArray2 = collections;
        int n3 = collections.length;
        int n4 = 0;
        while (n4 < n3) {
            Collection<Object> list = collectionArray2[n4];
            if (list != null) {
                Object[] a = list.toArray();
                int c = 0;
                while (c < colCount && c < a.length) {
                    matrix[r][c] = a[c];
                    ++c;
                }
            }
            ++r;
            ++n4;
        }
        return matrix;
    }

    public static Object[][] union(Object ... matrixes) {
        int rowCount = 0;
        int colCount = 0;
        Object[] objectArray = matrixes;
        int n = matrixes.length;
        int n2 = 0;
        while (n2 < n) {
            Object m = objectArray[n2];
            if (m != null) {
                int r = Array.getLength(m);
                rowCount += r;
                if (r > 0) {
                    int c = Array.getLength(Array.get(m, 0));
                    colCount = Math.max(colCount, c);
                }
            }
            ++n2;
        }
        Object[][] matrix = new Object[rowCount][colCount];
        int r = 0;
        Object[] objectArray2 = matrixes;
        int n3 = matrixes.length;
        int n4 = 0;
        while (n4 < n3) {
            int mRows;
            Object m = objectArray2[n4];
            if (m != null && (mRows = Array.getLength(m)) > 0) {
                int i = 0;
                while (i < mRows) {
                    Object rowArray = Array.get(m, i);
                    int mCols = Array.getLength(rowArray);
                    int c = 0;
                    while (c < colCount && c < mCols) {
                        matrix[r][c] = Array.get(rowArray, c);
                        ++c;
                    }
                    ++r;
                    ++i;
                }
            }
            ++n4;
        }
        return matrix;
    }

    public static Object[][] toMatrix(Object ... values) {
        if (values == null) {
            return new Object[0][0];
        }
        Object[][] matrix = new Object[1][values.length];
        matrix[0] = values;
        return matrix;
    }

    public static Object[][] toMatrix(Object[] ... rows) {
        if (rows == null) {
            return new Object[0][0];
        }
        Object[][][] matrices = new Object[rows.length][1][];
        int i = 0;
        while (i < rows.length) {
            matrices[i][0] = rows[i];
            ++i;
        }
        return MatrixUtility.union((Object[])matrices);
    }

    public static Object[][] toMatrix(Collection<Object> ... rows) {
        return MatrixUtility.union(rows);
    }

    public static String toRange(int row, int col) {
        return CellRange.toRangeString(row, col);
    }

    public static String toRange(int row1, int col1, int row2, int col2) {
        return CellRange.toRangeString(row1, col1, row2, col2);
    }

    public static int rowCount(String range) {
        return new CellRange(range).getRowCount();
    }

    public static int columnCount(String range) {
        return new CellRange(range).getColumnCount();
    }

    public static int firstRow(String range) {
        return new CellRange(range).getFirstRow();
    }

    public static int lastRow(String range) {
        return new CellRange(range).getLastRow();
    }

    public static int firstColumn(String range) {
        return new CellRange(range).getFirstColumn();
    }

    public static int lastColumn(String range) {
        return new CellRange(range).getLastColumn();
    }

    public static <T> T getColumn(Object matrix, int columnIndex, Class<T> arrayType) {
        int rowCount = Array.getLength(matrix);
        int colCount = 0;
        if (rowCount > 0) {
            colCount = Array.getLength(Array.get(matrix, 0));
        }
        Object column = Array.newInstance(arrayType.getComponentType(), rowCount);
        if (rowCount > 0 && colCount > columnIndex) {
            int r = 0;
            while (r < rowCount) {
                Array.set(column, r, TypeCastUtility.castValue(Array.get(Array.get(matrix, r), columnIndex), arrayType.getComponentType()));
                ++r;
            }
        }
        return (T)column;
    }

    public static void sort(Object[][] data, int ... sortColumns) {
        MatrixUtility.sort(NlsUtility.getDefaultLocale(), data, sortColumns);
    }

    public static void sort(Locale locale, Object[][] data, int ... sortColumns) {
        if (data != null && data.length >= 2 && sortColumns != null && sortColumns.length > 0) {
            Arrays.sort(data, new ArrayComparator(locale, sortColumns));
        }
    }

    public static Object getColumn(Object matrix, int columnIndex) {
        int rowCount = Array.getLength(matrix);
        int colCount = 0;
        if (rowCount > 0) {
            colCount = Array.getLength(Array.get(matrix, 0));
        }
        Object column = Array.newInstance(matrix.getClass().getComponentType().getComponentType(), rowCount);
        if (rowCount > 0 && colCount > columnIndex) {
            int r = 0;
            while (r < rowCount) {
                Array.set(column, r, Array.get(Array.get(matrix, r), columnIndex));
                ++r;
            }
        }
        return column;
    }

    public static <T> T[] getColumn(T[][] matrix, int columnIndex) {
        int rowCount = Array.getLength(matrix);
        int colCount = 0;
        if (rowCount > 0) {
            colCount = Array.getLength(Array.get(matrix, 0));
        }
        Object[] column = (Object[])Array.newInstance(matrix.getClass().getComponentType().getComponentType(), rowCount);
        if (rowCount > 0 && colCount > columnIndex) {
            int r = 0;
            while (r < rowCount) {
                column[r] = Array.get(Array.get(matrix, r), columnIndex);
                ++r;
            }
        }
        return column;
    }

    public static Object lookup(Object matrix, Object lookupKey, int valueIndex) {
        int keyIndex = 0;
        int rowCount = Array.getLength(matrix);
        int colCount = 0;
        if (rowCount > 0) {
            colCount = Array.getLength(Array.get(matrix, 0));
        }
        if (rowCount > 0 && colCount > valueIndex && colCount > keyIndex) {
            int r = 0;
            while (r < rowCount) {
                Object row = Array.get(matrix, r);
                Object key = Array.get(row, keyIndex);
                if (key == lookupKey || key != null && key.equals(lookupKey)) {
                    return Array.get(row, valueIndex);
                }
                ++r;
            }
        }
        return null;
    }
}

