/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.exception.ProcessingException;

public final class SoapHandlingUtility {
    public static final String XMLNS_SOAPENV = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XMLNS_WSSE = "http://schemas.xmlsoap.org/ws/2002/04/secext";
    public static final QName SOAPENV_ENVELOPE_ELEMENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
    public static final QName SOAPENV_HEADER_ELEMENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    public static final QName WSSE_SECURITY_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Security");
    public static final QName WSSE_USERNAME_TOKEN_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "UsernameToken");
    public static final QName WSSE_USERNAME_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Username");
    public static final QName WSSE_PASSWORD_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Password");
    public static final String WSSE_PASSWORD_TYPE_ATTRIBUTE = "Type";
    public static final String DEFAULT_WSSE_USERNAME_TOKEN = "<wsse:Security soapenv:mustUnderstand=\"1\">  <wsse:UsernameToken>    <wsse:Username>${username}</wsse:Username>    <wsse:Password Type=\"http://scout.eclipse.org/security#Base64\">${password}</wsse:Password>  </wsse:UsernameToken></wsse:Security>";

    private SoapHandlingUtility() {
    }

    public static String createWsSecurityUserNameToken(String username, byte[] password) {
        if (username == null) {
            username = "";
        }
        username = username.replaceAll("[<>\"]", " ");
        if (password == null) {
            password = new byte[]{};
        }
        return DEFAULT_WSSE_USERNAME_TOKEN.replace("${username}", username).replace("${password}", Base64Utility.encode(password));
    }

    public static SAXParser createSaxParser(SAXParserFactory factory) throws ProcessingException {
        try {
            return factory.newSAXParser();
        }
        catch (Exception e) {
            throw new ProcessingException("building sax parser", e);
        }
    }

    public static SAXParserFactory createSaxParserFactory() throws ProcessingException {
        try {
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setXIncludeAware(false);
            factory.setSchema(schemaFact.newSchema());
            factory.setValidating(false);
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (Throwable throwable) {}
            try {
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Throwable throwable) {}
            try {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (Throwable throwable) {}
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory;
        }
        catch (Exception e) {
            throw new ProcessingException("building sax parser", e);
        }
    }
}

