/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger;

import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.logger.IScoutLogger;

public final class JavaLogUtility {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{([0-9]*)\\}", 32);
    private static final HashMap<Level, Integer> levelMap = new HashMap();

    static {
        levelMap.put(Level.OFF, 0);
        levelMap.put(Level.SEVERE, 1);
        levelMap.put(Level.WARNING, 2);
        levelMap.put(Level.INFO, 3);
        levelMap.put(Level.CONFIG, 3);
        levelMap.put(Level.FINE, 4);
        levelMap.put(Level.FINER, 4);
        levelMap.put(Level.FINEST, 5);
        levelMap.put(Level.ALL, 5);
    }

    private JavaLogUtility() {
    }

    public static int javaToScoutLevel(Level level) {
        Integer l = levelMap.get(level);
        if (l == null) {
            l = 2;
        }
        return l;
    }

    public static Level scoutToJavaLevel(int level) {
        switch (level) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.FINE;
            }
            case 5: {
                return Level.FINEST;
            }
        }
        return Level.WARNING;
    }

    public static LogRecord buildLogRecord(Class wrapperClass, Level level, String format, Object[] args) {
        String msg;
        if (format != null && args != null && args.length > 0) {
            Matcher m = VARIABLE_PATTERN.matcher(format);
            StringBuilder buf = new StringBuilder();
            int endPos = 0;
            int index = 0;
            while (m.find() && index < args.length) {
                buf.append(format.substring(endPos, m.start()));
                buf.append(args[index]);
                endPos = m.end();
                ++index;
            }
            if (endPos < format.length()) {
                buf.append(format.substring(endPos));
            }
            msg = buf.toString();
        } else {
            msg = format;
        }
        LogRecord record = new LogRecord(level, msg);
        StackTraceElement e = JavaLogUtility.getCallerLine(wrapperClass);
        if (e != null) {
            record.setSourceClassName(String.valueOf(e.getClassName()) + "." + e.getMethodName() + "(" + e.getFileName() + ":" + e.getLineNumber() + ")");
            record.setSourceMethodName(null);
        }
        return record;
    }

    private static StackTraceElement getCallerLine(Class wrapperClass) {
        try {
            StackTraceElement[] trace = new Exception().getStackTrace();
            int traceIndex = 0;
            HashSet<String> ignoredPackagePrefixes = new HashSet<String>();
            ignoredPackagePrefixes.add(IScoutLogger.class.getPackage().getName());
            if (wrapperClass != null) {
                ignoredPackagePrefixes.add(wrapperClass.getPackage().getName());
            }
            while (traceIndex < trace.length) {
                boolean found = true;
                for (String prefix : ignoredPackagePrefixes) {
                    if (!trace[traceIndex].getClassName().startsWith(prefix)) continue;
                    found = false;
                    break;
                }
                if (found) break;
                ++traceIndex;
            }
            if (traceIndex >= trace.length) {
                traceIndex = trace.length - 1;
            }
            return trace[traceIndex];
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

