/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.eclipse.scout.commons.serialization.IObjectReplacer;
import org.eclipse.scout.commons.serialization.IObjectSerializer;

public abstract class AbstractObjectSerializer
implements IObjectSerializer {
    private final IObjectReplacer m_objectReplacer;

    public AbstractObjectSerializer(IObjectReplacer objectReplacer) {
        this.m_objectReplacer = objectReplacer;
    }

    public IObjectReplacer getObjectReplacer() {
        return this.m_objectReplacer;
    }

    @Override
    public byte[] serialize(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serialize(bos, o);
        return bos.toByteArray();
    }

    @Override
    public void serialize(OutputStream out, Object o) throws IOException {
        if (out == null) {
            return;
        }
        ObjectOutputStream oos = null;
        try {
            oos = this.createObjectOutputStream(out, this.getObjectReplacer());
            oos.writeObject(o);
            oos.flush();
        }
        catch (Throwable throwable) {
            block15: {
                if (oos != null) {
                    try {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable2) {
                            oos = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable3) {
                        oos = null;
                        throw throwable3;
                    }
                    oos = null;
                }
            }
            throw throwable;
        }
        if (oos != null) {
            try {
                try {
                    oos.close();
                }
                catch (Throwable throwable) {
                    oos = null;
                }
            }
            finally {
                oos = null;
            }
        }
    }

    @Override
    public <T> T deserialize(byte[] buf, Class<T> expectedType) throws IOException, ClassNotFoundException {
        if (buf == null) {
            return null;
        }
        return this.deserialize(new ByteArrayInputStream(buf), expectedType);
    }

    @Override
    public <T> T deserialize(InputStream in, Class<T> expectedType) throws IOException, ClassNotFoundException {
        Object object;
        block13: {
            if (in == null) {
                return null;
            }
            ObjectInputStream ois = null;
            try {
                Object castedObject;
                ois = this.createObjectInputStream(in, this.getObjectReplacer());
                Object o = ois.readObject();
                if (expectedType != null && !expectedType.isInstance(o)) {
                    throw new IOException("deserialized object has unexpected type: expected '" + expectedType + "', actual '" + o.getClass() + "'.");
                }
                object = castedObject = o;
                if (ois == null) break block13;
            }
            catch (Throwable throwable) {
                block16: {
                    if (ois != null) {
                        try {
                            try {
                                ois.close();
                            }
                            catch (Throwable throwable2) {
                                ois = null;
                                break block16;
                            }
                        }
                        catch (Throwable throwable3) {
                            ois = null;
                            throw throwable3;
                        }
                        ois = null;
                    }
                }
                throw throwable;
            }
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable) {
                    ois = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                ois = null;
                throw throwable;
            }
            ois = null;
        }
        return (T)object;
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream out, IObjectReplacer objectReplacer) throws IOException {
        if (objectReplacer == null) {
            return new ObjectOutputStream(out);
        }
        return new ReplacingObjectOutputStream(out, objectReplacer);
    }

    protected abstract ObjectInputStream createObjectInputStream(InputStream var1, IObjectReplacer var2) throws IOException;

    private static class ReplacingObjectOutputStream
    extends ObjectOutputStream {
        private final IObjectReplacer m_objectReplacer;

        public ReplacingObjectOutputStream(OutputStream out, IObjectReplacer objectReplacer) throws IOException {
            super(out);
            this.m_objectReplacer = objectReplacer;
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            return this.m_objectReplacer.replaceObject(obj);
        }
    }
}

