/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.serialization;

import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.commons.osgi.BundleListClassLoader;
import org.eclipse.scout.commons.serialization.BundleObjectSerializer;
import org.eclipse.scout.commons.serialization.IObjectReplacer;
import org.eclipse.scout.commons.serialization.IObjectSerializer;
import org.eclipse.scout.commons.serialization.IObjectSerializerFactory;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.osgi.framework.Bundle;

public class BundleObjectSerializerFactory
implements IObjectSerializerFactory {
    private BundleListClassLoader m_bundleBasedClassLoader;

    public BundleObjectSerializerFactory() {
        String[] bundleOrderPrefixes = SerializationUtility.getBundleOrderPrefixes();
        Bundle[] orderedBundleLists = BundleInspector.getOrderedBundleList(bundleOrderPrefixes);
        this.m_bundleBasedClassLoader = new BundleListClassLoader(orderedBundleLists);
    }

    @Override
    public IObjectSerializer createObjectSerializer(IObjectReplacer objectReplacer) {
        return new BundleObjectSerializer(objectReplacer, this.m_bundleBasedClassLoader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.m_bundleBasedClassLoader;
    }
}

