/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.http.servletfilter.security;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.http.servletfilter.FilterConfigInjection;
import org.eclipse.scout.http.servletfilter.security.AbstractChainableSecurityFilter;
import org.eclipse.scout.http.servletfilter.security.PrincipalHolder;

public class BasicSecurityFilter
extends AbstractChainableSecurityFilter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BasicSecurityFilter.class);
    public static final String PROP_BASIC_ATTEMPT = "BasicSecurityFilter.basicAttempt";
    private HashMap<String, String> m_userDatabase;

    @Override
    public void init(FilterConfig config0) throws ServletException {
        super.init(config0);
        FilterConfigInjection.FilterConfig config = new FilterConfigInjection(config0, this.getClass()).getAnyConfig();
        String usersParam = config.getInitParameter("users");
        if (usersParam == null) {
            throw new ServletException("missing init-param with name 'users'");
        }
        this.m_userDatabase = new HashMap();
        String[] stringArray = usersParam.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] a = pair.trim().split("=", 2);
            this.m_userDatabase.put(a[0].toLowerCase(), a[1]);
            ++n2;
        }
    }

    @Override
    public void destroy() {
        this.m_userDatabase.clear();
    }

    @Override
    protected int negotiate(HttpServletRequest req, HttpServletResponse resp, PrincipalHolder holder) throws IOException, ServletException {
        int attempts;
        String h = req.getHeader("Authorization");
        if (h != null && h.matches("Basic .*")) {
            String[] a = new String(Base64Utility.decode((String)h.substring(6)), "ISO-8859-1").split(":", 2);
            String user = a[0].toLowerCase();
            String pass = a[1];
            if (user != null && pass != null && pass.equals(this.m_userDatabase.get(user))) {
                holder.setPrincipal((Principal)new SimplePrincipal(user));
                return 3;
            }
        }
        if ((attempts = this.getBasicAttempt(req)) > 2) {
            return 1;
        }
        this.setBasicAttept(req, attempts + 1);
        resp.setHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
        return 1;
    }

    private int getBasicAttempt(HttpServletRequest req) {
        int basicAtttempt = 0;
        Object attribute = req.getSession().getAttribute(PROP_BASIC_ATTEMPT);
        if (attribute instanceof Integer) {
            basicAtttempt = (Integer)attribute;
        }
        return basicAtttempt;
    }

    private void setBasicAttept(HttpServletRequest req, int attempts) {
        req.getSession().setAttribute(PROP_BASIC_ATTEMPT, (Object)attempts);
    }
}

