/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.jaxws.Activator;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.rt.server.IServerSession;

public final class SessionHelper {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SessionHelper.class);

    private SessionHelper() {
    }

    public static IServerSession createNewServerSession(final IServerSessionFactory factory) {
        if (factory == null) {
            return null;
        }
        Subject subject = null;
        try {
            subject = Subject.getSubject(AccessController.getContext());
        }
        catch (Exception e) {
            LOG.error("Failed to get subject of calling access context", (Throwable)e);
        }
        if (subject == null || subject.getPrincipals().size() == 0) {
            String principalName = Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.jaxws.txhandler.sessionfactory.principal");
            if (!StringUtility.hasText((String)principalName)) {
                LOG.warn("No subject found in calling AccessContext. That is why the principal 'anonymous' is registered with the subject. This subject is used to create sessions for transactional handlers as long as the request is not authenticated. The default principal can be changed by configuring the prinicipal in 'org.eclipse.scout.jaxws.txhandler.sessionfactory.principal' in config.ini.");
                principalName = "anonymous";
            }
            subject = new Subject();
            subject.getPrincipals().add((Principal)new SimplePrincipal(principalName));
            subject.setReadOnly();
        }
        IServerSession serverSession = null;
        try {
            serverSession = Subject.doAs(subject, new PrivilegedExceptionAction<IServerSession>(){

                @Override
                public IServerSession run() throws Exception {
                    return factory.create();
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to create server session.", (Throwable)e);
            return null;
        }
        if (serverSession == null) {
            LOG.error("Session created by factory '" + factory.getClass().getName() + "' must not be null.");
        }
        return serverSession;
    }
}

