/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.security.consumer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler;

@ScoutTransaction
public class BasicAuthenticationHandler
implements IAuthenticationHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BasicAuthenticationHandler.class);
    protected String m_username;
    protected String m_password;

    public final boolean handleMessage(SOAPMessageContext context) {
        boolean outbound = (Boolean)TypeCastUtility.castValue((Object)context.get((Object)"javax.xml.ws.handler.message.outbound"), Boolean.TYPE);
        if (!outbound) {
            return true;
        }
        if (this.m_username == null || this.m_password == null) {
            throw new WebServiceException("Invalid credentials configured.");
        }
        try {
            Map<String, List<String>> httpRequestHeaders = this.getHttpRequestHeaders(context);
            if (httpRequestHeaders == null) {
                httpRequestHeaders = new HashMap<String, List<String>>();
            }
            this.installAuthHeader(httpRequestHeaders);
            context.put((Object)"javax.xml.ws.http.request.headers", httpRequestHeaders);
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to install Basic Authentication headers", (Throwable)e);
            return false;
        }
    }

    protected void installAuthHeader(Map<String, List<String>> httpRequestHeaders) throws Exception {
        String credentials = StringUtility.join((String)":", (Object[])new Object[]{this.m_username, this.m_password});
        String credentialsEncoded = Base64Utility.encode((byte[])credentials.getBytes());
        LinkedList<String> basicAuthToken = new LinkedList<String>();
        basicAuthToken.add("Basic " + credentialsEncoded);
        httpRequestHeaders.put("Authorization", basicAuthToken);
    }

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    private Map<String, List<String>> getHttpRequestHeaders(SOAPMessageContext context) {
        return (Map)context.get((Object)"javax.xml.ws.http.request.headers");
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
    }

    @Override
    public void setUsername(String username) {
        this.m_username = username;
    }
}

