/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.model.ws.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.scout.nls.sdk.extension.INlsProjectProvider;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsJdtUtility;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.services.model.ws.NlsServiceType;
import org.eclipse.scout.nls.sdk.services.model.ws.project.ServiceNlsProject;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.util.internal.typecache.TypeHierarchy;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;

public class ServiceNlsProjectProvider
implements INlsProjectProvider {
    public static IType[] getRegisteredTextProviderTypes() throws JavaModelException {
        return ServiceNlsProjectProvider.getRegisteredTextProviderTypes(null, null);
    }

    private static IType[] getRegisteredTextProviderTypes(Boolean returnDocServices, String[] projectFilter) throws JavaModelException {
        IExtension[] allServiceExtensions;
        IType superType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.text.AbstractDynamicNlsTextProviderService");
        if (superType == null) {
            return null;
        }
        IType[] serviceImpls = TypeCacheAccessor.getHierarchyCache().getPrimaryTypeHierarchy(superType).getAllSubtypes(superType, new ITypeFilter(){

            public boolean accept(IType type) {
                try {
                    ISourceRange range = type.getSourceRange();
                    return range != null && range.getOffset() != -1;
                }
                catch (JavaModelException e) {
                    NlsCore.logWarning((String)("Attempt to access source range of type '" + type.getFullyQualifiedName() + "' failed. Type will be skipped."), (Throwable)e);
                    return false;
                }
            }
        });
        HashMap<String, IType> typeMap = new HashMap<String, IType>(serviceImpls.length);
        IType[] iTypeArray = serviceImpls;
        int n = serviceImpls.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            typeMap.put(t.getFullyQualifiedName(), t);
            ++n2;
        }
        class TextProviderService {
            private final IType textProvider;
            private final IJavaProject project;

            TextProviderService(IType t) {
                this.textProvider = t;
                this.project = t.getJavaProject();
            }

            public int hashCode() {
                int ret = 1;
                ret = ret * 27 + this.textProvider.getFullyQualifiedName().hashCode();
                ret = ret * 19 + this.project.getElementName().hashCode();
                return ret;
            }

            public boolean equals(Object obj) {
                if (obj instanceof TextProviderService) {
                    TextProviderService o = (TextProviderService)obj;
                    return this.textProvider.getFullyQualifiedName().equals(o.textProvider.getFullyQualifiedName()) && this.project.getElementName().equals(o.project.getElementName());
                }
                return false;
            }
        }
        class TextProviderServiceDeclaration {
            private final TextProviderService svc;
            private final float prio;

            TextProviderServiceDeclaration(TextProviderService s, float p) {
                this.svc = s;
                this.prio = p;
            }

            static /* synthetic */ TextProviderService access$1(TextProviderServiceDeclaration textProviderServiceDeclaration) {
                return textProviderServiceDeclaration.svc;
            }
        }
        HashMap<TextProviderService, TextProviderServiceDeclaration> result = new HashMap<TextProviderService, TextProviderServiceDeclaration>(serviceImpls.length);
        IExtension[] iExtensionArray = allServiceExtensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.scout.service.services", true);
        int n3 = allServiceExtensions.length;
        int n4 = 0;
        while (n4 < n3) {
            IExtension e = iExtensionArray[n4];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n5 = iConfigurationElementArray.length;
            int n6 = 0;
            while (n6 < n5) {
                String serviceClassDef;
                IType serviceImpl;
                IConfigurationElement c = iConfigurationElementArray[n6];
                if ("service".equals(c.getName()) && ServiceNlsProjectProvider.acceptsFilter(returnDocServices, projectFilter, serviceImpl = (IType)typeMap.get(serviceClassDef = c.getAttribute("class")))) {
                    TextProviderService s = new TextProviderService(serviceImpl);
                    TextProviderServiceDeclaration d = new TextProviderServiceDeclaration(s, ServiceNlsProjectProvider.getPriority(serviceImpl, c));
                    TextProviderServiceDeclaration existing = (TextProviderServiceDeclaration)result.get(s);
                    if (existing == null || existing.prio < d.prio) {
                        result.put(s, d);
                    }
                }
                ++n6;
            }
            ++n4;
        }
        TextProviderServiceDeclaration[] sortedArrayHighestPrioFirst = result.values().toArray(new TextProviderServiceDeclaration[result.size()]);
        Arrays.sort(sortedArrayHighestPrioFirst, new Comparator<TextProviderServiceDeclaration>(){

            @Override
            public int compare(TextProviderServiceDeclaration o1, TextProviderServiceDeclaration o2) {
                return new Float(o2.prio).compareTo(new Float(o1.prio));
            }
        });
        IType[] returnValueSorted = new IType[sortedArrayHighestPrioFirst.length];
        int i = 0;
        while (i < returnValueSorted.length) {
            returnValueSorted[i] = TextProviderServiceDeclaration.access$1(sortedArrayHighestPrioFirst[i]).textProvider;
            ++i;
        }
        return returnValueSorted;
    }

    private static boolean acceptsFilter(Boolean returnDocServices, String[] projects, IType candidate) throws JavaModelException {
        boolean acceptsDocPart;
        if (candidate == null) {
            return false;
        }
        boolean bl = acceptsDocPart = returnDocServices == null || returnDocServices == ServiceNlsProjectProvider.isDocsService(candidate);
        if (acceptsDocPart) {
            if (candidate.isReadOnly()) {
                return true;
            }
            if (projects == null) {
                return true;
            }
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (candidate.getJavaProject().getProject().getName().equals(p)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean isDocsService(IType service) throws JavaModelException {
        String docsInterfaceClassName = "org.eclipse.scout.rt.shared.services.common.text.IDocumentationTextProviderService".substring("org.eclipse.scout.rt.shared.services.common.text.IDocumentationTextProviderService".lastIndexOf(46) + 1);
        TypeHierarchy th = TypeCacheAccessor.getHierarchyCache().getSuperHierarchy(service);
        IType[] iTypeArray = th.getAllSuperInterfaces(service);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType ifs = iTypeArray[n2];
            if (docsInterfaceClassName.equals(ifs.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static float getPriority(IType registration, IConfigurationElement config) {
        String xmlRank = config.getAttribute("ranking");
        if (xmlRank != null && xmlRank.length() > 0) {
            try {
                return Float.parseFloat(xmlRank);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        try {
            IAnnotation a = JdtUtility.getAnnotation((IAnnotatable)registration, (String)"org.eclipse.scout.commons.annotations.Priority");
            Double val = JdtUtility.getNumericAnnotationValue((IAnnotation)a, (String)"value");
            if (val != null) {
                return val.floatValue();
            }
        }
        catch (Exception exception) {}
        return 0.0f;
    }

    private ServiceNlsProject getServiceNlsProject(IType serviceType) {
        if (!TypeUtility.exists((IJavaElement)serviceType)) {
            NlsCore.logError((String)("nls service type '" + serviceType.getFullyQualifiedName() + "' does not exist"));
            return null;
        }
        NlsServiceType type = new NlsServiceType(serviceType);
        if (type.getTranslationsFolderName() == null) {
            NlsCore.logWarning((String)("The NLS Service for Type '" + serviceType.getFullyQualifiedName() + "' could not be parsed. Ensure that the method '" + "getDynamicNlsBaseName" + "' is available and returns a String literal like \"resources.texts.Texts\" directly."));
            return null;
        }
        return new ServiceNlsProject(type);
    }

    private INlsProject getNlsProjectTree(boolean returnDocServices, String[] projectFilter) throws CoreException {
        return this.getNlsProjectTree(ServiceNlsProjectProvider.getRegisteredTextProviderTypes(returnDocServices, projectFilter));
    }

    private INlsProject getNlsProjectTree(IType[] textProviderServices) throws CoreException {
        ServiceNlsProject previous = null;
        ServiceNlsProject root = null;
        IType[] iTypeArray = textProviderServices;
        int n = textProviderServices.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            ServiceNlsProject p = this.getServiceNlsProject(type);
            if (p != null) {
                if (root == null) {
                    root = p;
                }
                if (previous != null) {
                    previous.setParent((INlsProject)p);
                }
                previous = p;
            } else if (root == null) {
                throw new CoreException((IStatus)new ScoutStatus("The NLS Service for Type " + type.getFullyQualifiedName() + " could not be parsed."));
            }
            ++n2;
        }
        return root;
    }

    private static String[] getProjectNames(IScoutBundle[] scoutBundles) {
        if (scoutBundles == null || scoutBundles.length < 1) {
            return null;
        }
        String[] ret = new String[scoutBundles.length];
        int i = 0;
        while (i < scoutBundles.length) {
            ret[i] = scoutBundles[i].getBundleName();
            ++i;
        }
        return ret;
    }

    private static void addBundlesRec(IScoutProject p, HashSet<IScoutBundle> collector) {
        IScoutBundle[] iScoutBundleArray = p.getAllScoutBundles();
        int n = iScoutBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle b = iScoutBundleArray[n2];
            collector.add(b);
            ++n2;
        }
        iScoutBundleArray = p.getSubProjects();
        n = iScoutBundleArray.length;
        n2 = 0;
        while (n2 < n) {
            IScoutBundle subP = iScoutBundleArray[n2];
            ServiceNlsProjectProvider.addBundlesRec((IScoutProject)subP, collector);
            ++n2;
        }
    }

    private static IScoutBundle[] getScoutBundlesForType(IType type) {
        IScoutBundle b = ScoutSdkCore.getScoutWorkspace().getScoutBundle(type.getJavaProject().getProject());
        if (b != null) {
            IScoutProject root = b.getScoutProject();
            return ServiceNlsProjectProvider.getScoutBundlesForProject(root);
        }
        return null;
    }

    private static IScoutBundle[] getScoutBundlesForProject(IScoutProject p) {
        if (p == null) {
            return null;
        }
        HashSet<IScoutBundle> collector = new HashSet<IScoutBundle>();
        IScoutProject root = p;
        while (root.getParentProject() != null) {
            root = root.getParentProject();
        }
        ServiceNlsProjectProvider.addBundlesRec(root, collector);
        return collector.toArray(new IScoutBundle[collector.size()]);
    }

    private INlsProject getNlsProjectTree(IType type) throws CoreException {
        IType[] nlsProviders = ServiceNlsProjectProvider.getRegisteredTextProviderTypes(ServiceNlsProjectProvider.isDocsService(type), ServiceNlsProjectProvider.getProjectNames(ServiceNlsProjectProvider.getScoutBundlesForType(type)));
        if (nlsProviders == null) {
            return null;
        }
        String searchString = ServiceNlsProjectProvider.getTypeIdentifyer(type);
        ArrayList<IType> filtered = new ArrayList<IType>(nlsProviders.length);
        boolean minFound = false;
        IType[] iTypeArray = nlsProviders;
        int n = nlsProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (ServiceNlsProjectProvider.getTypeIdentifyer(t).equals(searchString) && !minFound) {
                minFound = true;
            }
            if (minFound) {
                filtered.add(t);
            }
            ++n2;
        }
        return this.getNlsProjectTree(filtered.toArray(new IType[filtered.size()]));
    }

    private static String getTypeIdentifyer(IType t) {
        return String.valueOf(t.getJavaProject().getProject().getName()) + "/" + t.getFullyQualifiedName();
    }

    public INlsProject getProject(Object[] args) {
        if (args != null) {
            if (args.length == 1) {
                if (args[0] instanceof IType) {
                    return this.getProjectByTextServiceType((IType)args[0]);
                }
                if (args[0] instanceof IFile) {
                    return this.getProjectByTextServiceFile((IFile)args[0]);
                }
            } else if (args.length == 2 && args[0] instanceof IType) {
                boolean returnDocServices;
                IType t1 = (IType)args[0];
                boolean bl = returnDocServices = !"org.eclipse.scout.rt.shared.TEXTS".equals(t1.getFullyQualifiedName());
                if (args[1] instanceof IScoutProject || args[1] == null) {
                    return this.getAllProjects(returnDocServices, ServiceNlsProjectProvider.getScoutBundlesForProject((IScoutProject)args[1]));
                }
                if (args[1] instanceof IType) {
                    return this.getAllProjects(returnDocServices, ServiceNlsProjectProvider.getScoutBundlesForType((IType)args[1]));
                }
            }
        }
        return null;
    }

    private INlsProject getAllProjects(boolean returnDocServices, IScoutBundle[] wsBundles) {
        try {
            return this.getNlsProjectTree(returnDocServices, ServiceNlsProjectProvider.getProjectNames(wsBundles));
        }
        catch (CoreException e) {
            NlsCore.logWarning((String)"Could not load full text provider service tree.", (Throwable)e);
            return null;
        }
    }

    private INlsProject getProjectByTextServiceFile(IFile f) {
        try {
            IType type = NlsJdtUtility.getITypeForFile((IFile)f);
            if (type != null) {
                return NlsCore.getNlsWorkspace().getNlsProject(new Object[]{type});
            }
        }
        catch (CoreException e) {
            NlsCore.logWarning((String)("Could not load text provider services for file: " + f.getFullPath().toString()), (Throwable)e);
        }
        return null;
    }

    private INlsProject getProjectByTextServiceType(IType textservice) {
        try {
            return this.getNlsProjectTree(textservice);
        }
        catch (CoreException e) {
            NlsCore.logWarning((String)("Could not load text provider services for " + textservice.getFullyQualifiedName()), (Throwable)e);
            return null;
        }
    }
}

