/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.operation;

import java.util.LinkedList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.services.model.ws.NlsServiceType;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.service.ServiceDeleteOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class DeleteServiceNlsProjectOperation
implements IOperation {
    private final IType m_serviceClass;
    private final IScoutBundle m_scoutBundle;

    public DeleteServiceNlsProjectOperation(IType serviceType, IScoutBundle bundle) {
        this.m_serviceClass = serviceType;
        this.m_scoutBundle = bundle;
    }

    public String getOperationName() {
        return "Delete NLS Service Project";
    }

    public void validate() throws IllegalArgumentException {
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        final NlsServiceType t = new NlsServiceType(this.getServiceClass());
        if (t.getJavaProject() != null && t.getTranslationsFolderName() != null) {
            IProject p = t.getJavaProject().getProject();
            final IFolder propertiesFolder = p.getFolder(t.getTranslationsFolderName());
            propertiesFolder.refreshLocal(2, monitor);
            final LinkedList<IFolder> filesToDelete = new LinkedList<IFolder>();
            if (propertiesFolder != null && propertiesFolder.exists()) {
                final boolean[] otherFilesExistInFolder = new boolean[1];
                propertiesFolder.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource == propertiesFolder) {
                            return true;
                        }
                        if (resource.getType() == 1) {
                            if (resource.getName().startsWith(t.getTranslationsPrefix())) {
                                filesToDelete.add(resource);
                            } else {
                                otherFilesExistInFolder[0] = true;
                            }
                        }
                        return false;
                    }
                }, 1, 0);
                if (!otherFilesExistInFolder[0]) {
                    filesToDelete.add(propertiesFolder);
                }
            }
            ServiceDeleteOperation del = new ServiceDeleteOperation();
            del.setServiceImplementation(this.getServiceClass());
            del.setAdditionalResourcesToBeDeleted(filesToDelete.toArray(new IResource[filesToDelete.size()]));
            del.validate();
            del.run(monitor, workingCopyManager);
            this.getScoutBundle().getScoutProject().clearNlsProjectCache();
        } else {
            NlsCore.logWarning((String)"Invalid Text Provider Service to be deleted. Cannot parse the resources.");
        }
    }

    public IScoutBundle getScoutBundle() {
        return this.m_scoutBundle;
    }

    public IType getServiceClass() {
        return this.m_serviceClass;
    }
}

