/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws;

import java.beans.PropertyChangeListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.commons.nls.DynamicNls;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsTypeUtility;
import org.eclipse.scout.nls.sdk.simple.model.ws.INlsType;

public class NlsType
implements INlsType {
    public static final String RESOURCE_BUNDLE_FIELD_NAME = "RESOURCE_BUNDLE_NAME";
    public static final String PROP_TRANSLATION_FOLDER_NAME = "translationFolderName";
    public static final String PROP_TRANSLATION_FILE_PREFIX = "translationFilePrefix";
    public static final String PROP_SUPER_TYPE = "superType";
    private static final Pattern REGEX_RESOURCE_BUNDLE_FIELD = Pattern.compile("RESOURCE_BUNDLE_NAME\\s*=\\s*\\\"([^\\\"]*)\\\"\\s*\\;", 32);
    protected final IType m_type;
    protected IType[] m_superTypes;
    protected final BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);

    public NlsType(IType type) {
        this.m_type = type;
        if (!this.m_type.isReadOnly()) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new P_NlsResourceChangeListener(), 1);
        }
        this.reload();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    protected String getBundleValue() throws JavaModelException {
        Matcher matcher;
        IField field = this.m_type.getField(RESOURCE_BUNDLE_FIELD_NAME);
        if (NlsTypeUtility.exists((IJavaElement)field) && (matcher = REGEX_RESOURCE_BUNDLE_FIELD.matcher(field.getSource())).find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected void loadSuperTypeHierarchy() throws JavaModelException {
        ITypeHierarchy typeHierarchy = this.m_type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        this.m_superTypes = typeHierarchy.getAllSuperclasses(this.m_type);
        if (this.m_superTypes.length > 0 && NlsTypeUtility.exists((IJavaElement)this.m_superTypes[0]) && !this.m_superTypes[0].getFullyQualifiedName().equals(DynamicNls.class.getName()) && !this.m_superTypes[0].getFullyQualifiedName().equals(Object.class.getName())) {
            this.m_propertySupport.setProperty(PROP_SUPER_TYPE, (Object)this.m_superTypes[0]);
        }
    }

    public void reload() {
        try {
            String bundleValue = this.getBundleValue();
            if (bundleValue != null) {
                String[] splitedValue = bundleValue.split("\\.");
                String filePrefix = splitedValue[splitedValue.length - 1];
                String folderName = "";
                int i = 0;
                while (i < splitedValue.length - 1) {
                    folderName = String.valueOf(folderName) + "/" + splitedValue[i];
                    ++i;
                }
                this.setTranslationFolderName(folderName);
                this.setTranslationFilePrefix(filePrefix);
            }
            this.loadSuperTypeHierarchy();
        }
        catch (JavaModelException javaModelException) {
            NlsCore.logError((String)("could not reload NLS type '" + this.m_type.getFullyQualifiedName() + "'"));
        }
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    protected void setTranslationFolderName(String name) {
        this.m_propertySupport.setPropertyString(PROP_TRANSLATION_FOLDER_NAME, name);
    }

    @Override
    public String getTranslationsFolderName() {
        return this.m_propertySupport.getPropertyString(PROP_TRANSLATION_FOLDER_NAME);
    }

    protected void setTranslationFilePrefix(String filePrefix) {
        this.m_propertySupport.setPropertyString(PROP_TRANSLATION_FILE_PREFIX, filePrefix);
    }

    @Override
    public String getTranslationsPrefix() {
        return this.m_propertySupport.getPropertyString(PROP_TRANSLATION_FILE_PREFIX);
    }

    public IType getSuperType() {
        return (IType)this.m_propertySupport.getProperty(PROP_SUPER_TYPE);
    }

    @Override
    public IType[] getAllSuperclasses() {
        return this.m_superTypes;
    }

    public IJavaProject getJavaProject() {
        if (this.m_type == null) {
            return null;
        }
        return this.m_type.getJavaProject();
    }

    public String getHostPluginId() {
        String hostPluginId = PluginRegistry.findModel((IProject)this.m_type.getJavaProject().getProject()).getPluginBase().getId();
        return hostPluginId;
    }

    private class P_NlsResourceChangeListener
    implements IResourceChangeListener {
        private P_NlsResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta d) {
                            IResource resource = d.getResource();
                            if (resource != null && resource.equals((Object)((P_NlsResourceChangeListener)P_NlsResourceChangeListener.this).NlsType.this.m_type.getResource()) && ((P_NlsResourceChangeListener)P_NlsResourceChangeListener.this).NlsType.this.m_type.getResource().exists()) {
                                NlsType.this.reload();
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning((Throwable)e);
            }
        }
    }
}

