/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IntradayTimeScale;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MajorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScale;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class TimeScaleBuilder {
    private IActivityMap m_map;

    public TimeScaleBuilder(IActivityMap map) {
        this.m_map = map;
    }

    public TimeScale build() {
        Date[] days = this.m_map.getDays();
        TimeScale set = null;
        switch (this.m_map.getPlanningMode()) {
            case 0: {
                set = new IntradayTimeScale();
                this.buildIntradayScale(days, set);
                break;
            }
            case 1: {
                set = new TimeScale();
                this.buildDayScale(days, set);
                break;
            }
            case 2: {
                set = new TimeScale();
                this.buildWeekScale(days, set);
            }
        }
        return set;
    }

    protected void buildIntradayScale(Date[] days, TimeScale scale) {
        scale.setDateFormat(this.createIntradayFormatWithWeekDay(1, 3));
        Calendar timeCal = Calendar.getInstance();
        Date[] dateArray = days;
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            MajorTimeColumn curDayColumn = this.createMajorDayColumn(scale, d);
            timeCal.setTime(d);
            timeCal.set(11, this.m_map.getFirstHourOfDay());
            int intervalMinutes = (int)Math.max(1L, this.m_map.getIntradayInterval() / 1000L / 60L);
            int n3 = (this.m_map.getLastHourOfDay() - this.m_map.getFirstHourOfDay() + 1) * 60 / intervalMinutes;
            int i = 0;
            while (i < n3) {
                this.createMinorIntradayColumn(curDayColumn, timeCal.getTime(), intervalMinutes);
                timeCal.add(12, intervalMinutes);
                ++i;
            }
            ++n2;
        }
    }

    protected void buildDayScale(Date[] days, TimeScale scale) {
        scale.setDateFormat(this.createDayFormatWithWeekDay(1));
        Calendar dayCal = Calendar.getInstance();
        MajorTimeColumn curMonthColumn = null;
        Calendar curMonthCal = Calendar.getInstance();
        Date[] dateArray = days;
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            dayCal.setTime(d);
            if (curMonthColumn == null || dayCal.get(2) != curMonthCal.get(2)) {
                curMonthColumn = this.createMajorMonthColumn(scale, d);
                curMonthCal.setTime(dayCal.getTime());
                DateUtility.truncCalendarToMonth((Calendar)curMonthCal);
            }
            this.createMinorDayColumn(curMonthColumn, dayCal.getTime());
            ++n2;
        }
    }

    protected void buildWeekScale(Date[] days, TimeScale scale) {
        scale.setDateFormat(new SimpleDateFormat("'" + ScoutTexts.get((String)"Week", (String[])new String[0]) + "' w, yyyy", LocaleThreadLocal.get()));
        Calendar weekCal = Calendar.getInstance();
        MajorTimeColumn curMonthColumn = null;
        Calendar curMonthCal = Calendar.getInstance();
        Date[] dateArray = days;
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            weekCal.setTime(d);
            if (curMonthColumn == null || weekCal.get(2) != curMonthCal.get(2)) {
                curMonthColumn = this.createMajorMonthColumn(scale, d);
                curMonthCal.setTime(weekCal.getTime());
                DateUtility.truncCalendarToMonth((Calendar)curMonthCal);
            }
            this.createMinorWeekColumn(curMonthColumn, weekCal.getTime());
            ++n2;
        }
    }

    protected MajorTimeColumn createMajorMonthColumn(TimeScale scale, Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        DateUtility.truncCalendarToMonth((Calendar)cal);
        Date a = cal.getTime();
        MajorTimeColumn col = new MajorTimeColumn(scale);
        col.setLargeText(new SimpleDateFormat("MMMMM, yyyy", LocaleThreadLocal.get()).format(a));
        col.setMediumText(new SimpleDateFormat("MMM yy", LocaleThreadLocal.get()).format(a));
        col.setSmallText(new SimpleDateFormat("MMM", LocaleThreadLocal.get()).format(a));
        return col;
    }

    protected MinorTimeColumn createMinorWeekColumn(MajorTimeColumn parent, Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        Date a = cal.getTime();
        if (this.m_map.isWorkDaysOnly()) {
            cal.add(5, this.m_map.getWorkDayCount());
        } else {
            cal.add(3, 1);
        }
        cal.setTimeInMillis(cal.getTimeInMillis() - 1L);
        Date justBeforeEnd = cal.getTime();
        MinorTimeColumn col = new MinorTimeColumn(parent, a, justBeforeEnd);
        col.setLargeText(new SimpleDateFormat("'" + ScoutTexts.get((String)"Week", (String[])new String[0]) + "' w", LocaleThreadLocal.get()).format(a));
        col.setMediumText(new SimpleDateFormat("w", LocaleThreadLocal.get()).format(a));
        col.setSmallText(new SimpleDateFormat("w", LocaleThreadLocal.get()).format(a));
        StringBuilder ttBuf = new StringBuilder();
        ttBuf.append(new SimpleDateFormat("EEEEE", LocaleThreadLocal.get()).format(a));
        ttBuf.append(", ");
        ttBuf.append(DateFormat.getDateInstance(1, LocaleThreadLocal.get()).format(a));
        ttBuf.append(" - ");
        ttBuf.append(new SimpleDateFormat("EEEEE", LocaleThreadLocal.get()).format(justBeforeEnd));
        ttBuf.append(", ");
        ttBuf.append(DateFormat.getDateInstance(1, LocaleThreadLocal.get()).format(justBeforeEnd));
        col.setTooltipText(ttBuf.toString());
        return col;
    }

    protected MajorTimeColumn createMajorDayColumn(TimeScale scale, Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(11, this.m_map.getFirstHourOfDay());
        Date a = cal.getTime();
        MajorTimeColumn col = new MajorTimeColumn(scale);
        col.setLargeText(this.createDayFormatWithWeekDay(2).format(a));
        col.setMediumText(DateFormat.getDateInstance(3, LocaleThreadLocal.get()).format(a));
        col.setSmallText(new SimpleDateFormat("dd.MM.", LocaleThreadLocal.get()).format(a));
        return col;
    }

    protected MinorTimeColumn createMinorDayColumn(MajorTimeColumn parent, Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        Date a = cal.getTime();
        cal.add(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() - 1L);
        Date justBeforeEnd = cal.getTime();
        MinorTimeColumn col = new MinorTimeColumn(parent, a, justBeforeEnd);
        col.setLargeText(new SimpleDateFormat("dd", LocaleThreadLocal.get()).format(a));
        col.setMediumText(new SimpleDateFormat("dd", LocaleThreadLocal.get()).format(a));
        col.setSmallText(new SimpleDateFormat("dd", LocaleThreadLocal.get()).format(a));
        StringBuilder ttBuf = new StringBuilder();
        ttBuf.append(new SimpleDateFormat("EEEEE", LocaleThreadLocal.get()).format(a));
        ttBuf.append(", ");
        ttBuf.append(DateFormat.getDateInstance(1, LocaleThreadLocal.get()).format(a));
        col.setTooltipText(ttBuf.toString());
        return col;
    }

    protected MinorTimeColumn createMinorIntradayColumn(MajorTimeColumn parent, Date d, int durationInMinutes) {
        Date b;
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int hour = -1;
        if (cal.get(12) == 0) {
            hour = cal.get(11);
        }
        Date a = cal.getTime();
        cal.add(12, durationInMinutes);
        Date justBeforeEnd = b = cal.getTime();
        MinorTimeColumn col = new MinorTimeColumn(parent, a, b);
        if (hour >= 0) {
            col.setLargeText(new SimpleDateFormat("HH:mm", LocaleThreadLocal.get()).format(a));
            if (hour == this.m_map.getFirstHourOfDay() || hour == 12) {
                col.setMediumText(new SimpleDateFormat("HH:mm", LocaleThreadLocal.get()).format(a));
            }
            col.setSmallText("");
        }
        StringBuilder ttBuf = new StringBuilder();
        ttBuf.append(new SimpleDateFormat("EEEEE", LocaleThreadLocal.get()).format(a));
        ttBuf.append(", ");
        ttBuf.append(DateFormat.getDateInstance(1, LocaleThreadLocal.get()).format(a));
        ttBuf.append(", ");
        ttBuf.append(new SimpleDateFormat("HH:mm", LocaleThreadLocal.get()).format(a));
        ttBuf.append(" - ");
        ttBuf.append(new SimpleDateFormat("HH:mm", LocaleThreadLocal.get()).format(justBeforeEnd));
        col.setTooltipText(ttBuf.toString());
        return col;
    }

    protected SimpleDateFormat createDayFormatWithWeekDay(int dateStyle) {
        DateFormat df = DateFormat.getDateInstance(dateStyle, LocaleThreadLocal.get());
        String pat = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : "dd.MM.yyyy";
        pat = "EE " + pat;
        return new SimpleDateFormat(pat, LocaleThreadLocal.get());
    }

    protected SimpleDateFormat createIntradayFormatWithWeekDay(int dateStyle, int timeStyle) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, LocaleThreadLocal.get());
        String pat = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : "dd.MM.yyyy HH:mm";
        pat = "EE " + pat;
        return new SimpleDateFormat(pat, LocaleThreadLocal.get());
    }
}

