/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.menu;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;

public class ActivateBookmarkKeyStroke
extends KeyStroke {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ActivateBookmarkKeyStroke.class);
    private final Bookmark m_bookmark;

    public ActivateBookmarkKeyStroke(Bookmark b) {
        super(b.getKeyStroke());
        this.m_bookmark = b;
        this.callInitializer();
    }

    public Bookmark getBookmark() {
        return this.m_bookmark;
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.m_bookmark != null) {
            try {
                ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(this.m_bookmark, false);
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
        }
    }
}

