/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.tool.AbstractToolButton;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IFormToolButton;
import org.eclipse.scout.rt.client.ui.form.IForm;

public abstract class AbstractFormToolButton<FORM extends IForm>
extends AbstractToolButton
implements IFormToolButton<FORM> {
    private FORM m_form;
    private boolean m_previousSelectionState = false;

    @Override
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredToggleAction() {
        return true;
    }

    @Override
    public final FORM getForm() {
        return this.m_form;
    }

    @Override
    public final void setForm(FORM f) {
        this.setForm(f, false);
    }

    @Override
    public final void setForm(FORM f, boolean force) {
        if (force || f != this.m_form) {
            if (f != null) {
                this.decorateForm(f);
            }
            FORM oldForm = this.m_form;
            this.m_form = f;
            IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
            if (desktop != null) {
                if (this.m_form == null) {
                    desktop.removeForm((IForm)oldForm);
                    this.m_previousSelectionState = this.isSelected();
                    this.setSelected(false);
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                    if (!this.isSelected()) {
                        this.setSelected(this.m_previousSelectionState);
                    }
                    if (this.isSelected()) {
                        if (oldForm != null) {
                            desktop.removeForm((IForm)oldForm);
                        }
                        desktop.addForm((IForm)this.m_form);
                    }
                }
            }
        }
    }

    protected void execStartForm() throws ProcessingException {
    }

    @Override
    protected void execToggleAction(boolean selected) throws ProcessingException {
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop == null) {
            return;
        }
        if (selected) {
            if (this.isToggleAction()) {
                IToolButton[] iToolButtonArray = desktop.getToolButtons();
                int n = iToolButtonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IToolButton b = iToolButtonArray[n2];
                    if (b != this && b instanceof AbstractFormToolButton && b.isSelected()) {
                        b.setSelected(false);
                    }
                    ++n2;
                }
            }
            Object oldForm = this.getForm();
            this.execStartForm();
            if (oldForm == this.m_form && this.m_form != null) {
                this.m_previousSelectionState = true;
                desktop.addForm((IForm)this.m_form);
            }
        } else if (this.m_form != null) {
            this.m_previousSelectionState = false;
            desktop.removeForm((IForm)this.m_form);
        }
    }

    protected void decorateForm(FORM f) {
        f.setAutoAddRemoveOnDesktop(false);
        f.setDisplayHint(20);
        f.setDisplayViewId("E");
    }
}

