/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.lookup;

import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class BatchSplit {
    private LookupCall[] m_calls;
    private boolean[] m_local;
    private int m_localCount;
    private int m_remoteCount;
    private LookupRow[][] m_results;

    public BatchSplit(BatchLookupCall batch) {
        this(batch.getCallBatch());
    }

    public BatchSplit(LookupCall[] calls) {
        this.m_calls = calls;
        this.m_local = new boolean[this.m_calls.length];
        int i = 0;
        while (i < this.m_calls.length) {
            if (this.m_calls[i] != null) {
                if (this.m_calls[i] instanceof LocalLookupCall) {
                    this.m_local[i] = true;
                    ++this.m_localCount;
                } else {
                    this.m_local[i] = false;
                    ++this.m_remoteCount;
                }
            }
            ++i;
        }
        this.m_results = new LookupRow[this.m_calls.length][];
    }

    public int getLocalCallCount() {
        return this.m_localCount;
    }

    public LookupCall[] getLocalCalls() {
        LookupCall[] a = new LookupCall[this.m_localCount];
        int k = 0;
        int i = 0;
        while (i < this.m_calls.length) {
            if (this.m_calls[i] != null && this.m_local[i]) {
                a[k] = this.m_calls[i];
                ++k;
            }
            ++i;
        }
        return a;
    }

    public int getRemoteCallCount() {
        return this.m_remoteCount;
    }

    public LookupCall[] getRemoteCalls() {
        LookupCall[] a = new LookupCall[this.m_remoteCount];
        int k = 0;
        int i = 0;
        while (i < this.m_calls.length) {
            if (this.m_calls[i] != null && !this.m_local[i]) {
                a[k] = this.m_calls[i];
                ++k;
            }
            ++i;
        }
        return a;
    }

    public void setLocalResults(LookupRow[][] data) {
        int k = 0;
        int i = 0;
        while (i < this.m_calls.length) {
            if (this.m_calls[i] != null && this.m_local[i]) {
                this.m_results[i] = data[k];
                ++k;
            }
            ++i;
        }
    }

    public void setRemoteResults(LookupRow[][] data) {
        int k = 0;
        int i = 0;
        while (i < this.m_calls.length) {
            if (this.m_calls[i] != null && !this.m_local[i]) {
                this.m_results[i] = data[k];
                ++k;
            }
            ++i;
        }
    }

    public LookupRow[][] getCombinedResults() {
        return this.m_results;
    }
}

