/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.test;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.services.common.test.AbstractClientTest;
import org.eclipse.scout.rt.client.services.common.test.ClientTestUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;

public class UppercaseMnemonicUnitTest
extends AbstractClientTest {
    public void run() throws Exception {
        IMenu[] iMenuArray = ClientTestUtility.getDesktop().getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu menu = iMenuArray[n2];
            this.checkMenus(menu);
            ++n2;
        }
    }

    public void checkMenus(IMenu menu) throws ProcessingException {
        this.setSubTitle(String.valueOf(menu.getText()) + " [" + menu.getClass().getSimpleName() + "]");
        if (!menu.isSeparator() && menu.getMnemonic() == '\u0000' && menu.isVisible() && Character.isUpperCase(menu.getMnemonic())) {
            this.addErrorStatus("mnemonic " + menu.getMnemonic());
        } else {
            this.addOkStatus("mnemonic " + menu.getMnemonic());
        }
        for (IMenu sub : menu.getChildActions()) {
            this.checkMenus(sub);
        }
    }

    protected String getConfiguredTitle() {
        return "menubar: uppercase mnemonics";
    }
}

