/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.HeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractColumn<T>
extends AbstractPropertyObserver
implements IColumn<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractColumn.class);
    private ITable m_table;
    private final HeaderCell m_headerCell = new HeaderCell();
    private boolean m_primaryKey;
    private boolean m_summary;
    private boolean m_visibleProperty;
    private boolean m_visibleGranted;
    private int m_initialWidth;
    private boolean m_initialVisible;
    private int m_initialSortIndex;
    private boolean m_initialSortAscending;
    private boolean m_initialAlwaysIncludeSortAtBegin;
    private boolean m_initialAlwaysIncludeSortAtEnd;

    public AbstractColumn() {
        this.initConfig();
        this.propertySupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ITable table = AbstractColumn.this.getTable();
                if (table != null) {
                    table.updateAllRows();
                }
            }
        });
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredHeaderText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredHeaderTooltipText() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredHeaderForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredHeaderBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredHeaderFont() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=70.0)
    @ConfigPropertyValue(value="60")
    protected int getConfiguredWidth() {
        return 60;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=75.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFixedWidth() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredDisplayable() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredPrimaryKey() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=95.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredEditable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredSummary() {
        return false;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=110.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=120.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=130.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFont() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=140.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredSortIndex() {
        return -1;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=145.0)
    @ConfigPropertyValue(value="-1")
    protected double getConfiguredViewOrder() {
        return -1.0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredSortAscending() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAlwaysIncludeSortAtBegin() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=170.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAlwaysIncludeSortAtEnd() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=180.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredHorizontalAlignment() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=190.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAutoOptimizeWidth() {
        return false;
    }

    @ConfigProperty(value="DOC")
    @Order(value=200.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=210.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMandatory() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitColumn() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeColumn() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected T execParseValue(ITableRow row, Object rawValue) throws ProcessingException {
        return this.parseValueInternal(row, rawValue);
    }

    @ConfigOperation
    @Order(value=30.0)
    protected T execValidateValue(ITableRow row, T rawValue) throws ProcessingException {
        return this.validateValueInternal(row, rawValue);
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execDecorateCell(Cell cell, ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateHeaderCell(HeaderCell cell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected boolean execIsEditable(ITableRow row) throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=61.0)
    protected IFormField execPrepareEdit(ITableRow row) throws ProcessingException {
        IFormField f = this.prepareEditInternal(row);
        if (f != null) {
            f.setLabelVisible(false);
            if (this.getConfiguredMandatory()) {
                f.setMandatory(true);
            }
            GridData gd = f.getGridDataHints();
            gd.horizontalAlignment = this.getHorizontalAlignment();
            f.setGridDataHints(gd);
            if (f instanceof IValueField) {
                ((IValueField)f).setValue(this.getValue(row));
            }
            f.markSaved();
        }
        return f;
    }

    @ConfigOperation
    @Order(value=62.0)
    protected void execCompleteEdit(ITableRow row, IFormField editingField) throws ProcessingException {
        IValueField v;
        if (editingField instanceof IValueField && (v = (IValueField)editingField).isSaveNeeded()) {
            this.applyValueInternal(row, this.parseValue(row, ((IValueField)editingField).getValue()));
        }
    }

    protected void applyValueInternal(ITableRow row, T newValue) throws ProcessingException {
        if (!this.getTable().isSortEnabled()) {
            this.setValue(row, newValue);
        } else {
            try {
                this.getTable().setSortEnabled(false);
                this.setValue(row, newValue);
            }
            finally {
                this.getTable().setSortEnabled(true);
            }
        }
    }

    protected void initConfig() {
        this.setAutoOptimizeWidth(this.getConfiguredAutoOptimizeWidth());
        this.m_visibleGranted = true;
        this.m_headerCell.setText(this.getConfiguredHeaderText());
        if (this.getConfiguredHeaderTooltipText() != null) {
            this.m_headerCell.setTooltipText(this.getConfiguredHeaderTooltipText());
        }
        if (this.getConfiguredHeaderForegroundColor() != null) {
            this.m_headerCell.setForegroundColor(this.getConfiguredHeaderForegroundColor());
        }
        if (this.getConfiguredHeaderBackgroundColor() != null) {
            this.m_headerCell.setBackgroundColor(this.getConfiguredHeaderBackgroundColor());
        }
        if (this.getConfiguredHeaderFont() != null) {
            this.m_headerCell.setFont(FontSpec.parse((String)this.getConfiguredHeaderFont()));
        }
        this.m_headerCell.setHorizontalAlignment(this.getConfiguredHorizontalAlignment());
        this.setHorizontalAlignment(this.getConfiguredHorizontalAlignment());
        this.setDisplayable(this.getConfiguredDisplayable());
        this.setVisible(this.getConfiguredVisible());
        this.setInitialWidth(this.getConfiguredWidth());
        this.setInitialVisible(this.getConfiguredVisible());
        this.setInitialSortIndex(this.getConfiguredSortIndex());
        this.setInitialSortAscending(this.getConfiguredSortAscending());
        this.setInitialAlwaysIncludeSortAtBegin(this.getConfiguredAlwaysIncludeSortAtBegin());
        this.setInitialAlwaysIncludeSortAtEnd(this.getConfiguredAlwaysIncludeSortAtEnd());
        double viewOrder = this.getConfiguredViewOrder();
        if (viewOrder < 0.0 && this.getClass().isAnnotationPresent(Order.class)) {
            Order order = this.getClass().getAnnotation(Order.class);
            viewOrder = order.value();
        }
        this.setViewOrder(viewOrder);
        this.setWidth(this.getConfiguredWidth());
        this.setFixedWidth(this.getConfiguredFixedWidth());
        this.m_primaryKey = this.getConfiguredPrimaryKey();
        this.m_summary = this.getConfiguredSummary();
        this.setEditable(this.getConfiguredEditable());
        this.setVisibleColumnIndexHint(-1);
        if (this.getConfiguredForegroundColor() != null) {
            this.setForegroundColor(this.getConfiguredForegroundColor());
        }
        if (this.getConfiguredBackgroundColor() != null) {
            this.setBackgroundColor(this.getConfiguredBackgroundColor());
        }
        if (this.getConfiguredFont() != null) {
            this.setFont(FontSpec.parse((String)this.getConfiguredFont()));
        }
    }

    @Override
    public void initColumn() throws ProcessingException {
        ClientUIPreferences env = ClientUIPreferences.getInstance();
        this.setVisible(env.getTableColumnVisible(this, this.m_visibleProperty));
        this.setWidth(env.getTableColumnWidth(this, this.getWidth()));
        this.setVisibleColumnIndexHint(env.getTableColumnViewIndex(this, this.getVisibleColumnIndexHint()));
        this.execInitColumn();
    }

    @Override
    public void disposeColumn() throws ProcessingException {
        this.execDisposeColumn();
    }

    @Override
    public boolean isInitialVisible() {
        return this.m_initialVisible;
    }

    @Override
    public void setInitialVisible(boolean b) {
        this.m_initialVisible = b;
    }

    @Override
    public int getInitialSortIndex() {
        return this.m_initialSortIndex;
    }

    @Override
    public void setInitialSortIndex(int i) {
        this.m_initialSortIndex = i;
    }

    @Override
    public boolean isInitialSortAscending() {
        return this.m_initialSortAscending;
    }

    @Override
    public void setInitialSortAscending(boolean b) {
        this.m_initialSortAscending = b;
    }

    @Override
    public boolean isInitialAlwaysIncludeSortAtBegin() {
        return this.m_initialAlwaysIncludeSortAtBegin;
    }

    @Override
    public void setInitialAlwaysIncludeSortAtBegin(boolean b) {
        this.m_initialAlwaysIncludeSortAtBegin = b;
    }

    @Override
    public boolean isInitialAlwaysIncludeSortAtEnd() {
        return this.m_initialAlwaysIncludeSortAtEnd;
    }

    @Override
    public void setInitialAlwaysIncludeSortAtEnd(boolean b) {
        this.m_initialAlwaysIncludeSortAtEnd = b;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public void setTableInternal(ITable table) {
        this.m_table = table;
    }

    @Override
    public int getColumnIndex() {
        return this.m_headerCell.getColumnIndex();
    }

    @Override
    public String getColumnId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getSimpleName();
        if (s.endsWith("Column")) {
            s = s.replaceAll("Column$", "");
        }
        return s;
    }

    @Override
    public T getValue(ITableRow r) {
        return (T)(r != null ? r.getCellValue(this.getColumnIndex()) : null);
    }

    @Override
    public T getValue(int rowIndex) {
        return this.getValue(this.getTable().getRow(rowIndex));
    }

    @Override
    public void setValue(int rowIndex, T rawValue) throws ProcessingException {
        this.setValue(this.getTable().getRow(rowIndex), rawValue);
    }

    @Override
    public void setValue(ITableRow r, T rawValue) throws ProcessingException {
        T newValue = this.validateValue(r, rawValue);
        r.setCellValue(this.getColumnIndex(), newValue);
    }

    @Override
    public void fill(T rawValue) throws ProcessingException {
        ITableRow[] rows;
        ITableRow[] iTableRowArray = rows = this.getTable().getRows();
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            ITableRow row = iTableRowArray[n2];
            this.setValue(row, rawValue);
            ++n2;
        }
    }

    @Override
    public Class<T> getDataType() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), IColumn.class);
    }

    @Override
    public T[] getValues() {
        Object[] values = (Object[])Array.newInstance(this.getDataType(), this.m_table.getRowCount());
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            values[i] = this.getValue(this.m_table.getRow(i));
            ++i;
        }
        return values;
    }

    @Override
    public T[] getValues(ITableRow[] rows) {
        Object[] values = (Object[])Array.newInstance(this.getDataType(), rows.length);
        int i = 0;
        while (i < rows.length) {
            values[i] = this.getValue(rows[i]);
            ++i;
        }
        return values;
    }

    @Override
    public T[] getSelectedValues() {
        ITableRow[] rows = this.m_table.getSelectedRows();
        Object[] values = (Object[])Array.newInstance(this.getDataType(), rows.length);
        int i = 0;
        while (i < rows.length) {
            values[i] = this.getValue(rows[i]);
            ++i;
        }
        return values;
    }

    @Override
    public T getSelectedValue() {
        ITableRow row = this.m_table.getSelectedRow();
        if (row != null) {
            return this.getValue(row);
        }
        return null;
    }

    @Override
    public String getDisplayText(ITableRow r) {
        return r.getCell(this.getColumnIndex()).getText();
    }

    @Override
    public String[] getDisplayTexts() {
        String[] values = new String[this.m_table.getRowCount()];
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            values[i] = this.getDisplayText(this.m_table.getRow(i));
            ++i;
        }
        return values;
    }

    @Override
    public String getSelectedDisplayText() {
        ITableRow row = this.m_table.getSelectedRow();
        if (row != null) {
            return this.getDisplayText(row);
        }
        return null;
    }

    @Override
    public String[] getSelectedDisplayTexts() {
        ITableRow[] rows = this.m_table.getSelectedRows();
        String[] values = new String[rows.length];
        int i = 0;
        while (i < rows.length) {
            values[i] = this.getDisplayText(rows[i]);
            ++i;
        }
        return values;
    }

    @Override
    public T[] getInsertedValues() {
        ITableRow[] rows = this.m_table.getInsertedRows();
        Object[] values = (Object[])Array.newInstance(this.getDataType(), rows.length);
        int i = 0;
        while (i < rows.length) {
            values[i] = this.getValue(rows[i]);
            ++i;
        }
        return values;
    }

    @Override
    public T[] getUpdatedValues() {
        ITableRow[] rows = this.m_table.getUpdatedRows();
        Object[] values = (Object[])Array.newInstance(this.getDataType(), rows.length);
        int i = 0;
        while (i < rows.length) {
            values[i] = this.getValue(rows[i]);
            ++i;
        }
        return values;
    }

    @Override
    public T[] getDeletedValues() {
        ITableRow[] rows = this.m_table.getDeletedRows();
        Object[] values = (Object[])Array.newInstance(this.getDataType(), rows.length);
        int i = 0;
        while (i < rows.length) {
            values[i] = this.getValue(rows[i]);
            ++i;
        }
        return values;
    }

    @Override
    public ITableRow[] findRows(T[] values) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                ITableRow row = this.findRow(values[i]);
                if (row != null) {
                    rowList.add(row);
                }
                ++i;
            }
        }
        return rowList.toArray(new ITableRow[0]);
    }

    @Override
    public ITableRow[] findRows(T value) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            ITableRow row = this.m_table.getRow(i);
            if (CompareUtility.equals(value, this.getValue(row))) {
                rowList.add(row);
            }
            ++i;
        }
        return rowList.toArray(new ITableRow[0]);
    }

    @Override
    public ITableRow findRow(T value) {
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            ITableRow row = this.m_table.getRow(i);
            if (CompareUtility.equals(value, this.getValue(row))) {
                return row;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean contains(T value) {
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            ITableRow row = this.m_table.getRow(i);
            if (CompareUtility.equals(value, this.getValue(row))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsDuplicateValues() {
        return new HashSet<T>(Arrays.asList(this.getValues())).size() < this.getValues().length;
    }

    @Override
    public boolean isEmpty() {
        if (this.m_table != null) {
            int i = 0;
            int ni = this.m_table.getRowCount();
            while (i < ni) {
                T value = this.getValue(this.m_table.getRow(i));
                if (value != null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void setColumnIndexInternal(int index) {
        this.m_headerCell.setColumnIndexInternal(index);
    }

    @Override
    public boolean isSortActive() {
        return this.getHeaderCell().isSortActive();
    }

    @Override
    public boolean isSortExplicit() {
        return this.getHeaderCell().isSortExplicit();
    }

    @Override
    public boolean isSortAscending() {
        return this.getHeaderCell().isSortAscending();
    }

    @Override
    public boolean isSortPermanent() {
        return this.getHeaderCell().isSortPermanent();
    }

    @Override
    public int getSortIndex() {
        ColumnSet cs;
        ITable table = this.getTable();
        if (table != null && (cs = table.getColumnSet()) != null) {
            return cs.getSortColumnIndex(this);
        }
        return -1;
    }

    @Override
    public boolean isColumnFilterActive() {
        ITableColumnFilterManager m;
        ITable table = this.getTable();
        if (table != null && (m = table.getColumnFilterManager()) != null) {
            return m.getFilter(this) != null;
        }
        return false;
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        T o1 = this.getValue(r1);
        T o2 = this.getValue(r2);
        int c = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (o1 instanceof Comparable && o2 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : StringUtility.compareIgnoreCase((String)o1.toString(), (String)o2.toString()))));
        return c;
    }

    @Override
    public final T parseValue(ITableRow row, Object rawValue) throws ProcessingException {
        T parsedValue = this.execParseValue(row, rawValue);
        return this.validateValue(row, parsedValue);
    }

    protected T parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        return (T)TypeCastUtility.castValue((Object)rawValue, this.getDataType());
    }

    @Override
    public T validateValue(ITableRow row, T rawValue) throws ProcessingException {
        return this.execValidateValue(row, rawValue);
    }

    protected T validateValueInternal(ITableRow row, T rawValue) throws ProcessingException {
        return rawValue;
    }

    @Override
    public final IFormField prepareEdit(ITableRow row) throws ProcessingException {
        ITable table = this.getTable();
        if (table == null || !this.isCellEditable(row)) {
            return null;
        }
        IFormField f = this.execPrepareEdit(row);
        if (f != null) {
            f.setLabelVisible(false);
            GridData gd = f.getGridDataHints();
            gd.weightY = 1.0;
            f.setGridDataHints(gd);
        }
        return f;
    }

    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractValueField f = new AbstractValueField<T>(){

            @Override
            public Class<T> getHolderType() {
                return AbstractColumn.this.getDataType();
            }
        };
        return f;
    }

    @Override
    public final void completeEdit(ITableRow row, IFormField editingField) throws ProcessingException {
        ITable table = this.getTable();
        if (table == null || !table.isCellEditable(row, this)) {
            return;
        }
        this.execCompleteEdit(row, editingField);
    }

    @Override
    public void decorateCell(ITableRow row) {
        Cell cell = row.getCellForUpdate(this.getColumnIndex());
        this.decorateCellInternal(cell, row);
        try {
            this.execDecorateCell(cell, row);
        }
        catch (ProcessingException e) {
            LOG.warn(null, (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn(null, t);
        }
    }

    protected void decorateCellInternal(Cell cell, ITableRow row) {
        if (this.getForegroundColor() != null) {
            cell.setForegroundColor(this.getForegroundColor());
        }
        if (this.getBackgroundColor() != null) {
            cell.setBackgroundColor(this.getBackgroundColor());
        }
        if (this.getFont() != null) {
            cell.setFont(this.getFont());
        }
        cell.setHorizontalAlignment(this.getHorizontalAlignment());
        cell.setEditableInternal(this.isCellEditable(row));
    }

    @Override
    public void decorateHeaderCell() {
        HeaderCell cell = this.m_headerCell;
        this.decorateHeaderCellInternal(cell);
        try {
            this.execDecorateHeaderCell(cell);
        }
        catch (ProcessingException e) {
            LOG.warn(null, (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn(null, t);
        }
    }

    protected void decorateHeaderCellInternal(HeaderCell cell) {
    }

    @Override
    public IHeaderCell getHeaderCell() {
        return this.m_headerCell;
    }

    @Override
    public int getVisibleColumnIndexHint() {
        return this.propertySupport.getPropertyInt("viewColumnIndexHint");
    }

    @Override
    public void setVisibleColumnIndexHint(int index) {
        int oldIndex = this.getVisibleColumnIndexHint();
        if (oldIndex != index) {
            this.propertySupport.setPropertyInt("viewColumnIndexHint", index);
        }
    }

    @Override
    public int getInitialWidth() {
        return this.m_initialWidth;
    }

    @Override
    public void setInitialWidth(int w) {
        this.m_initialWidth = w;
    }

    @Override
    public double getViewOrder() {
        return this.propertySupport.getPropertyDouble("viewOrder");
    }

    @Override
    public void setViewOrder(double order) {
        this.propertySupport.setPropertyDouble("viewOrder", order);
    }

    @Override
    public int getWidth() {
        return this.propertySupport.getPropertyInt("width");
    }

    @Override
    public void setWidth(int w) {
        this.propertySupport.setPropertyInt("width", w);
    }

    @Override
    public void setWidthInternal(int w) {
        this.propertySupport.setPropertyNoFire("width", (Object)w);
    }

    @Override
    public boolean isFixedWidth() {
        return this.propertySupport.getPropertyBool("fixedWidth");
    }

    @Override
    public void setFixedWidth(boolean fixedWidth) {
        this.propertySupport.setPropertyBool("fixedWidth", fixedWidth);
    }

    @Override
    public void setHorizontalAlignment(int hAglin) {
        this.propertySupport.setPropertyInt("horizontalAlignment", hAglin);
    }

    @Override
    public int getHorizontalAlignment() {
        return this.propertySupport.getPropertyInt("horizontalAlignment");
    }

    @Override
    public boolean isDisplayable() {
        return this.propertySupport.getPropertyBool("displayable");
    }

    @Override
    public void setDisplayable(boolean b) {
        this.propertySupport.setPropertyBool("displayable", b);
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.isDisplayable() && this.m_visibleProperty);
    }

    @Override
    public boolean isVisibleInternal() {
        return this.m_visibleProperty;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.m_primaryKey;
    }

    @Override
    public boolean isSummary() {
        return this.m_summary;
    }

    @Override
    public boolean isEditable() {
        return this.propertySupport.getPropertyBool("editable");
    }

    @Override
    public void setEditable(boolean b) {
        this.propertySupport.setPropertyBool("editable", b);
    }

    @Override
    public boolean isCellEditable(ITableRow row) {
        if (this.getTable() != null && this.getTable().isEnabled() && this.isEditable() && row != null && row.isEnabled() && row.getCell(this).isEnabled()) {
            try {
                return this.execIsEditable(row);
            }
            catch (Throwable t) {
                LOG.error("checking row " + row, t);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getForegroundColor() {
        return (String)this.propertySupport.getProperty("foregroundColor");
    }

    @Override
    public void setForegroundColor(String c) {
        this.propertySupport.setProperty("foregroundColor", (Object)c);
    }

    @Override
    public String getBackgroundColor() {
        return (String)this.propertySupport.getProperty("backgroundColor");
    }

    @Override
    public void setBackgroundColor(String c) {
        this.propertySupport.setProperty("backgroundColor", (Object)c);
    }

    @Override
    public FontSpec getFont() {
        return (FontSpec)this.propertySupport.getProperty("font");
    }

    @Override
    public void setFont(FontSpec f) {
        this.propertySupport.setProperty("font", (Object)f);
    }

    @Override
    public boolean isAutoOptimizeWidth() {
        return this.propertySupport.getPropertyBool("autoOptimizeWidth");
    }

    @Override
    public void setAutoOptimizeWidth(boolean optimize) {
        this.propertySupport.setPropertyBool("autoOptimizeWidth", optimize);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getHeaderCell().getText() + " width=" + this.getWidth() + (this.isPrimaryKey() ? " primaryKey" : "") + (this.isSummary() ? " summary" : "") + " viewIndexHint=" + this.getVisibleColumnIndexHint() + "]";
    }
}

