/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.ArrayList;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractAddAttributeMenu;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class EitherOrNode
extends AbstractComposerNode {
    private boolean m_beginEitherOr;
    private boolean m_negated = false;

    public EitherOrNode(IComposerField composerField, boolean beginEitherOr) {
        super(composerField, false);
        this.m_beginEitherOr = beginEitherOr;
        this.callInitializer();
    }

    public boolean isBeginOfEitherOr() {
        return this.m_beginEitherOr;
    }

    public void setBeginOfEitherOr(boolean b) {
        this.m_beginEitherOr = b;
    }

    public boolean isEndOfEitherOr() {
        ITreeNode next = this.getSiblingAfter();
        return !(next instanceof EitherOrNode) || ((EitherOrNode)next).isBeginOfEitherOr();
    }

    public boolean isNegative() {
        return this.m_negated;
    }

    public void setNegative(boolean b) {
        this.m_negated = b;
    }

    @Override
    protected void execInitTreeNode() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        IMenu[] iMenuArray = this.getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu m = iMenuArray[n2];
            if (m.getClass() == AddEntityOnEitherOrPlaceholderMenu.class) {
                this.attachAddEntityMenus(menus);
            } else {
                menus.add(m);
            }
            ++n2;
        }
        this.setMenus(menus.toArray(new IMenu[menus.size()]));
    }

    @Override
    protected void execDecorateCell(Cell cell) {
        String text = "";
        ITreeNode siblingBefore = this.getSiblingBefore();
        if (this.isBeginOfEitherOr() && siblingBefore != null) {
            text = String.valueOf(text) + ScoutTexts.get((String)"ExtendedSearchAnd", (String[])new String[0]) + " ";
        }
        text = this.isBeginOfEitherOr() ? String.valueOf(text) + ScoutTexts.get((String)"ExtendedSearchEither", (String[])new String[0]) : String.valueOf(text) + ScoutTexts.get((String)"ExtendedSearchOr", (String[])new String[0]);
        if (this.isNegative()) {
            text = String.valueOf(text) + " " + ScoutTexts.get((String)"ExtendedSearchNot", (String[])new String[0]);
        }
        cell.setText(text);
    }

    @Order(value=1.0)
    public class AddAdditionalOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchAddAdditionalOrMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EitherOrNode.this.getComposerField().addAdditionalOrNode(EitherOrNode.this, false);
        }
    }

    @Order(value=50.0)
    public class AddAttributeOnEitherOrMenu
    extends AbstractAddAttributeMenu {
        public AddAttributeOnEitherOrMenu() {
            super(EitherOrNode.this.getComposerField(), EitherOrNode.this);
        }
    }

    @Order(value=5.0)
    public class AddEitherOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchAddEitherOrMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EitherOrNode node = EitherOrNode.this.getComposerField().addEitherNode(EitherOrNode.this, false);
            EitherOrNode.this.getComposerField().addAdditionalOrNode(node, false);
        }
    }

    @Order(value=70.0)
    public class AddEntityOnEitherOrPlaceholderMenu
    extends MenuSeparator {
    }

    @Order(value=30.0)
    public class DeleteEitherOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchRemoveMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            ITreeNode next = EitherOrNode.this.getSiblingAfter();
            if (EitherOrNode.this.isBeginOfEitherOr() && next instanceof EitherOrNode && !((EitherOrNode)next).isBeginOfEitherOr()) {
                ((EitherOrNode)next).setBeginOfEitherOr(true);
                ((EitherOrNode)next).update();
            }
            EitherOrNode.this.getTree().selectPreviousParentNode();
            EitherOrNode.this.getTree().removeNode(EitherOrNode.this);
        }
    }

    @Order(value=20.0)
    public class NegateEitherOrMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchNegateMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EitherOrNode.this.setNegative(!EitherOrNode.this.isNegative());
            if (!EitherOrNode.this.isStatusInserted()) {
                EitherOrNode.this.setStatusInternal(2);
            }
            EitherOrNode.this.update();
        }
    }

    @Order(value=10.0)
    public class Separator1Menu
    extends MenuSeparator {
    }

    @Order(value=40.0)
    public class Separator2Menu
    extends MenuSeparator {
    }

    @Order(value=60.0)
    public class Separator3Menu
    extends MenuSeparator {
    }
}

