/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.integerfield;

import java.text.ParsePosition;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

public abstract class AbstractIntegerField
extends AbstractNumberField<Integer>
implements IIntegerField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractIntegerField.class);

    public AbstractIntegerField() {
        this(true);
    }

    public AbstractIntegerField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=250.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="minValue")
    protected Integer getConfiguredMinimumValue() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=260.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="maxValue")
    protected Integer getConfiguredMaximumValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinimumValue());
        this.setMaxValue(this.getConfiguredMaximumValue());
    }

    @Override
    protected Integer parseValueInternal(String text) throws ProcessingException {
        Integer retVal = null;
        if ((text = text == null ? "" : text.trim()).length() > 0) {
            ParsePosition p = new ParsePosition(0);
            Number n = this.createNumberFormat().parse(text, p);
            if (p.getErrorIndex() >= 0 || p.getIndex() != text.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{text}));
            }
            retVal = new Integer(n.intValue());
        }
        return retVal;
    }
}

