/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class BeanPropertyInput
implements IBindInput {
    private String m_propertyName;
    private FastPropertyDescriptor m_propertyDesc;
    private Object[] m_beans;
    private ValueInputToken m_target;
    private int m_batchIndex;
    private int m_jdbcBindIndex;

    public BeanPropertyInput(String propertyName, Object[] beans, ValueInputToken target) throws ProcessingException {
        block11: {
            this.m_batchIndex = -1;
            this.m_jdbcBindIndex = -1;
            if (beans == null) {
                beans = new Object[]{};
            }
            this.m_propertyName = propertyName;
            this.m_beans = beans;
            this.m_target = target;
            try {
                FastPropertyDescriptor test;
                if (this.m_propertyDesc == null && (test = BeanUtility.getFastBeanInfo(this.m_beans.getClass().getComponentType(), null).getPropertyDescriptor(this.m_propertyName)) != null && test.getReadMethod() != null) {
                    this.m_propertyDesc = test;
                }
                if (this.m_propertyDesc != null) break block11;
                Object[] objectArray = this.m_beans;
                int n = this.m_beans.length;
                int n2 = 0;
                while (n2 < n) {
                    Object bean = objectArray[n2];
                    if (bean != null) {
                        this.m_propertyDesc = BeanUtility.getFastBeanInfo(bean.getClass(), null).getPropertyDescriptor(this.m_propertyName);
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new ProcessingException("property " + this.m_propertyName, (Throwable)e);
            }
        }
        if (!this.isBatch() && this.m_beans.length >= 2) {
            this.m_target.setPlainValue(true);
            if (this.m_target.getParsedOp() != null) {
                if (this.m_target.getParsedOp().equals("=")) {
                    this.m_target.setParsedOp("IN");
                } else if (this.m_target.getParsedOp().equals("<>")) {
                    this.m_target.setParsedOp("NOT IN");
                }
            }
        }
    }

    @Override
    public IToken getToken() {
        return this.m_target;
    }

    @Override
    public boolean isBatch() {
        return this.m_target.isBatch();
    }

    @Override
    public boolean hasBatch(int i) {
        if (this.isBatch()) {
            return i < this.m_beans.length;
        }
        return i <= 0;
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public boolean isJdbcBind() {
        if (this.isBatch()) {
            if (this.m_target.isPlainValue()) {
                return false;
            }
            return !this.m_target.isPlainSql();
        }
        return false;
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        if (this.isBatch()) {
            Object bean;
            Class valueType;
            Object value = null;
            Class clazz = valueType = this.m_propertyDesc != null ? this.m_propertyDesc.getPropertyType() : null;
            if (this.m_batchIndex < this.m_beans.length && (bean = this.m_beans[this.m_batchIndex]) != null && this.m_propertyDesc != null) {
                try {
                    value = this.m_propertyDesc.getReadMethod().invoke(bean, new Object[0]);
                }
                catch (Exception e) {
                    throw new ProcessingException("property " + this.m_propertyName, (Throwable)e);
                }
            }
            if (this.m_target.isPlainValue()) {
                this.m_target.setReplaceToken(sqlStyle.toPlainText(value));
                return null;
            }
            if (this.m_target.isPlainSql()) {
                this.m_target.setReplaceToken("" + value);
                return null;
            }
            this.m_target.setReplaceToken("?");
            return sqlStyle.buildBindFor(value, valueType);
        }
        Object[] values = new Object[this.m_beans.length];
        int i = 0;
        while (i < values.length) {
            Object bean = this.m_beans[i];
            if (bean != null && this.m_propertyDesc != null) {
                try {
                    values[i] = this.m_propertyDesc.getReadMethod().invoke(bean, new Object[0]);
                }
                catch (Exception e) {
                    throw new ProcessingException("property " + this.m_propertyName, (Throwable)e);
                }
            }
            ++i;
        }
        if (this.m_target.getParsedAttribute() != null) {
            String att = this.m_target.getParsedAttribute();
            String op = this.m_target.getParsedOp();
            this.m_target.setParsedAttribute(null);
            this.m_target.setParsedOp(null);
            if (op.equalsIgnoreCase("IN") || op.equalsIgnoreCase("=")) {
                this.m_target.setReplaceToken(sqlStyle.createInList(att, values));
            } else {
                this.m_target.setReplaceToken(sqlStyle.createNotInList(att, values));
            }
        } else {
            this.m_target.setReplaceToken(sqlStyle.toPlainText(values));
        }
        return null;
    }
}

