/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.style;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

public abstract class AbstractSqlStyle
implements ISqlStyle {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSqlStyle.class);

    @Override
    public String getConcatOp() {
        return "||";
    }

    @Override
    public String getLikeWildcard() {
        return "%";
    }

    @Override
    public String toLikePattern(Object value) {
        String s = value != null ? value.toString() : "";
        s = s.replace("*", this.getLikeWildcard());
        return s;
    }

    @Override
    public String toPlainText(Object value) {
        if (value instanceof IHolder) {
            value = ((IHolder)value).getValue();
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? "1" : "0";
        }
        if (value instanceof TriState) {
            TriState t = (TriState)value;
            return t.toString();
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.length() > 4000) {
                s = s.substring(0, 4000);
                LOG.warn("toPlainText of a String with more than 4000 characters failed; truncated to '" + s + "'");
                return "'" + s.replaceAll("'", "''") + "'";
            }
            return "'" + s.replaceAll("'", "''") + "'";
        }
        if (value instanceof char[]) {
            if (((char[])value).length > 4000) {
                String s = new String((char[])value, 0, 4000);
                LOG.warn("toPlainText of a CLOB with more than 4000 characters failed; truncated to '" + s + "'");
                return "'" + s.replaceAll("'", "''") + "'";
            }
            String s = new String((char[])value);
            return "'" + s.replaceAll("'", "''") + "'";
        }
        if (value instanceof byte[]) {
            LOG.warn("toPlainText of a BLOB failed; using NULL");
            return "NULL";
        }
        if (value instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)value;
            SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            return "to_date('" + fmt.format(d) + "','dd.mm.yyyy hh24:mi:ss')";
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            Object[] array = value instanceof Collection ? ((Collection)value).toArray() : value;
            int n = Array.getLength(array);
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            if (n > 0) {
                int i = 0;
                while (i < n) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append(this.toPlainText(Array.get(array, i)));
                    ++i;
                }
            } else {
                buf.append("-1");
            }
            buf.append(")");
            return buf.toString();
        }
        return value.toString();
    }

    @Override
    public String toAggregationAvg(String attribute) {
        return "AVG(" + attribute + ")";
    }

    @Override
    public String toAggregationCount(String attribute) {
        return "COUNT(" + attribute + ")";
    }

    @Override
    public String toAggregationMax(String attribute) {
        return "MAX(" + attribute + ")";
    }

    @Override
    public String toAggregationMedian(String attribute) {
        return "MEDIAN(" + attribute + ")";
    }

    @Override
    public String toAggregationMin(String attribute) {
        return "MIN(" + attribute + ")";
    }

    @Override
    public String toAggregationSum(String attribute) {
        return "SUM(" + attribute + ")";
    }

    @Override
    public SqlBind buildBindFor(Object o, Class nullType) {
        Class c;
        if (o instanceof IHolder) {
            IHolder h = (IHolder)o;
            o = h.getValue();
            nullType = h.getHolderType();
        }
        if (o != null) {
            c = o.getClass();
        } else {
            if (nullType != null && IHolder.class.isAssignableFrom(nullType)) {
                try {
                    nullType = TypeCastUtility.getGenericsParameterClass((Class)nullType, IHolder.class);
                }
                catch (Throwable throwable) {
                    nullType = null;
                }
            }
            c = nullType;
        }
        if (o == null && c == null) {
            return new SqlBind(0, o);
        }
        if (Timestamp.class.isAssignableFrom(c)) {
            return new SqlBind(93, o);
        }
        if (Date.class.isAssignableFrom(c)) {
            return new SqlBind(91, o);
        }
        if (Calendar.class.isAssignableFrom(c)) {
            if (o == null) {
                return new SqlBind(93, o);
            }
            return new SqlBind(93, new Timestamp(((Calendar)o).getTimeInMillis()));
        }
        if (java.util.Date.class.isAssignableFrom(c)) {
            if (o == null) {
                return new SqlBind(93, o);
            }
            return new SqlBind(93, new Timestamp(((java.util.Date)o).getTime()));
        }
        if (Double.class.isAssignableFrom(c)) {
            return new SqlBind(8, o);
        }
        if (Float.class.isAssignableFrom(c)) {
            return new SqlBind(6, o);
        }
        if (Integer.class.isAssignableFrom(c)) {
            return new SqlBind(4, o);
        }
        if (Long.class.isAssignableFrom(c)) {
            return new SqlBind(-5, o);
        }
        if (BigInteger.class.isAssignableFrom(c)) {
            return new SqlBind(-5, o);
        }
        if (BigDecimal.class.isAssignableFrom(c)) {
            return new SqlBind(2, o);
        }
        if (String.class.isAssignableFrom(c) || char[].class == c) {
            boolean large;
            String s;
            if (o == null) {
                return new SqlBind(12, o);
            }
            if (String.class.isAssignableFrom(c)) {
                s = (String)o;
                large = this.isLargeString(s);
            } else {
                s = new String((char[])o);
                large = true;
            }
            if (large) {
                if (this.isClobEnabled()) {
                    return new SqlBind(2005, s);
                }
                return new SqlBind(-1, s);
            }
            return new SqlBind(12, s);
        }
        if (byte[].class == c) {
            if (o == null) {
                if (this.isBlobEnabled()) {
                    return new SqlBind(2004, o);
                }
                return new SqlBind(-4, o);
            }
            if (this.isBlobEnabled()) {
                return new SqlBind(2004, o);
            }
            return new SqlBind(-4, o);
        }
        if (Boolean.class.isAssignableFrom(c)) {
            if (o == null) {
                return new SqlBind(4, null);
            }
            return new SqlBind(4, (Boolean)o != false ? 1 : 0);
        }
        if (TriState.class.isAssignableFrom(c)) {
            if (o == null) {
                return new SqlBind(4, null);
            }
            return new SqlBind(4, ((TriState)o).getIntegerValue());
        }
        if (Blob.class.isAssignableFrom(c)) {
            return new SqlBind(2004, o);
        }
        if (Clob.class.isAssignableFrom(c)) {
            return new SqlBind(2005, o);
        }
        if (c.isArray()) {
            return new SqlBind(2003, o);
        }
        if (o == null) {
            return new SqlBind(12, o);
        }
        throw new IllegalArgumentException("no SqlBind mapping for " + c);
    }

    @Override
    public void writeBind(PreparedStatement ps, int jdbcBindIndex, SqlBind bind) throws SQLException {
        switch (bind.getSqlType()) {
            case 0: {
                try {
                    ps.setNull(jdbcBindIndex, 0);
                }
                catch (SQLException sQLException) {
                    ps.setNull(jdbcBindIndex, 12);
                }
                break;
            }
            case 2005: {
                if (bind.getValue() instanceof Clob) {
                    ps.setClob(jdbcBindIndex, (Clob)bind.getValue());
                    break;
                }
                String s = (String)bind.getValue();
                ps.setCharacterStream(jdbcBindIndex, (Reader)new StringReader(s), s.length());
                break;
            }
            case 2004: {
                if (bind.getValue() instanceof Blob) {
                    ps.setBlob(jdbcBindIndex, (Blob)bind.getValue());
                    break;
                }
                byte[] data = (byte[])bind.getValue();
                ps.setBinaryStream(jdbcBindIndex, (InputStream)new ByteArrayInputStream(data), data.length);
                break;
            }
            case -1: {
                String s = (String)bind.getValue();
                ps.setCharacterStream(jdbcBindIndex, (Reader)new StringReader(s), s.length());
                break;
            }
            case -4: {
                byte[] data = (byte[])bind.getValue();
                try {
                    ps.setBytes(jdbcBindIndex, data);
                    break;
                }
                catch (Throwable e1) {
                    try {
                        ps.setBinaryStream(jdbcBindIndex, (InputStream)new ByteArrayInputStream(data), data.length);
                        break;
                    }
                    catch (SQLException sQLException) {
                        if (e1 instanceof SQLException) {
                            throw (SQLException)e1;
                        }
                        throw new SQLException("failed setting bytes on jdbcBindIndex " + jdbcBindIndex);
                    }
                }
            }
            default: {
                ps.setObject(jdbcBindIndex, bind.getValue(), bind.getSqlType());
            }
        }
    }

    @Override
    public Object readBind(ResultSet rs, ResultSetMetaData meta, int type, int jdbcBindIndex) throws SQLException {
        Object o = null;
        switch (type) {
            case 2: 
            case 3: {
                BigDecimal bd = rs.getBigDecimal(jdbcBindIndex);
                if (bd == null) break;
                if (bd.scale() == 0) {
                    o = new Long(bd.longValue());
                    break;
                }
                o = new Double(bd.doubleValue());
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                o = new Long(rs.getLong(jdbcBindIndex));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                o = new Double(rs.getDouble(jdbcBindIndex));
                break;
            }
            case 1: 
            case 12: {
                o = rs.getString(jdbcBindIndex);
                break;
            }
            case 91: {
                o = rs.getTimestamp(jdbcBindIndex);
                break;
            }
            case 92: {
                o = rs.getTime(jdbcBindIndex);
                break;
            }
            case 93: {
                o = rs.getTimestamp(jdbcBindIndex);
                break;
            }
            case -1: {
                o = rs.getString(jdbcBindIndex);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                o = rs.getBytes(jdbcBindIndex);
                break;
            }
            case 2005: {
                Clob c = rs.getClob(jdbcBindIndex);
                if (c == null) {
                    o = null;
                    break;
                }
                try {
                    int len = (int)c.length();
                    if (len > 0) {
                        char[] ch = new char[len];
                        Reader r = c.getCharacterStream();
                        int processed = 0;
                        while (processed < len) {
                            processed += r.read(ch, processed, len - processed);
                        }
                        o = new String(ch);
                        break;
                    }
                    o = IOUtility.getContent((Reader)c.getCharacterStream());
                    break;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    SQLException sqe = new SQLException("read CLOB on column0=" + jdbcBindIndex);
                    sqe.initCause(e);
                    throw sqe;
                }
            }
            case 2004: {
                Blob b = rs.getBlob(jdbcBindIndex);
                if (b == null) {
                    o = null;
                    break;
                }
                o = b.getBytes(1L, (int)b.length());
                break;
            }
            default: {
                o = rs.getObject(jdbcBindIndex);
            }
        }
        if (rs.wasNull()) {
            o = null;
        }
        return o;
    }

    @Override
    public void registerOutput(CallableStatement cs, int index, Class c) throws SQLException {
        if (c == null) {
            throw new SQLException("registering output index " + index + " with type null");
        }
        int jdbcType = this.getJdbcType(c);
        cs.registerOutParameter(index, jdbcType);
    }

    protected int getJdbcType(Class c) {
        int jdbcType = Timestamp.class.isAssignableFrom(c) ? 93 : (Date.class.isAssignableFrom(c) ? 91 : (Calendar.class.isAssignableFrom(c) ? 93 : (java.util.Date.class.isAssignableFrom(c) ? 93 : (Double.class.isAssignableFrom(c) ? 8 : (Float.class.isAssignableFrom(c) ? 6 : (Integer.class.isAssignableFrom(c) ? 4 : (Long.class.isAssignableFrom(c) ? -5 : (BigInteger.class.isAssignableFrom(c) ? -5 : (BigDecimal.class.isAssignableFrom(c) ? 2 : (String.class.isAssignableFrom(c) || char[].class == c ? 12 : (byte[].class == c ? (this.isBlobEnabled() ? 2004 : -4) : (Boolean.class.isAssignableFrom(c) ? 4 : (TriState.class.isAssignableFrom(c) ? 4 : (Blob.class.isAssignableFrom(c) ? 2004 : (Clob.class.isAssignableFrom(c) ? 2005 : (c.isArray() ? 2003 : 2))))))))))))))));
        return jdbcType;
    }

    @Override
    public String createBetween(String attribute, String bindName1, String bindName2) {
        return String.valueOf(attribute) + " BETWEEN " + this.adaptBindName(bindName1) + " AND " + this.adaptBindName(bindName2);
    }

    @Override
    public String createDateBetween(String attribute, String bindName1, String bindName2) {
        return String.valueOf(attribute) + " BETWEEN TRUNC(" + this.adaptBindNameTimeDateOp(bindName1) + ") AND (TRUNC(" + this.adaptBindNameTimeDateOp(bindName2) + ")+(86399/86400)) ";
    }

    @Override
    public String createDateTimeBetween(String attribute, String bindName1, String bindName2) {
        return String.valueOf(attribute) + " BETWEEN TRUNC(" + this.adaptBindNameTimeDateOp(bindName1) + ",'MI') AND (TRUNC(" + this.adaptBindNameTimeDateOp(bindName2) + ",'MI')+(59/1440)) ";
    }

    @Override
    public String createStartsWith(String attribute, String bindName) {
        return "upper(" + attribute + ") like upper(" + this.adaptBindName(bindName) + "||'%')";
    }

    @Override
    public String createNotStartsWith(String attribute, String bindName) {
        return "upper(" + attribute + ") not like upper(" + this.adaptBindName(bindName) + "||'%')";
    }

    @Override
    public String createEndsWith(String attribute, String bindName) {
        return "upper(" + attribute + ") like upper('%'||" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createNotEndsWith(String attribute, String bindName) {
        return "upper(" + attribute + ") not like upper('%'||" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createContains(String attribute, String bindName) {
        return "upper(" + attribute + ") like upper('%'||" + this.adaptBindName(bindName) + "||'%')";
    }

    @Override
    public String createNotContains(String attribute, String bindName) {
        return "upper(" + attribute + ") not like upper('%'||" + this.adaptBindName(bindName) + "||'%')";
    }

    @Override
    public String createLike(String attribute, String bindName) {
        return "upper(" + attribute + ") like upper(" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createNotLike(String attribute, String bindName) {
        return "upper(" + attribute + ") not like upper(" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createNull(String attribute) {
        return String.valueOf(attribute) + " is null";
    }

    @Override
    public String createNotNull(String attribute) {
        return String.valueOf(attribute) + " is not null";
    }

    @Override
    public String createNumberNull(String attribute) {
        return "nvl(" + attribute + ",0)=0";
    }

    @Override
    public String createNumberNotNull(String attribute) {
        return "nvl(" + attribute + ",0)<>0";
    }

    @Override
    public String createTextNull(String attribute) {
        return "nvl(" + attribute + ",'0')='0'";
    }

    @Override
    public String createTextNotNull(String attribute) {
        return "nvl(" + attribute + ",'0')<>'0'";
    }

    @Override
    public String createIn(String attribute, String bindName) {
        return String.valueOf(attribute) + "=" + this.adaptBindName(bindName);
    }

    @Override
    public String createNotIn(String attribute, String bindName) {
        return "NOT(" + attribute + "=" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createDateIsToday(String attribute) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE) AND " + attribute + "<TRUNC(SYSDATE+1)";
    }

    @Override
    public String createDateIsInLastDays(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE-(" + this.adaptBindNameTimeDateOp(bindName) + ")) AND " + attribute + "<TRUNC(SYSDATE+1)";
    }

    @Override
    public String createDateIsInNextDays(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE) AND " + attribute + "<TRUNC(SYSDATE+" + this.adaptBindNameTimeDateOp(bindName) + "+1)";
    }

    @Override
    public String createDateIsInDays(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE+" + this.adaptBindNameTimeDateOp(bindName) + ") AND " + attribute + "<TRUNC(SYSDATE+" + this.adaptBindNameTimeDateOp(bindName) + "+1)";
    }

    @Override
    public String createDateIsInWeeks(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE+((" + this.adaptBindNameTimeDateOp(bindName) + ")*7)) AND " + attribute + "<TRUNC(SYSDATE+((" + this.adaptBindNameTimeDateOp(bindName) + ")*7)+1)";
    }

    @Override
    public String createDateIsInLastMonths(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(ADD_MONTHS(SYSDATE,(-1)*(" + this.adaptBindNameTimeDateOp(bindName) + "))) AND " + attribute + "<TRUNC(SYSDATE+1)";
    }

    @Override
    public String createDateIsInNextMonths(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE) AND " + attribute + "<TRUNC(ADD_MONTHS(SYSDATE," + this.adaptBindNameTimeDateOp(bindName) + ")+1)";
    }

    @Override
    public String createDateIsInMonths(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(ADD_MONTHS(SYSDATE," + this.adaptBindNameTimeDateOp(bindName) + ")) AND " + attribute + "<TRUNC(ADD_MONTHS(SYSDATE," + this.adaptBindNameTimeDateOp(bindName) + ")+1)";
    }

    @Override
    public String createDateIsInLEDays(String attribute, String bindName) {
        return String.valueOf(attribute) + "<TRUNC(SYSDATE+" + this.adaptBindNameTimeDateOp(bindName) + "+1)";
    }

    @Override
    public String createDateIsInLEWeeks(String attribute, String bindName) {
        return String.valueOf(attribute) + "<TRUNC(SYSDATE+((" + this.adaptBindNameTimeDateOp(bindName) + ")*7)+1)";
    }

    @Override
    public String createDateIsInLEMonths(String attribute, String bindName) {
        return String.valueOf(attribute) + "<TRUNC(ADD_MONTHS(SYSDATE," + this.adaptBindNameTimeDateOp(bindName) + ")+1)";
    }

    @Override
    public String createDateIsInGEDays(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE+" + this.adaptBindNameTimeDateOp(bindName) + ")";
    }

    @Override
    public String createDateIsInGEWeeks(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(SYSDATE+((" + this.adaptBindNameTimeDateOp(bindName) + ")*7))";
    }

    @Override
    public String createDateIsInGEMonths(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(ADD_MONTHS(SYSDATE," + this.adaptBindNameTimeDateOp(bindName) + "))";
    }

    @Override
    public String createDateIsNotToday(String attribute) {
        return "(" + attribute + "<TRUNC(SYSDATE) OR " + attribute + ">=TRUNC(SYSDATE+1))";
    }

    @Override
    public String createDateTimeIsNow(String attribute) {
        return "(" + attribute + ">=TRUNC(SYSDATE, 'MI') AND " + attribute + "<(TRUNC(SYSDATE, 'MI')+(1/24/60)))";
    }

    @Override
    public String createDateTimeIsInLEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + "<(TRUNC(SYSDATE, 'MI')+((" + this.adaptBindNameTimeDateOp(bindName) + "+1)/24/60))";
    }

    @Override
    public String createDateTimeIsInLEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + "<(TRUNC(SYSDATE, 'MI')+((1/24/60)+(" + this.adaptBindNameTimeDateOp(bindName) + "/24)))";
    }

    @Override
    public String createDateTimeIsInGEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=(TRUNC(SYSDATE, 'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24/60))";
    }

    @Override
    public String createDateTimeIsInGEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=(TRUNC(SYSDATE, 'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24))";
    }

    @Override
    public String createDateTimeIsNotNow(String attribute) {
        return "(" + attribute + "<TRUNC(SYSDATE, 'MI') OR " + attribute + ">=(TRUNC(SYSDATE, 'MI')+(1/24/60)))";
    }

    @Override
    public String createTimeIsNow(String attribute) {
        return String.valueOf(attribute) + ">=((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI'))/24/60 AND " + attribute + "<((TO_CHAR(SYSDATE,'HH24')*60)+TO_CHAR(SYSDATE,'MI')+(1/24/60))/24/60";
    }

    @Override
    public String createTimeIsNotNow(String attribute) {
        return String.valueOf(attribute) + "<((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI'))/24/60 OR " + attribute + ">((TO_CHAR(SYSDATE,'HH24')*60)+TO_CHAR(SYSDATE,'MI')+(1/24/60))/24/60";
    }

    @Override
    public String createTimeIsInMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24/60))/24/60 AND " + attribute + "<((TO_CHAR(SYSDATE,'HH24')*60)+TO_CHAR(SYSDATE,'MI')+((" + this.adaptBindNameTimeDateOp(bindName) + "+1)/24/60))/24/60";
    }

    @Override
    public String createTimeIsInHours(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24))/24/60 AND " + attribute + "<((TO_CHAR(SYSDATE,'HH24')*60)+TO_CHAR(SYSDATE,'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24)+(1/24/60))/24/60";
    }

    @Override
    public String createTimeIsInLEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + "<((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI')+((" + this.adaptBindNameTimeDateOp(bindName) + "+1)/24/60))/24/60";
    }

    @Override
    public String createTimeIsInLEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + "<((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24)+(1/24/60))/24/60";
    }

    @Override
    public String createTimeIsInGEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24/60))/24/60";
    }

    @Override
    public String createTimeIsInGEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=((TO_CHAR(SYSDATE,'HH24')*60) + TO_CHAR(SYSDATE,'MI')+(" + this.adaptBindNameTimeDateOp(bindName) + "/24))/24/60";
    }

    @Override
    public String createEQ(String attribute, String bindName) {
        return String.valueOf(attribute) + "=" + this.adaptBindName(bindName);
    }

    @Override
    public String createDateEQ(String attribute, String bindName) {
        return String.valueOf(attribute) + "=TRUNC(" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createDateTimeEQ(String attribute, String bindName) {
        return String.valueOf(attribute) + "=TRUNC(" + this.adaptBindNameTimeDateOp(bindName) + ",'MI')";
    }

    @Override
    public String createGE(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=" + this.adaptBindName(bindName);
    }

    @Override
    public String createDateGE(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createDateTimeGE(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=TRUNC(" + this.adaptBindNameTimeDateOp(bindName) + ",'MI')";
    }

    @Override
    public String createGT(String attribute, String bindName) {
        return String.valueOf(attribute) + ">" + this.adaptBindName(bindName);
    }

    @Override
    public String createDateGT(String attribute, String bindName) {
        return String.valueOf(attribute) + ">TRUNC(" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createDateTimeGT(String attribute, String bindName) {
        return String.valueOf(attribute) + ">TRUNC(" + this.adaptBindNameTimeDateOp(bindName) + ",'MI')";
    }

    @Override
    public String createLE(String attribute, String bindName) {
        return String.valueOf(attribute) + "<=" + this.adaptBindName(bindName);
    }

    @Override
    public String createDateLE(String attribute, String bindName) {
        return String.valueOf(attribute) + "<=(TRUNC(" + this.adaptBindName(bindName) + ")+(86399/86400))";
    }

    @Override
    public String createDateTimeLE(String attribute, String bindName) {
        return String.valueOf(attribute) + "<=(TRUNC(" + this.adaptBindNameTimeDateOp(bindName) + ",'MI')+(59/1440))";
    }

    @Override
    public String createLT(String attribute, String bindName) {
        return String.valueOf(attribute) + "<" + this.adaptBindName(bindName);
    }

    @Override
    public String createDateLT(String attribute, String bindName) {
        return String.valueOf(attribute) + "<TRUNC(" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createDateTimeLT(String attribute, String bindName) {
        return String.valueOf(attribute) + "<TRUNC(" + this.adaptBindNameTimeDateOp(bindName) + ",'MI')";
    }

    @Override
    public String createNEQ(String attribute, String bindName) {
        return String.valueOf(attribute) + "<>" + this.adaptBindName(bindName);
    }

    @Override
    public String createDateNEQ(String attribute, String bindName) {
        return String.valueOf(attribute) + "<>TRUNC(" + this.adaptBindName(bindName) + ")";
    }

    @Override
    public String createDateTimeNEQ(String attribute, String bindName) {
        return String.valueOf(attribute) + "<>TRUNC(" + this.adaptBindNameTimeDateOp(bindName) + ",'MI')";
    }

    protected abstract int getMaxListSize();

    @Override
    public String createInList(String attribute, Object array) {
        Object[] values = this.toArray(array);
        if (values.length == 0) {
            return this.createNull(attribute);
        }
        int max = this.getMaxListSize();
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                buf.append(" OR ");
            }
            buf.append("(");
            buf.append(attribute);
            buf.append(" IN ");
            buf.append("(");
            int k = i;
            while (k < values.length && k < i + max) {
                if (k > i) {
                    buf.append(",");
                }
                buf.append(this.toPlainText(values[k]));
                ++k;
            }
            buf.append(")");
            buf.append(")");
            i += max;
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String createNotInList(String attribute, Object array) {
        Object[] values = this.toArray(array);
        if (values.length == 0) {
            return this.createNotNull(attribute);
        }
        int max = this.getMaxListSize();
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                buf.append(" AND ");
            }
            buf.append("(");
            buf.append(attribute);
            buf.append(" NOT IN ");
            buf.append("(");
            int k = i;
            while (k < values.length && k < i + max) {
                if (k > i) {
                    buf.append(",");
                }
                buf.append(this.toPlainText(values[k]));
                ++k;
            }
            buf.append(")");
            buf.append(")");
            i += max;
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String getSysdateToken() {
        return "SYSDATE";
    }

    @Override
    public String getLowerToken() {
        return "LOWER";
    }

    @Override
    public String getUpperToken() {
        return "UPPER";
    }

    @Override
    public String getTrimToken() {
        return "TRIM";
    }

    @Override
    public String getNvlToken() {
        return "NVL";
    }

    protected Object[] toArray(Object array) {
        if (array == null) {
            return new Object[0];
        }
        if (!array.getClass().isArray()) {
            return new Object[]{array};
        }
        int len = Array.getLength(array);
        Object[] a = new Object[len];
        int i = 0;
        while (i < a.length) {
            a[i] = Array.get(array, i);
            ++i;
        }
        return a;
    }

    protected String adaptBindName(String bindName) {
        if (bindName == null) {
            return bindName;
        }
        if (bindName.startsWith("&")) {
            return bindName.substring(1);
        }
        return ":" + bindName;
    }

    protected String adaptBindNameTimeDateOp(String bindName) {
        return this.adaptBindName(bindName);
    }
}

