/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification;

import java.security.AccessController;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;

public class PrincipalNameFilter
implements IClientNotificationFilter {
    private static final long serialVersionUID = 1L;
    private final String m_principalName;
    private final long m_validUntil;

    public PrincipalNameFilter(String principalName, long timeout) {
        this.m_principalName = principalName != null ? principalName.toLowerCase() : null;
        this.m_validUntil = System.currentTimeMillis() + timeout;
    }

    @Override
    public boolean isActive() {
        return System.currentTimeMillis() <= this.m_validUntil;
    }

    @Override
    public boolean isMulticast() {
        return true;
    }

    public String getPrincipalName() {
        return this.m_principalName;
    }

    @Override
    public boolean accept() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                if (principal == null || !this.m_principalName.equalsIgnoreCase(principal.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_principalName != null ? this.m_principalName.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            PrincipalNameFilter o = (PrincipalNameFilter)obj;
            return o.m_principalName == this.m_principalName || o.m_principalName != null && o.m_principalName.equals(this.m_principalName);
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getSimpleName());
        b.append("[");
        b.append(this.m_principalName);
        b.append(", validUntil=" + new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(this.m_validUntil)));
        b.append("]");
        return b.toString();
    }
}

