/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.pool.ConnectionCloseThread;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.pool.PoolEntry;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.pool.SqlConnectionBuilder;
import org.eclipse.scout.service.IServiceInventory;

public final class SqlConnectionPool {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SqlConnectionPool.class);
    private static Object poolStoreLock = new Object();
    private static HashMap<Class, SqlConnectionPool> poolStore = new HashMap();
    private Object m_poolLock = new Object();
    private HashSet<PoolEntry> m_idleEntries = new HashSet();
    private HashSet<PoolEntry> m_busyEntries = new HashSet();
    private Class m_serviceType;
    private int m_poolSize;
    private long m_connectionLifetime;
    private long m_connectionBusyTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlConnectionPool getPool(Class serviceType, int poolSize, long connectionLifetime, long connectionBusyTimeout) {
        Object object = poolStoreLock;
        synchronized (object) {
            SqlConnectionPool pool = poolStore.get(serviceType);
            if (pool == null) {
                pool = new SqlConnectionPool(serviceType, poolSize, connectionLifetime, connectionBusyTimeout);
                poolStore.put(serviceType, pool);
            }
            return pool;
        }
    }

    private SqlConnectionPool(Class serviceType, int poolSize, long connectionLifetime, long connectionBusyTimeout) {
        this.m_serviceType = serviceType;
        this.m_poolSize = poolSize;
        this.m_connectionLifetime = connectionLifetime;
        this.m_connectionBusyTimeout = connectionBusyTimeout;
        Thread t = new Thread("SqlConnectionPool[" + this.m_serviceType.getName() + "].managePool"){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    SqlConnectionPool.this.managePool();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection leaseConnection(AbstractSqlService service) throws Exception {
        this.managePool();
        Object object = this.m_poolLock;
        synchronized (object) {
            PoolEntry candidate = null;
            while (candidate == null) {
                Iterator<PoolEntry> it = this.m_idleEntries.iterator();
                if (it.hasNext()) {
                    candidate = it.next();
                }
                if (candidate == null && this.m_idleEntries.size() + this.m_busyEntries.size() < this.m_poolSize) {
                    PoolEntry test = new PoolEntry();
                    test.conn = new SqlConnectionBuilder().createJdbcConnection(service);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("created jdbc connection " + test.conn);
                    }
                    service.callbackAfterConnectionCreated(test.conn);
                    test.createTime = System.currentTimeMillis();
                    this.m_idleEntries.add(test);
                    candidate = test;
                }
                if (candidate == null) {
                    this.m_poolLock.wait();
                }
                if (candidate == null) continue;
                try {
                    service.callbackTestConnection(candidate.conn);
                }
                catch (Throwable throwable) {
                    this.m_idleEntries.remove(candidate);
                    LOG.warn("closing dirty connection: " + candidate.conn);
                    try {
                        candidate.conn.close();
                    }
                    catch (Throwable throwable2) {}
                    candidate = null;
                }
            }
            this.m_idleEntries.remove(candidate);
            candidate.leaseBegin = System.currentTimeMillis();
            ++candidate.leaseCount;
            this.m_busyEntries.add(candidate);
            if (LOG.isDebugEnabled()) {
                LOG.debug("lease   " + candidate.conn);
            }
            return candidate.conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection conn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("release " + conn);
        }
        Object object = this.m_poolLock;
        synchronized (object) {
            PoolEntry candidate = null;
            Iterator<PoolEntry> it = this.m_busyEntries.iterator();
            while (it.hasNext()) {
                PoolEntry e = it.next();
                if (e.conn != conn) continue;
                candidate = e;
                it.remove();
                break;
            }
            if (candidate != null) {
                try {
                    if (candidate.conn.isClosed()) {
                        candidate = null;
                    }
                }
                catch (Throwable throwable) {
                    candidate = null;
                }
            }
            if (candidate != null) {
                try {
                    if (candidate.conn.getWarnings() != null) {
                        candidate.conn.clearWarnings();
                    }
                }
                catch (Throwable throwable) {
                    candidate = null;
                }
            }
            if (candidate != null) {
                candidate.leaseBegin = 0L;
                this.m_idleEntries.add(candidate);
            } else {
                LOG.warn("closing dirty connection: " + conn);
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
            this.m_poolLock.notifyAll();
        }
        this.managePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInventory getInventory() {
        StringBuffer buf = new StringBuffer();
        Object object = this.m_poolLock;
        synchronized (object) {
            SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSSS");
            buf.append("Total connections: " + (this.m_busyEntries.size() + this.m_idleEntries.size()));
            buf.append("\n");
            buf.append("Busy: " + this.m_busyEntries.size());
            buf.append("\n");
            for (PoolEntry e : this.m_busyEntries) {
                buf.append("  class=" + e.conn.getClass().getName() + ", created=" + fmt.format(new Date(e.createTime)) + ", leaseCount=" + e.leaseCount + ", leaseBegin=" + fmt.format(new Date(e.leaseBegin)));
                buf.append("\n");
            }
            buf.append("Idle: " + this.m_idleEntries.size());
            buf.append("\n");
            for (PoolEntry e : this.m_idleEntries) {
                buf.append("  class=" + e.conn.getClass().getName() + ", created=" + fmt.format(new Date(e.createTime)) + ", leaseCount=" + e.leaseCount);
                buf.append("\n");
            }
        }
        final String f = buf.toString();
        return new IServiceInventory(){

            public String getInventory() {
                return new String(f);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void managePool() {
        try {
            Object object = this.m_poolLock;
            synchronized (object) {
                ConnectionCloseThread t;
                PoolEntry e;
                Iterator<PoolEntry> it = this.m_idleEntries.iterator();
                while (it.hasNext()) {
                    e = it.next();
                    if (System.currentTimeMillis() - e.createTime <= this.m_connectionLifetime) continue;
                    t = new ConnectionCloseThread("CloseOldIdleConnection for " + this.m_serviceType.getName(), e.conn);
                    t.start();
                    e.conn = null;
                    it.remove();
                }
                it = this.m_busyEntries.iterator();
                while (it.hasNext()) {
                    e = it.next();
                    if (System.currentTimeMillis() - e.leaseBegin <= this.m_connectionBusyTimeout) continue;
                    t = new ConnectionCloseThread("CloseTimeoutBusyConnection for " + this.m_serviceType.getName(), e.conn);
                    t.start();
                    e.conn = null;
                    it.remove();
                }
            }
        }
        catch (Throwable t) {
            LOG.warn(null, t);
        }
    }
}

