/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jms;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jms.IJmsCallback;
import org.eclipse.scout.rt.server.services.common.jms.JmsJndiConfig;
import org.eclipse.scout.rt.server.services.common.jms.internal.JmsTransactionMember;

public class JmsObserver {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JmsObserver.class);
    private Object m_observerMapLock = new Object();
    private HashMap<JmsJndiConfig, Collection<WeakReference<IJmsCallback>>> m_observerMap = new HashMap();
    private Object m_jmsListenerMapLock = new Object();
    private HashMap<JmsJndiConfig, JmsListener> m_jmsListenerMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ProcessingException {
        ArrayList<JmsJndiConfig> empty = new ArrayList<JmsJndiConfig>();
        Object object = this.m_observerMap;
        synchronized (object) {
            Set<JmsJndiConfig> allLists = this.m_observerMap.keySet();
            for (JmsJndiConfig conf : allLists) {
                Collection<WeakReference<IJmsCallback>> list = this.m_observerMap.get(conf);
                Iterator<WeakReference<IJmsCallback>> it = list.iterator();
                while (it.hasNext()) {
                    WeakReference<IJmsCallback> ref = it.next();
                    IJmsCallback o = (IJmsCallback)ref.get();
                    if (o != null) continue;
                    it.remove();
                }
                if (list.size() != 0) continue;
                empty.add(conf);
            }
        }
        object = this.m_jmsListenerMapLock;
        synchronized (object) {
            for (JmsJndiConfig conf : empty) {
                this.m_observerMap.remove(conf);
                JmsListener listener = this.m_jmsListenerMap.get(conf);
                if (listener == null) continue;
                listener.stopListeningOnQueue();
                this.m_jmsListenerMap.remove(conf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCallback(JmsJndiConfig config, Message msg, Object value) {
        Object object = this.m_observerMapLock;
        synchronized (object) {
            if (this.m_observerMap != null) {
                for (WeakReference<IJmsCallback> callback : this.m_observerMap.get(config)) {
                    IJmsCallback c = (IJmsCallback)callback.get();
                    if (c == null) continue;
                    try {
                        c.execOnMessage(msg, value);
                    }
                    catch (ProcessingException e) {
                        LOG.error("Message " + msg, (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IJmsCallback callback, JmsJndiConfig config) throws ProcessingException {
        this.cleanup();
        Collection<WeakReference<IJmsCallback>> list = null;
        Object object = this.m_observerMapLock;
        synchronized (object) {
            list = this.m_observerMap.get(config);
            if (list == null) {
                list = new ArrayList<WeakReference<IJmsCallback>>();
                this.m_observerMap.put(config, list);
            }
            list.add(new WeakReference<IJmsCallback>(callback));
        }
        object = this.m_jmsListenerMapLock;
        synchronized (object) {
            JmsListener listener = this.m_jmsListenerMap.get(config);
            if (listener == null) {
                listener = new JmsListener(config);
                this.m_jmsListenerMap.put(config, new JmsListener(config));
            }
            listener.startListeningOnQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IJmsCallback callback, JmsJndiConfig config) throws ProcessingException {
        this.cleanup();
        Collection<WeakReference<IJmsCallback>> list = null;
        HashMap<JmsJndiConfig, Object> hashMap = this.m_observerMap;
        synchronized (hashMap) {
            list = this.m_observerMap.get(config);
            if (list != null) {
                list.remove(callback);
            }
        }
        hashMap = this.m_jmsListenerMap;
        synchronized (hashMap) {
            JmsListener listener;
            if (list != null && list.size() == 0 && (listener = this.m_jmsListenerMap.get(config)) != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("method=" + callback.getClass().getName());
                }
                listener.stopListeningOnQueue();
                this.m_jmsListenerMap.remove(config);
                this.m_observerMap.remove(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() throws ProcessingException {
        this.cleanup();
        Object object = this.m_jmsListenerMap;
        synchronized (object) {
            if (LOG.isInfoEnabled()) {
                LOG.info(this.m_observerMap + " listeners");
            }
            for (JmsListener jmsListener : this.m_jmsListenerMap.values()) {
                try {
                    jmsListener.stopListeningOnQueue();
                }
                catch (ProcessingException e) {
                    LOG.error(null, (Throwable)e);
                }
            }
        }
        this.m_jmsListenerMap.clear();
        object = this.m_observerMapLock;
        synchronized (object) {
            for (Collection collection : this.m_observerMap.values()) {
                collection.clear();
            }
            this.m_observerMap.clear();
        }
    }

    private class JmsListener
    implements MessageListener {
        private JmsJndiConfig m_config;
        private JmsTransactionMember m_jmsXaResource;

        public JmsListener(JmsJndiConfig config) {
            this.m_config = config;
            this.m_jmsXaResource = new JmsTransactionMember(this.m_config);
        }

        protected void finalize() throws Throwable {
            this.m_jmsXaResource.release();
            this.m_jmsXaResource = null;
        }

        public void startListeningOnQueue() throws ProcessingException {
            this.stopListeningOnQueue();
            try {
                MessageConsumer consumer = this.m_jmsXaResource.getMessageConsumer();
                consumer.setMessageListener((MessageListener)this);
            }
            catch (JMSException e) {
                this.stopListeningOnQueue();
                throw new ProcessingException(e.getLocalizedMessage(), e.getCause());
            }
        }

        public void stopListeningOnQueue() throws ProcessingException {
            this.m_jmsXaResource.release();
        }

        public final void onMessage(Message msg) {
            try {
                if (msg != null) {
                    Object valueForS = null;
                    if (msg instanceof TextMessage) {
                        valueForS = ((TextMessage)msg).getText();
                    } else if (msg instanceof BytesMessage) {
                        byte[] ba = new byte[(int)((BytesMessage)msg).getBodyLength()];
                        ((BytesMessage)msg).readBytes(ba);
                        valueForS = ba;
                    } else if (msg instanceof ObjectMessage) {
                        valueForS = ((ObjectMessage)msg).getObject();
                    }
                    JmsObserver.this.fireCallback(this.m_config, msg, valueForS);
                    msg.acknowledge();
                    if (this.m_jmsXaResource.commitPhase1()) {
                        this.m_jmsXaResource.commitPhase2();
                    }
                }
            }
            catch (JMSException ex) {
                LOG.error("receiving message: " + msg, (Throwable)ex);
                this.m_jmsXaResource.rollback();
            }
        }
    }
}

