/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security.internal;

import java.security.Permissions;
import org.eclipse.scout.commons.TTLCache;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.clientnotification.SingleUserFilter;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.security.AccessControlChangedNotification;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.services.common.security.ResetAccessControlChangedNotification;
import org.eclipse.scout.service.SERVICES;

public class AccessControlStore {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AccessControlStore.class);
    private TTLCache<String, Permissions> m_store;
    private Object m_storeLock = new Object();

    public AccessControlStore() {
        this.m_store = new TTLCache(3600000L);
    }

    public Permissions getPermissionsOfCurrentSubject() {
        String userId = ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getUserIdOfCurrentSubject();
        if (userId == null) {
            return null;
        }
        return this.getPermissions(userId);
    }

    public void setPermissionsOfCurrentSubject(Permissions p) {
        String userId = ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getUserIdOfCurrentSubject();
        if (userId == null) {
            throw new SecurityException("userId is null");
        }
        this.setPermissions(userId, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permissions getPermissions(String userId) {
        if (userId == null) {
            return null;
        }
        Object object = this.m_storeLock;
        synchronized (object) {
            return (Permissions)this.m_store.get((Object)userId.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String userId, Permissions p) {
        if (userId == null) {
            return;
        }
        Object object = this.m_storeLock;
        synchronized (object) {
            if (p == null) {
                p = new Permissions();
                p.setReadOnly();
            }
            this.m_store.put((Object)userId.toLowerCase(), (Object)p);
        }
        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new AccessControlChangedNotification(p), new SingleUserFilter(userId, 120000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        String[] userIds;
        Object object = this.m_storeLock;
        synchronized (object) {
            userIds = this.m_store.keySet().toArray(new String[this.m_store.size()]);
        }
        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new ResetAccessControlChangedNotification(), new SingleUserFilter(null, 0L));
        this.clearCacheOfUserIds(userIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheOfUserIds(String ... userIds) {
        int n;
        Object object = this.m_storeLock;
        synchronized (object) {
            String[] stringArray = userIds;
            int n2 = userIds.length;
            n = 0;
            while (n < n2) {
                String userId = stringArray[n];
                if (userId != null) {
                    this.m_store.remove((Object)userId.toLowerCase());
                }
                ++n;
            }
        }
        String[] stringArray = userIds;
        n = userIds.length;
        int n3 = 0;
        while (n3 < n) {
            String userId = stringArray[n3];
            if (userId != null) {
                ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new AccessControlChangedNotification(null), new SingleUserFilter(userId, 120000L));
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUserIds() {
        Object object = this.m_storeLock;
        synchronized (object) {
            return this.m_store.keySet().toArray(new String[this.m_store.keySet().size()]);
        }
    }
}

