/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.lookup;

import java.util.ArrayList;
import org.eclipse.scout.commons.MatrixUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.AbstractService;

public abstract class AbstractLookupService
extends AbstractService
implements ILookupService {
    public static void sortData(Object[][] data, int ... sortColumns) {
        MatrixUtility.sort((Object[][])data, (int[])sortColumns);
    }

    public static LookupRow[] createLookupRowArray(Object[][] data, LookupCall call) throws ProcessingException {
        return AbstractLookupService.createLookupRowArray(data, data != null && data.length > 0 ? data[0].length : 0, call);
    }

    public static LookupRow[] createLookupRowArray(Object[][] data, int maxColumnIndex, LookupCall call) throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>(data.length);
        Boolean active = call.getActive().getBooleanValue();
        int i = 0;
        while (i < data.length) {
            LookupRow row = new LookupRow(data[i], maxColumnIndex);
            if (active == null || active.booleanValue() == row.isActive()) {
                list.add(row);
            }
            ++i;
        }
        return list.toArray(new LookupRow[list.size()]);
    }
}

