/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.AbstractRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutFormFooter;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutFormHeader;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutViewStack;
import org.eclipse.scout.rt.ui.rap.window.desktop.ViewStackTabButton;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;

public class RwtScoutDesktopForm
extends AbstractRwtScoutPart {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDesktopForm.class);
    private Composite m_container;
    private IRwtScoutViewStack m_stackComposite;
    private IRwtScoutFormHeader m_formHeaderComposite;
    private Composite m_formBodyComposite;
    private IRwtScoutFormFooter m_formFooterComposite;
    private ViewStackTabButton m_button;

    public void createPart(IRwtScoutViewStack stackComposite, Composite parent, ViewStackTabButton button, IForm scoutForm, IRwtEnvironment uiEnvironment) {
        this.m_stackComposite = stackComposite;
        this.m_button = button;
        super.createPart(scoutForm, uiEnvironment);
        this.m_container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        try {
            parent.setRedraw(false);
            this.m_formHeaderComposite = this.getUiEnvironment().createFormHeader(this.m_container, this.getScoutObject());
            this.m_formBodyComposite = this.createFormBody(this.m_container);
            this.m_formFooterComposite = this.getUiEnvironment().createFormFooter(this.m_container, this.getScoutObject());
            this.initLayout(this.m_container);
            this.attachScout();
        }
        finally {
            parent.setRedraw(true);
        }
    }

    private Composite createFormBody(Composite parent) {
        Composite body = null;
        Composite actualBody = null;
        if (this.isEclipseFormUsed()) {
            Form eclipseForm = this.getUiEnvironment().getFormToolkit().createForm(parent);
            body = eclipseForm;
            actualBody = eclipseForm.getBody();
        } else {
            actualBody = body = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        }
        actualBody.setLayout((Layout)new FillLayout());
        this.getUiEnvironment().createForm(actualBody, this.getScoutObject());
        return body;
    }

    @Override
    public Form getUiForm() {
        if (this.m_formBodyComposite instanceof Form) {
            return (Form)this.m_formBodyComposite;
        }
        return null;
    }

    @Override
    public Composite getUiContainer() {
        return this.m_container;
    }

    public boolean isEclipseFormUsed() {
        return true;
    }

    protected void initLayout(Composite container) {
        GridData gridData;
        GridLayout layout = RwtLayoutUtility.createGridLayoutNoSpacing(1, true);
        container.setLayout((Layout)layout);
        Composite header = null;
        if (this.m_formHeaderComposite != null) {
            header = this.m_formHeaderComposite.getUiContainer();
        }
        Composite body = this.m_formBodyComposite;
        Composite footer = null;
        if (this.m_formFooterComposite != null) {
            footer = this.m_formFooterComposite.getUiContainer();
        }
        if (header != null) {
            gridData = new GridData(768);
            if (this.getFormHeaderHeightHint() != null) {
                gridData.heightHint = this.getFormHeaderHeightHint();
            }
            if (!header.isVisible()) {
                gridData.exclude = true;
            }
            header.setLayoutData((Object)gridData);
        }
        if (body != null) {
            gridData = new GridData(1808);
            body.setLayoutData((Object)gridData);
        }
        if (footer != null) {
            gridData = new GridData(768);
            if (this.getFormFooterHeightHint() != null) {
                gridData.heightHint = this.getFormFooterHeightHint();
            }
            if (!footer.isVisible()) {
                gridData.exclude = true;
            }
            footer.setLayoutData((Object)gridData);
        }
    }

    public Integer getFormHeaderHeightHint() {
        if (this.m_formHeaderComposite == null) {
            return null;
        }
        return this.m_formHeaderComposite.getHeightHint();
    }

    public Integer getFormFooterHeightHint() {
        if (this.m_formFooterComposite == null) {
            return null;
        }
        return this.m_formFooterComposite.getHeightHint();
    }

    @Override
    protected void showPartImpl() {
    }

    @Override
    protected void closePartImpl() {
        this.detachScout();
        if (this.m_button != null) {
            this.m_button.dispose();
        }
        if (this.m_container != null && !this.m_container.isDisposed()) {
            this.m_container.dispose();
        }
        this.m_stackComposite = null;
    }

    public ViewStackTabButton getTabButton() {
        return this.m_button;
    }

    @Override
    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Control c = this.getUiEnvironment().getDisplay().getFocusControl();
        if (c == null) {
            return true;
        }
        return RwtUtility.isAncestorOf((Control)this.getUiContainer(), c);
    }

    @Override
    public void activate() {
        if (this.m_stackComposite == null) {
            LOG.error("stack composite is null");
            return;
        }
        this.m_stackComposite.setPartVisible(this);
    }

    @Override
    public boolean isVisible() {
        if (this.m_stackComposite == null) {
            LOG.error("stack composite is null");
            return false;
        }
        return this.m_stackComposite.isPartVisible(this);
    }

    @Override
    public boolean setStatusLineMessage(Image image, final String message) {
        this.getUiEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                MessageBox mbox = new MessageBox("Info", message, null);
                mbox.setAutoCloseMillis(2500L);
                mbox.startMessageBox();
            }
        }, 3000L);
        return true;
    }

    @Override
    protected void setImageFromScout() {
        String iconId = this.getScoutObject().getIconId();
        Image img = this.getUiEnvironment().getIcon(iconId);
        if (this.m_button != null && !this.m_button.isDisposed()) {
            this.m_button.setImage(img);
        }
        if (this.getUiForm() != null && !this.getUiForm().isDisposed()) {
            String sub = this.getScoutObject().getSubTitle();
            if (sub != null) {
                this.getUiForm().setImage(img);
            } else {
                this.getUiForm().setImage(null);
            }
        }
    }

    @Override
    protected void setTitleFromScout() {
        IForm f = this.getScoutObject();
        String s = f.getBasicTitle();
        if (this.m_button != null && !this.m_button.isDisposed()) {
            this.m_button.setLabel(StringUtility.removeNewLines((String)(s != null ? s : "")));
        }
        s = f.getSubTitle();
        if (this.getUiForm() != null && !this.getUiForm().isDisposed()) {
            if (s != null) {
                this.getUiForm().setText(RwtUtility.escapeMnemonics(StringUtility.removeNewLines((String)(s != null ? s : ""))));
            } else {
                this.getUiForm().setText(null);
            }
        }
    }

    @Override
    protected void setCloseEnabledFromScout(boolean defaultValue) {
        if (this.m_button != null && !this.m_button.isDisposed()) {
            this.m_button.setShowClose(defaultValue);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
    }
}

