/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.checkbox.ICheckBoxMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.action.RwtScoutAction;
import org.eclipse.scout.rt.ui.rap.action.RwtScoutCheckboxMenu;
import org.eclipse.scout.rt.ui.rap.action.RwtScoutMenuAction;
import org.eclipse.scout.rt.ui.rap.action.RwtScoutMenuGroup;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class RwtMenuUtility {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(RwtMenuUtility.class);

    private RwtMenuUtility() {
    }

    public static IContributionItem[] getMenuContribution(IActionNode<?>[] scoutActionNodes, IRwtEnvironment environment) {
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        IActionNode<?>[] iActionNodeArray = scoutActionNodes;
        int n = scoutActionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IActionNode<?> scoutAction = iActionNodeArray[n2];
            if (!(!scoutAction.isVisible() || scoutAction.isSeparator() && contributionItems.size() > 0 && ((IContributionItem)contributionItems.get(contributionItems.size() - 1)).isSeparator())) {
                contributionItems.add(RwtMenuUtility.getMenuContributionItem(scoutAction, environment));
            }
            ++n2;
        }
        return contributionItems.toArray(new IContributionItem[contributionItems.size()]);
    }

    private static void fillMenuManager(IActionNode<?>[] scoutActionNodes, IMenuManager manager, IRwtEnvironment environment, boolean disableChildren) {
        IActionNode<?>[] iActionNodeArray = scoutActionNodes;
        int n = scoutActionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IActionNode<?> scoutAction = iActionNodeArray[n2];
            if (!(!scoutAction.isVisible() || scoutAction.isSeparator() && manager.getItems().length > 0 && manager.getItems()[manager.getItems().length - 1].isSeparator())) {
                manager.add(RwtMenuUtility.getMenuContributionItem(scoutAction, environment, disableChildren));
            }
            ++n2;
        }
    }

    public static IContributionItem getMenuContributionItem(IActionNode<?> scoutAction, IRwtEnvironment environment) {
        return RwtMenuUtility.getMenuContributionItem(scoutAction, environment, false);
    }

    public static IContributionItem getMenuContributionItem(IActionNode<?> scoutAction, IRwtEnvironment environment, boolean disableItem) {
        if (!scoutAction.isVisible()) {
            return null;
        }
        if (scoutAction.isSeparator()) {
            return new Separator();
        }
        if (scoutAction.hasChildActions()) {
            MenuManager manager = new MenuManager(scoutAction.getText(), scoutAction.getActionId());
            boolean disableChilds = !scoutAction.isEnabled() || disableItem;
            RwtMenuUtility.fillMenuManager(scoutAction.getChildActions().toArray(new IActionNode[scoutAction.getChildActionCount()]), (IMenuManager)manager, environment, disableChilds);
            return manager;
        }
        if (scoutAction instanceof ICheckBoxMenu) {
            Action uiAction = new RwtScoutAction((IAction)scoutAction, environment, 32).getUiAction();
            if (disableItem) {
                uiAction.setEnabled(false);
            }
            return new ActionContributionItem((org.eclipse.jface.action.IAction)uiAction);
        }
        Action uiAction = new RwtScoutAction((IAction)scoutAction, environment).getUiAction();
        if (disableItem) {
            uiAction.setEnabled(false);
        }
        return new ActionContributionItem((org.eclipse.jface.action.IAction)uiAction);
    }

    public static void fillContextMenu(IMenu[] scoutMenus, IRwtEnvironment uiEnvironment, Menu menu) {
        if (scoutMenus == null || scoutMenus.length == 0) {
            menu.setVisible(false);
            return;
        }
        LinkedList<IMenu> scoutActionNodes = new LinkedList<IMenu>();
        IMenu[] iMenuArray = scoutMenus;
        int n = scoutMenus.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu scoutMenu = iMenuArray[n2];
            scoutActionNodes.add(scoutMenu);
            ++n2;
        }
        RwtMenuUtility.fillContextMenu(scoutActionNodes, uiEnvironment, menu);
    }

    public static void fillContextMenu(List<? extends IActionNode> scoutActionNodes, IRwtEnvironment uiEnvironment, Menu menu) {
        if (scoutActionNodes == null || scoutActionNodes.size() == 0) {
            menu.setVisible(false);
            return;
        }
        List<IActionNode> cleanedScoutActions = RwtMenuUtility.cleanup(scoutActionNodes);
        for (IActionNode scoutActionNode : cleanedScoutActions) {
            RwtMenuUtility.fillContextMenuRec(scoutActionNode, uiEnvironment, menu);
        }
    }

    private static void fillContextMenuRec(IActionNode<?> scoutActionNode, IRwtEnvironment uiEnvironment, Menu menu) {
        if (!scoutActionNode.isVisible()) {
            return;
        }
        if (scoutActionNode.isSeparator()) {
            new MenuItem(menu, 2);
        } else if (scoutActionNode instanceof ICheckBoxMenu) {
            new RwtScoutCheckboxMenu(menu, (ICheckBoxMenu)scoutActionNode, uiEnvironment);
        } else if (scoutActionNode.getChildActionCount() > 0) {
            RwtScoutMenuGroup group = new RwtScoutMenuGroup(menu, (IAction)scoutActionNode, uiEnvironment);
            Menu subMenu = new Menu(menu);
            group.getUiMenuItem().setMenu(subMenu);
            List<IActionNode> childActions = RwtMenuUtility.cleanup(scoutActionNode.getChildActions());
            for (IActionNode subAction : childActions) {
                RwtMenuUtility.fillContextMenuRec(subAction, uiEnvironment, subMenu);
            }
        } else {
            new RwtScoutMenuAction(menu, (IAction)scoutActionNode, uiEnvironment);
        }
    }

    public static IMenu[] collectMenus(final IButton button, IRwtEnvironment uiEnvironment) {
        final LinkedList menuList = new LinkedList();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                menuList.addAll(Arrays.asList(button.getUIFacade().fireButtonPopupFromUI()));
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList.toArray(new IMenu[menuList.size()]);
    }

    public static IMenu[] collectMenus(final ITree tree, final boolean emptySpaceActions, final boolean nodeActions, IRwtEnvironment uiEnvironment) {
        final LinkedList menuList = new LinkedList();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(Arrays.asList(tree.getUIFacade().fireEmptySpacePopupFromUI()));
                }
                if (nodeActions) {
                    menuList.addAll(Arrays.asList(tree.getUIFacade().fireNodePopupFromUI()));
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList.toArray(new IMenu[menuList.size()]);
    }

    public static IMenu[] collectMenus(final ITable table, final boolean emptySpaceActions, final boolean rowActions, IRwtEnvironment uiEnvironment) {
        final LinkedList menuList = new LinkedList();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(Arrays.asList(table.getUIFacade().fireEmptySpacePopupFromUI()));
                }
                if (rowActions) {
                    menuList.addAll(Arrays.asList(table.getUIFacade().fireRowPopupFromUI()));
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList.toArray(new IMenu[menuList.size()]);
    }

    public static IMenu[] collectMenus(final ICalendar calendar, final boolean emptySpaceActions, final boolean componentActions, IRwtEnvironment uiEnvironment) {
        final LinkedList menuList = new LinkedList();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(Arrays.asList(calendar.getUIFacade().fireNewPopupFromUI()));
                }
                if (componentActions) {
                    menuList.addAll(Arrays.asList(calendar.getUIFacade().fireComponentPopupFromUI()));
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList.toArray(new IMenu[menuList.size()]);
    }

    public static IMenu[] collectRowMenus(ITable table, IRwtEnvironment uiEnvironment) {
        return RwtMenuUtility.collectMenus(table, false, true, uiEnvironment);
    }

    public static IMenu[] collectEmptySpaceMenus(ITable table, IRwtEnvironment uiEnvironment) {
        return RwtMenuUtility.collectMenus(table, true, false, uiEnvironment);
    }

    public static IMenu[] collectNodeMenus(ITree tree, IRwtEnvironment uiEnvironment) {
        return RwtMenuUtility.collectMenus(tree, false, true, uiEnvironment);
    }

    public static IMenu[] collectEmptySpaceMenus(ITree tree, IRwtEnvironment uiEnvironment) {
        return RwtMenuUtility.collectMenus(tree, true, false, uiEnvironment);
    }

    public static IMenu[] collectComponentMenus(ICalendar calendar, IRwtEnvironment uiEnvironment) {
        return RwtMenuUtility.collectMenus(calendar, false, true, uiEnvironment);
    }

    public static IMenu[] collectEmptySpaceMenus(ICalendar calendar, IRwtEnvironment uiEnvironment) {
        return RwtMenuUtility.collectMenus(calendar, true, false, uiEnvironment);
    }

    public static List<List<IMenu>> split(IMenu[] unseparatedMenus) {
        LinkedList<List<IMenu>> separatedMenus = new LinkedList<List<IMenu>>();
        LinkedList<IMenu> menus = new LinkedList<IMenu>();
        IMenu[] iMenuArray = unseparatedMenus;
        int n = unseparatedMenus.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu menu = iMenuArray[n2];
            if (menu.isSeparator()) {
                separatedMenus.add(menus);
                menus = new LinkedList();
            } else {
                menus.add(menu);
            }
            ++n2;
        }
        if (!separatedMenus.contains(menus)) {
            separatedMenus.add(menus);
        }
        return separatedMenus;
    }

    public static List<IActionNode> cleanup(List<? extends IActionNode> scoutActionNodes) {
        if (scoutActionNodes == null) {
            return null;
        }
        LinkedList<IActionNode> cleanedActions = new LinkedList<IActionNode>();
        int i = 0;
        while (i < scoutActionNodes.size()) {
            IAction nextVisibleAction;
            IActionNode actionNode = scoutActionNodes.get(i);
            if (actionNode.isVisible() && (!actionNode.isSeparator() || i != 0 && i != scoutActionNodes.size() - 1 && (nextVisibleAction = RwtMenuUtility.getFirstVisibleAction(scoutActionNodes, i + 1)) != null && !nextVisibleAction.isSeparator())) {
                cleanedActions.add(actionNode);
            }
            ++i;
        }
        return cleanedActions;
    }

    private static IAction getFirstVisibleAction(List<? extends IActionNode> scoutActionNodes, int startIndex) {
        if (scoutActionNodes == null) {
            return null;
        }
        int i = startIndex;
        while (i < scoutActionNodes.size()) {
            IActionNode action = scoutActionNodes.get(i);
            if (action.isVisible()) {
                return action;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasChildActions(IAction action) {
        if (!(action instanceof IActionNode)) {
            return false;
        }
        IActionNode actionNode = (IActionNode)action;
        return actionNode.hasChildActions();
    }

    public static boolean hasVisibleChildActions(IAction action) {
        if (!(action instanceof IActionNode)) {
            return false;
        }
        IActionNode actionNode = (IActionNode)action;
        for (IActionNode child : actionNode.getChildActions()) {
            if (child.isVisible()) {
                return true;
            }
            if (!child.hasChildActions() || !RwtMenuUtility.hasVisibleChildActions((IAction)child)) continue;
            return true;
        }
        return false;
    }

    public static List<? extends IActionNode> getChildActions(IAction action) {
        if (!(action instanceof IActionNode)) {
            return null;
        }
        IActionNode actionNode = (IActionNode)action;
        if (!actionNode.hasChildActions()) {
            return null;
        }
        return actionNode.getChildActions();
    }
}

