/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.browserfield;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.browser.BrowserExtension;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.browserfield.IRwtScoutBrowserField;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutBrowserField
extends RwtScoutValueFieldComposite<IBrowserField>
implements IRwtScoutBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutBrowserField.class);
    private String m_currentLocation;
    private BrowserExtension m_browserExtension;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        Browser browser = this.getUiEnvironment().getFormToolkit().createBrowser(container, 0);
        this.m_browserExtension = new BrowserExtension(browser);
        this.m_browserExtension.attach();
        browser.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                RwtScoutBrowserField.this.m_browserExtension.detach();
            }
        });
        browser.addLocationListener((LocationListener)new LocationAdapter(){
            private static final long serialVersionUID = 1L;

            public void changing(LocationEvent event) {
                event.doit = RwtScoutBrowserField.this.fireBeforeLocationChangedFromUi(event.location);
            }

            public void changed(LocationEvent event) {
                RwtScoutBrowserField.this.fireAfterLocationChangedFromUi(event.location);
            }
        });
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)browser);
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    public Browser getUiField() {
        return (Browser)super.getUiField();
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("location".equals(name)) {
            this.setLocationFromScout();
        }
    }

    @Override
    protected void setValueFromScout() {
        this.setLocationFromScout();
    }

    protected void setLocationFromScout() {
        this.m_browserExtension.clearResourceCache();
        this.m_browserExtension.clearLocalHyperlinkCache();
        String location = ((IBrowserField)this.getScoutObject()).getLocation();
        RemoteFile r = (RemoteFile)((IBrowserField)this.getScoutObject()).getValue();
        if (location == null && r != null && r.exists()) {
            try {
                if (r.getName().matches(".*\\.(zip|jar)")) {
                    location = this.registerResourcesInZip(r);
                } else {
                    String content = IOUtility.getContent((Reader)r.getDecompressedReader());
                    content = this.m_browserExtension.adaptLocalHyperlinks(content, 1);
                    location = this.m_browserExtension.addResource(r.getName(), new ByteArrayInputStream(content.getBytes("UTF-8")));
                }
                if (location != null) {
                    location = String.valueOf(location) + "?nocache=" + System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                LOG.error("preparing html content for " + r, t);
            }
        }
        this.m_currentLocation = location;
        if (this.m_currentLocation != null) {
            this.getUiField().setUrl(this.m_currentLocation);
        } else {
            this.getUiField().setText("");
        }
    }

    private String registerResourcesInZip(RemoteFile zipFile) throws ProcessingException, IOException, UnsupportedEncodingException, FileNotFoundException {
        String location = null;
        File tempDir = IOUtility.createTempDirectory((String)"browser");
        try {
            zipFile.writeZipContentToDirectory(tempDir);
            String simpleName = zipFile.getName().replaceAll("\\.(zip|jar)", ".htm");
            int prefixLen = tempDir.getAbsolutePath().length() + 1;
            File[] fileArray = IOUtility.listFilesInSubtree((File)tempDir, null);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    String content;
                    String path = f.getAbsolutePath().substring(prefixLen);
                    if (path.toLowerCase().matches(".*\\.(htm|html)")) {
                        content = IOUtility.getContent((Reader)new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                        content = this.m_browserExtension.adaptLocalHyperlinks(content, 1);
                        if (location == null && path.startsWith(simpleName)) {
                            location = this.m_browserExtension.addResource(simpleName, new ByteArrayInputStream(content.getBytes("UTF-8")));
                        } else {
                            this.m_browserExtension.addResource(path, new ByteArrayInputStream(content.getBytes("UTF-8")));
                        }
                    } else if (path.toLowerCase().matches(".*\\.(svg)")) {
                        content = IOUtility.getContent((Reader)new InputStreamReader(new FileInputStream(f)));
                        content = this.m_browserExtension.adaptLocalHyperlinks(content, 1);
                        this.m_browserExtension.addResource(path, new ByteArrayInputStream(content.getBytes("UTF-8")));
                    } else {
                        this.m_browserExtension.addResource(path, new FileInputStream(f));
                    }
                }
                ++n2;
            }
        }
        finally {
            if (tempDir != null) {
                IOUtility.deleteDirectory((File)tempDir);
            }
        }
        return location;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireBeforeLocationChangedFromUi(final String location) {
        AtomicReference accept;
        AtomicReference atomicReference = accept = new AtomicReference();
        synchronized (atomicReference) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicReference atomicReference = accept;
                    synchronized (atomicReference) {
                        accept.set(((IBrowserField)RwtScoutBrowserField.this.getScoutObject()).getUIFacade().fireBeforeLocationChangedFromUI(location));
                        accept.notifyAll();
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
            try {
                accept.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return accept.get() != null ? (Boolean)accept.get() : false;
    }

    protected void fireAfterLocationChangedFromUi(final String location) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IBrowserField)RwtScoutBrowserField.this.getScoutObject()).getUIFacade().fireAfterLocationChangedFromUI(location);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }
}

