/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.smartfield;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldProposalForm;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.ext.IDropDownButtonForPatch;
import org.eclipse.scout.rt.ui.rap.ext.MenuAdapterEx;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.ext.table.TableEx;
import org.eclipse.scout.rt.ui.rap.ext.tree.TreeEx;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.smartfield.IRwtScoutSmartField;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartEvent;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartListener;
import org.eclipse.scout.rt.ui.rap.window.popup.RwtScoutDropDownPopup;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class RwtScoutSmartField
extends RwtScoutValueFieldComposite<ISmartField<?>>
implements IRwtScoutSmartField,
IPopupSupport {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutSmartField.class);
    private IDropDownButtonForPatch m_browseButton;
    private P_PendingProposalJob m_pendingProposalJob;
    private Object m_pendingProposalJobLock;
    private Composite m_smartContainer;
    private RwtScoutDropDownPopup m_proposalPopup;
    private final Object m_popupLock = new Object();
    private TextFieldEditableSupport m_editableSupport;
    private P_KeyListener m_tabKeyListener;
    private P_KeyListener m_shiftTabKeyListener;
    private Set<IPopupSupport.IPopupSupportListener> m_popupEventListeners;
    private Object m_popupEventListenerLock;

    public RwtScoutSmartField() {
        this.m_pendingProposalJobLock = new Object();
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_popupEventListeners = new HashSet<IPopupSupport.IPopupSupportListener>();
        this.m_popupEventListenerLock = new Object();
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_smartContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 2048);
        this.m_smartContainer.setData("org.eclipse.rwt.themeVariant", (Object)this.getSmartfieldVariant());
        StyledTextEx textField = new StyledTextEx(this.m_smartContainer, 4);
        this.getUiEnvironment().getFormToolkit().adapt((Control)textField, false, false);
        textField.setData("org.eclipse.rwt.themeVariant", this.getSmartfieldVariant());
        this.m_browseButton = this.getUiEnvironment().getFormToolkit().createDropDownButton(this.m_smartContainer, 524292);
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)textField);
        this.m_smartContainer.setTabList(new Control[]{textField});
        this.m_browseButton.addFocusListener((FocusListener)new FocusAdapter(){
            private static final long serialVersionUID = 1L;

            public void focusGained(FocusEvent e) {
                RwtScoutSmartField.this.getUiField().setFocus();
            }
        });
        this.m_browseButton.addMenuDetectListener(new P_RwtMenuDetectListener());
        this.m_browseButton.addMenuListener((MenuListener)new P_ContextMenuListener((Control)this.getUiBrowseButton(), (Control)this.getUiField()));
        this.getUiEnvironment().addKeyStroke((Control)this.getUiContainer(), new P_F2KeyStroke(), false);
        this.getUiField().addModifyListener(new P_ModifyListener());
        if (!((ISmartField)this.getScoutObject()).isAllowCustomText()) {
            this.getUiField().addTraverseListener(new P_TraverseListener());
            this.attachFocusListener((Control)this.getUiField(), false);
        } else {
            this.attachFocusListener((Control)this.getUiField(), true);
        }
        this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), new P_KeyListener(0x1000002), false);
        this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), new P_KeyListener(0x1000001), false);
        this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), new P_KeyListener(0x1000006), false);
        this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), new P_KeyListener(0x1000005), false);
        P_RwtBrowseButtonListener browseButtonListener = new P_RwtBrowseButtonListener();
        this.getUiBrowseButton().addSelectionListener((SelectionListener)browseButtonListener);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_smartContainer.setLayoutData((Object)LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        this.m_smartContainer.setLayout((Layout)RwtLayoutUtility.createGridLayoutNoSpacing(2, false));
        GridData textLayoutData = new GridData(4, 4, true, true);
        textField.setLayoutData(textLayoutData);
        GridData buttonLayoutData = new GridData(0x1000000, 0x1000000, false, false);
        buttonLayoutData.heightHint = 20;
        buttonLayoutData.widthHint = 20;
        this.m_browseButton.setLayoutData(buttonLayoutData);
    }

    protected String getSmartfieldVariant() {
        return "smartfield";
    }

    protected String getSmartfieldDisabledVariant() {
        return "smartfield-disabled";
    }

    public IDropDownButtonForPatch getUiBrowseButton() {
        return this.m_browseButton;
    }

    public StyledText getUiField() {
        return (StyledText)super.getUiField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setIconIdFromScout(((ISmartField)this.getScoutObject()).getIconId());
        this.getUiBrowseButton().setDropdownEnabled(((ISmartField)this.getScoutObject()).hasMenus());
        this.setProposalFormFromScout(((ISmartField)this.getScoutObject()).getProposalForm());
    }

    @Override
    protected void detachScout() {
        this.hideProposalPopup();
        super.detachScout();
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (!CompareUtility.equals((Object)s, (Object)this.getUiField().getText())) {
            this.getUiBrowseButton().setDropdownEnabled(((ISmartField)this.getScoutObject()).hasMenus());
            if (s == null) {
                s = "";
            }
            StyledText field = this.getUiField();
            field.setText(s);
            field.setCaretOffset(0);
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_browseButton.setButtonEnabled(b);
        this.getUiField().setEnabled(b);
        if (b) {
            this.m_smartContainer.setData("org.eclipse.rwt.themeVariant", (Object)this.getSmartfieldVariant());
        } else {
            this.m_smartContainer.setData("org.eclipse.rwt.themeVariant", (Object)this.getSmartfieldDisabledVariant());
        }
    }

    @Override
    protected void setFieldEnabled(Control field, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    protected void setIconIdFromScout(String s) {
        this.m_browseButton.setData("org.eclipse.rwt.themeVariant", s);
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, (Control)this.m_smartContainer);
    }

    @Override
    protected void handleUiFocusGained() {
        super.handleUiFocusGained();
        if ((this.m_proposalPopup == null || ((ISmartField)this.getScoutObject()).getErrorStatus() != null) && this.isSelectAllOnFocusEnabled()) {
            this.getUiField().setSelection(0, this.getUiField().getText().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProposalFormFromScout(ISmartFieldProposalForm form) {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        if (form != null) {
            this.showProposalPopup(form);
        } else {
            this.hideProposalPopup();
        }
    }

    protected void showProposalPopup(final ISmartFieldProposalForm form) {
        this.hideProposalPopup();
        if (((ISmartField)this.getScoutObject()).isAllowCustomText() && !this.getUiField().isFocusControl()) {
            this.getUiEnvironment().invokeScoutLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        form.doClose();
                    }
                    catch (ProcessingException e) {
                        LOG.warn("Closing proposal form failed.", (Throwable)e);
                    }
                }
            }, 0L);
            return;
        }
        if (!((ISmartField)this.getScoutObject()).isAllowCustomText()) {
            this.disableTabbing();
        }
        this.m_proposalPopup = new RwtScoutDropDownPopup();
        this.m_proposalPopup.createPart((IForm)form, (Control)this.m_smartContainer, (Control)this.getUiField(), 16, this.getUiEnvironment());
        this.m_proposalPopup.setMaxHeightHint(280);
        this.m_proposalPopup.addRwtScoutPartListener(new RwtScoutPartListener(){

            @Override
            public void partChanged(RwtScoutPartEvent e) {
                switch (e.getType()) {
                    case 10: {
                        RwtScoutSmartField.this.notifyPopupEventListeners(2);
                        break;
                    }
                    case 40: {
                        RwtScoutSmartField.this.hideProposalPopup();
                        break;
                    }
                    case 50: {
                        if (RwtScoutSmartField.this.m_proposalPopup == null) break;
                        RwtScoutSmartField.this.m_proposalPopup = null;
                        RwtScoutSmartField.this.notifyPopupEventListeners(4);
                    }
                }
            }
        });
        this.m_proposalPopup.getShell().addShellListener((ShellListener)new ShellAdapter(){
            private static final long serialVersionUID = 1L;

            public void shellClosed(ShellEvent e) {
                e.doit = false;
            }
        });
        this.m_proposalPopup.makeNonFocusable();
        try {
            this.m_proposalPopup.getShell().setSize(new Point(this.m_smartContainer.getSize().x, 200));
            final TableEx proposalTable = RwtUtility.findChildComponent((Widget)this.m_proposalPopup.getUiContentPane(), TableEx.class);
            final TreeEx proposalTree = RwtUtility.findChildComponent((Widget)this.m_proposalPopup.getUiContentPane(), TreeEx.class);
            if (proposalTree != null || proposalTable != null) {
                form.addFormListener(new FormListener(){

                    public void formChanged(FormEvent e) throws ProcessingException {
                        switch (e.getType()) {
                            case 5000: {
                                Runnable t = new Runnable(){

                                    @Override
                                    public void run() {
                                        RwtScoutSmartField.this.optimizePopupSize(RwtScoutSmartField.this.m_proposalPopup, proposalTable, proposalTree);
                                    }
                                };
                                RwtScoutSmartField.this.getUiEnvironment().invokeUiLater(t);
                            }
                        }
                    }
                });
                this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutSmartField.this.optimizePopupSize(RwtScoutSmartField.this.m_proposalPopup, proposalTable, proposalTree);
                    }
                });
                if (proposalTree != null && proposalTree.getItemCount() > 0 || proposalTable != null && proposalTable.getItemCount() > 0) {
                    this.optimizePopupSize(this.m_proposalPopup, proposalTable, proposalTree);
                }
            }
            this.m_proposalPopup.showPart();
        }
        catch (Throwable e1) {
            LOG.error(e1.getLocalizedMessage(), e1);
        }
    }

    private void optimizePopupSize(RwtScoutDropDownPopup popup, TableEx proposalTable, TreeEx proposalTree) {
        if (popup == null) {
            return;
        }
        int minFormWidth = 0;
        if (((ISmartField)this.getScoutObject()).isActiveFilterEnabled()) {
            minFormWidth = 230;
        }
        if (proposalTable != null) {
            int scrollbarSize = proposalTable.getVerticalBar() != null ? proposalTable.getVerticalBar().getSize().x + 10 : 0;
            Point d = proposalTable.getPreferredContentSize(1000);
            d.x += scrollbarSize;
            d.x = Math.max(Math.max(this.m_smartContainer.getSize().x, minFormWidth), Math.min(d.x, 400));
            d.y = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutRowHeight(), Math.min(d.y, 280));
            popup.getShell().setSize(d);
            TableEx c = proposalTable;
            while (c != null && !(c instanceof Shell)) {
                c.layout(true);
                c = c.getParent();
            }
        } else if (proposalTree != null) {
            int scrollbarSize = proposalTree.getVerticalBar() != null ? proposalTree.getVerticalBar().getSize().x + 10 : 0;
            Point d = proposalTree.getPreferredContentSize(1000, null, 0);
            d.x += scrollbarSize;
            d.x = Math.max(Math.max(this.m_smartContainer.getSize().x, minFormWidth), Math.min(d.x, 400));
            d.y = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutRowHeight(), Math.min(d.x, 280));
            popup.getShell().setSize(d);
            TreeEx c = proposalTree;
            while (c != null && !(c instanceof Shell)) {
                c.layout(true);
                c = c.getParent();
            }
        }
        if (popup.getShell() != null && popup.getShell().isVisible()) {
            popup.autoAdjustBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hideProposalPopup() {
        Object object = this.m_popupLock;
        synchronized (object) {
            block4: {
                this.enableTabbing();
                if (this.m_proposalPopup == null || !this.m_proposalPopup.isVisible()) break block4;
                this.m_proposalPopup.closePart();
                this.m_proposalPopup = null;
                return true;
            }
            return false;
        }
    }

    private void enableTabbing() {
        if (this.m_tabKeyListener != null) {
            this.getUiEnvironment().removeKeyStroke((Control)this.getUiField(), this.m_tabKeyListener);
        }
        if (this.m_shiftTabKeyListener != null) {
            this.getUiEnvironment().removeKeyStroke((Control)this.getUiField(), this.m_shiftTabKeyListener);
        }
    }

    private void disableTabbing() {
        if (this.m_tabKeyListener == null) {
            this.m_tabKeyListener = new P_KeyListener(9);
        }
        if (this.m_shiftTabKeyListener == null) {
            this.m_shiftTabKeyListener = new P_KeyListener(9, 131072);
        }
        this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), this.m_tabKeyListener, true);
        this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), this.m_shiftTabKeyListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestProposalSupportFromUi(String text, boolean selectCurrentValue, long initialDelay) {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob == null) {
                this.m_pendingProposalJob = new P_PendingProposalJob();
            } else {
                this.m_pendingProposalJob.cancel();
            }
            this.m_pendingProposalJob.update(text, selectCurrentValue);
            this.m_pendingProposalJob.schedule(initialDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptProposalFromUi() {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        final String text = this.getUiField().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ISmartField)RwtScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected IRwtKeyStroke[] getUiKeyStrokes() {
        return new IRwtKeyStroke[]{new RwtKeyStroke(27){

            @Override
            public void handleUiAction(Event e) {
                if (RwtScoutSmartField.this.hideProposalPopup()) {
                    e.doit = false;
                }
            }
        }, new RwtKeyStroke(13){

            @Override
            public void handleUiAction(Event e) {
                if (RwtScoutSmartField.this.m_proposalPopup != null) {
                    e.doit = false;
                    RwtScoutSmartField.this.acceptProposalFromUi();
                }
            }
        }};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleUiInputVerifier(boolean doit) {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        final String text = this.getUiField().getText();
        final Holder result = new Holder(Boolean.class, (Object)true);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((ISmartField)RwtScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getUiEnvironment().dispatchImmediateUiJobs();
    }

    protected void handleUiBrowseAction() {
        if (this.getUiBrowseButton().isVisible() && this.getUiBrowseButton().isEnabled()) {
            this.requestProposalSupportFromUi("*", true, 0L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("proposalForm")) {
            this.setProposalFormFromScout((ISmartFieldProposalForm)newValue);
        }
    }

    protected void handleTextModifiedFromUi(ModifyEvent event) {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getUiField().isVisible() && this.getUiField().isFocusControl()) {
            String text = this.getUiField().getText();
            if (text == null || text.length() == 0) {
                if (this.m_proposalPopup != null) {
                    this.requestProposalSupportFromUi(text, false, 0L);
                } else {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((ISmartField)RwtScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(null);
                        }
                    };
                    this.getUiEnvironment().invokeScoutLater(t, 0L);
                }
            } else {
                this.requestProposalSupportFromUi(text, false, this.m_proposalPopup != null ? 200 : 0);
            }
        }
    }

    protected void handleTraverseFromUi(TraverseEvent event) {
        switch (event.keyCode) {
            case 13: 
            case 27: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: {
                break;
            }
            default: {
                this.handleUiInputVerifier(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPopupEventListeners(int eventType) {
        IPopupSupport.IPopupSupportListener[] listeners;
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            listeners = this.m_popupEventListeners.toArray(new IPopupSupport.IPopupSupportListener[this.m_popupEventListeners.size()]);
        }
        IPopupSupport.IPopupSupportListener[] iPopupSupportListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPopupSupport.IPopupSupportListener listener = iPopupSupportListenerArray[n2];
            listener.handleEvent(eventType);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.remove(listener);
        }
    }

    private Menu createMenu() {
        if (this.m_browseButton.getMenu() != null) {
            this.m_browseButton.getMenu().dispose();
            this.m_browseButton.setMenu(null);
        }
        Menu contextMenu = new Menu((Decorations)this.m_browseButton.getShell(), 8);
        contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener((Control)this.getUiBrowseButton(), (Control)this.getUiField()));
        this.m_browseButton.setMenu(contextMenu);
        return contextMenu;
    }

    private void createAndShowMenu(Point location) {
        Menu menu = this.createMenu();
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private class P_ContextMenuListener
    extends MenuAdapterEx {
        private static final long serialVersionUID = 1L;

        public P_ContextMenuListener(Control menuControl, Control keyStrokeWidget) {
            super(menuControl, keyStrokeWidget);
        }

        @Override
        public void menuShown(MenuEvent e) {
            super.menuShown(e);
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((ISmartField)RwtScoutSmartField.this.getScoutObject()).getUIFacade().firePopupFromUI();
                    scoutMenusRef.set(scoutMenus);
                }
            };
            JobEx job = RwtScoutSmartField.this.getUiEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {}
            if (scoutMenusRef.get() != null) {
                Menu menu = (Menu)e.getSource();
                RwtMenuUtility.fillContextMenu((IMenu[])scoutMenusRef.get(), RwtScoutSmartField.this.getUiEnvironment(), menu);
            }
        }
    }

    private class P_F2KeyStroke
    extends RwtKeyStroke {
        public P_F2KeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleUiAction(Event e) {
            RwtScoutSmartField.this.handleUiBrowseAction();
        }
    }

    private class P_KeyListener
    extends RwtKeyStroke {
        public P_KeyListener(int keyCode) {
            super(keyCode);
        }

        public P_KeyListener(int keyCode, int stateMask) {
            super(keyCode, stateMask);
        }

        @Override
        public void handleUiAction(Event e) {
            switch (e.keyCode) {
                case 9: {
                    if (RwtScoutSmartField.this.m_proposalPopup != null) break;
                    RwtScoutSmartField.this.enableTabbing();
                    break;
                }
                default: {
                    if (RwtScoutSmartField.this.m_proposalPopup == null) {
                        RwtScoutSmartField.this.requestProposalSupportFromUi("*", true, 0L);
                        e.doit = false;
                        break;
                    }
                    Table c = null;
                    c = RwtUtility.findChildComponent((Widget)RwtScoutSmartField.this.m_proposalPopup.getUiContentPane(), Table.class);
                    if (c == null) {
                        c = RwtUtility.findChildComponent((Widget)RwtScoutSmartField.this.m_proposalPopup.getUiContentPane(), Tree.class);
                    }
                    if (!RwtUtility.handleNavigationKey((Widget)c, e.keyCode)) break;
                    e.doit = false;
                }
            }
        }
    }

    private class P_ModifyListener
    implements ModifyListener {
        private static final long serialVersionUID = 1L;

        private P_ModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            RwtScoutSmartField.this.handleTextModifiedFromUi(event);
        }
    }

    private class P_PendingProposalJob
    extends JobEx
    implements Runnable {
        private String m_text;
        private boolean m_selectCurrentValue;

        public P_PendingProposalJob() {
            super("");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            RwtScoutSmartField.this.getUiEnvironment().getDisplay().asyncExec((Runnable)this);
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RwtScoutSmartField.this.m_pendingProposalJobLock;
            synchronized (object) {
                if (RwtScoutSmartField.this.m_pendingProposalJob != this) {
                    return;
                }
                RwtScoutSmartField.this.m_pendingProposalJob = null;
            }
            if (RwtScoutSmartField.this.getUiField().isDisposed()) {
                return;
            }
            if (RwtScoutSmartField.this.getUiField().isFocusControl()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((ISmartField)RwtScoutSmartField.this.getScoutObject()).getUIFacade().openProposalFromUI(P_PendingProposalJob.this.m_text, P_PendingProposalJob.this.m_selectCurrentValue);
                    }
                };
                RwtScoutSmartField.this.getUiEnvironment().invokeScoutLater(t, 0L);
            }
        }

        public void update(String text, boolean selectCurrentValue) {
            this.m_text = text;
            this.m_selectCurrentValue = selectCurrentValue;
        }
    }

    private class P_RwtBrowseButtonListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtBrowseButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RwtScoutSmartField.this.getUiField().forceFocus();
            RwtScoutSmartField.this.handleUiBrowseAction();
        }
    }

    private class P_RwtMenuDetectListener
    implements MenuDetectListener {
        private static final long serialVersionUID = 1L;

        private P_RwtMenuDetectListener() {
        }

        public void menuDetected(MenuDetectEvent e) {
            RwtScoutSmartField.this.createAndShowMenu(new Point(e.x, e.y));
        }
    }

    private class P_TraverseListener
    implements TraverseListener {
        private static final long serialVersionUID = 1L;

        private P_TraverseListener() {
        }

        public void keyTraversed(TraverseEvent event) {
            RwtScoutSmartField.this.handleTraverseFromUi(event);
        }
    }
}

