/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.messagebox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.View;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JDialogEx;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.window.messagebox.ISwingScoutMessageBox;

public class SwingScoutMessageBox
extends SwingScoutComposite<IMessageBox>
implements ISwingScoutMessageBox {
    private static final int MAX_WIDTH = 800;
    private static final int MAX_HEIGHT = 600;
    private static final int HORIZONTAL_PADDING = 12;
    private P_ScoutMessageBoxListener m_scoutMessageBoxListener;
    private Window m_swingParent;
    private JDialogEx m_swingDialog;
    private JButton m_swingButtonYes;
    private JButton m_swingButtonNo;
    private JButton m_swingButtonCancel;
    private JButton m_swingButtonCopy;

    public SwingScoutMessageBox(Window swingParent) {
        while (swingParent != null && !(swingParent instanceof Dialog) && !(swingParent instanceof Frame)) {
            swingParent = SwingUtilities.getWindowAncestor(swingParent);
        }
        this.m_swingParent = swingParent;
    }

    @Override
    protected void initializeSwing() {
        JLabelEx label;
        JPanelEx labelPanel;
        String s;
        this.m_swingDialog = this.m_swingParent instanceof Dialog ? new JDialogEx((Dialog)this.m_swingParent) : new JDialogEx((Frame)this.m_swingParent);
        this.m_swingDialog.setModal(true);
        String title = this.getScoutMessageBox().getTitle();
        this.m_swingDialog.setTitle(title);
        this.m_swingDialog.setResizable(true);
        this.m_swingDialog.addWindowListener(new P_SwingWindowListener());
        JPanel contentPane = (JPanel)this.m_swingDialog.getContentPane();
        contentPane.setLayout(new P_Layout());
        contentPane.setBackground(new Color(0xF2F2F2));
        if (this.getScoutMessageBox().getIntroText() != null) {
            s = this.getScoutMessageBox().getIntroText();
            labelPanel = new JPanelEx(new FlowLayoutEx(2));
            labelPanel.setBorder(new EmptyBorder(16, 12, 16, 12));
            labelPanel.setBackground(Color.white);
            labelPanel.setOpaque(true);
            label = new JLabelEx();
            label.setText(s);
            this.ensureProperDimension(label);
            labelPanel.add(label);
            contentPane.add("North", labelPanel);
        }
        if (this.getScoutMessageBox().getActionText() != null) {
            s = this.getScoutMessageBox().getActionText();
            labelPanel = new JPanelEx(new FlowLayoutEx(2));
            labelPanel.setBorder(new CompoundBorder(new P_TopSeparatorBorder(), new EmptyBorder(16, 12, 16, 12)));
            labelPanel.setOpaque(false);
            label = new JLabelEx();
            label.setText(s);
            this.ensureProperDimension(label);
            labelPanel.add(label);
            contentPane.add("Center", labelPanel);
        }
        JPanelEx buttonPanel = new JPanelEx(new FlowLayoutEx(4));
        buttonPanel.setBorder(new CompoundBorder(new P_TopSeparatorBorder(), new EmptyBorder(12, 12, 12, 12)));
        buttonPanel.setOpaque(false);
        JButton defaultButton = null;
        if (this.getScoutMessageBox().getYesButtonText() != null) {
            this.m_swingButtonYes = this.createButton(this.getScoutMessageBox().getYesButtonText(), UIManager.getIcon("SystemButton.yesIcon"));
            buttonPanel.add(this.m_swingButtonYes);
            defaultButton = this.m_swingButtonYes;
        }
        if (this.getScoutMessageBox().getNoButtonText() != null) {
            this.m_swingButtonNo = this.createButton(this.getScoutMessageBox().getNoButtonText(), UIManager.getIcon("SystemButton.noIcon"));
            buttonPanel.add(this.m_swingButtonNo);
            if (defaultButton == null) {
                defaultButton = this.m_swingButtonNo;
            }
        }
        if (this.getScoutMessageBox().getCancelButtonText() != null) {
            this.m_swingButtonCancel = this.createButton(this.getScoutMessageBox().getCancelButtonText(), UIManager.getIcon("SystemButton.cancelIcon"));
            buttonPanel.add(this.m_swingButtonCancel);
            if (defaultButton == null) {
                defaultButton = this.m_swingButtonCancel;
            }
        }
        if (this.m_swingButtonYes != null) {
            this.addButtonKeyStroke(this.m_swingButtonYes, "ENTER");
        } else if (this.m_swingButtonNo != null) {
            this.addButtonKeyStroke(this.m_swingButtonNo, "ENTER");
        } else if (this.m_swingButtonCancel != null) {
            this.addButtonKeyStroke(this.m_swingButtonCancel, "ENTER");
        }
        if (this.m_swingButtonCancel != null) {
            this.addButtonKeyStroke(this.m_swingButtonCancel, "ESCAPE");
        } else if (this.m_swingButtonNo != null) {
            this.addButtonKeyStroke(this.m_swingButtonNo, "ESCAPE");
        } else if (this.m_swingButtonYes != null) {
            this.addButtonKeyStroke(this.m_swingButtonYes, "ESCAPE");
        }
        if (this.getScoutMessageBox().getHiddenText() != null) {
            this.m_swingButtonCopy = this.createButton(SwingUtility.getNlsText("Copy", new String[0]), null);
            buttonPanel.add(this.m_swingButtonCopy);
            this.addButtonKeyStroke(this.m_swingButtonCopy, "control C");
        }
        contentPane.add("South", buttonPanel);
        if (defaultButton != null) {
            buttonPanel.getRootPane().setDefaultButton(defaultButton);
        }
        this.m_swingDialog.pack();
    }

    public IMessageBox getScoutMessageBox() {
        return (IMessageBox)this.getScoutObject();
    }

    @Override
    public JDialog getSwingDialog() {
        return this.m_swingDialog;
    }

    public JButton getSwingYesButton() {
        return this.m_swingButtonYes;
    }

    public JButton getSwingNoButton() {
        return this.m_swingButtonNo;
    }

    public JButton getSwingCancelButton() {
        return this.m_swingButtonCancel;
    }

    public JButton getSwingCopyButton() {
        return this.m_swingButtonCopy;
    }

    @Override
    public void showSwingMessageBox() {
        this.setOptimizedDialogBounds();
        this.m_swingDialog.isModal();
        this.m_swingDialog.setVisible(true);
    }

    private JButton createButton(String text, Icon icon) {
        final JButton b = new JButton(StringUtility.removeMnemonic((String)text));
        b.setMnemonic(StringUtility.getMnemonic((String)text));
        if (icon != null) {
            b.setIcon(icon);
        }
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingScoutMessageBox.this.handleSwingButtonAction(b);
            }
        });
        return b;
    }

    private void addButtonKeyStroke(JButton b, String keyStrokeText) {
        if (keyStrokeText != null) {
            KeyStroke pressedKs = KeyStroke.getKeyStroke(keyStrokeText);
            KeyStroke releasedKs = KeyStroke.getKeyStroke(pressedKs.getKeyCode(), pressedKs.getModifiers(), true);
            InputMap map = b.getInputMap(2);
            map.put(pressedKs, "pressed");
            map.put(releasedKs, "released");
        }
    }

    private void handleSwingButtonAction(JButton b) {
        if (b == this.m_swingButtonCopy) {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(this.getScoutMessageBox().getHiddenText()), null);
        } else {
            int resultOption = -1;
            if (b == this.m_swingButtonYes) {
                resultOption = 0;
            } else if (b == this.m_swingButtonNo) {
                resultOption = 1;
            } else if (b == this.m_swingButtonCancel) {
                resultOption = 2;
            }
            if (resultOption != -1) {
                final int fOption = resultOption;
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutMessageBox.this.getScoutMessageBox().getUIFacade().setResultFromUI(fOption);
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    private void setOptimizedDialogBounds() {
        Window owner = this.m_swingParent;
        Dimension ownerSize = owner.getSize();
        if (ownerSize.width >= 100 && ownerSize.height >= 100) {
            this.getSwingDialog().setLocationRelativeTo(owner);
        } else {
            this.getSwingDialog().setLocationRelativeTo(null);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutMessageBoxListener == null) {
            this.m_scoutMessageBoxListener = new P_ScoutMessageBoxListener();
            this.getScoutMessageBox().addMessageBoxListener((MessageBoxListener)this.m_scoutMessageBoxListener);
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutMessageBoxListener != null) {
            this.getScoutMessageBox().removeMessageBoxListener((MessageBoxListener)this.m_scoutMessageBoxListener);
            this.m_scoutMessageBoxListener = null;
        }
    }

    protected void handleScoutMessageBoxClosed(MessageBoxEvent e) {
        this.disconnectFromScout();
        this.m_swingDialog.setVisible(false);
        this.m_swingDialog.dispose();
    }

    protected void handleSwingWindowClosed(WindowEvent e) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                SwingScoutMessageBox.this.getScoutMessageBox().getUIFacade().setResultFromUI(2);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    public void setName(String name) {
        this.m_swingDialog.getRootPane().setName(name);
    }

    private void ensureProperDimension(final JLabel label) {
        if (label.getPreferredSize().width <= 800) {
            return;
        }
        label.setText(SwingUtility.createHtmlLabelText(label.getText(), true));
        label.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                JComponent component = (JComponent)e.getSource();
                component.removePropertyChangeListener("ancestor", this);
                final View view = (View)component.getClientProperty("html");
                if (view == null) {
                    return;
                }
                final float initialHorizontalSpan = view.getPreferredSpan(0);
                final float initialVerticalSpan = view.getPreferredSpan(1);
                view.setSize(Math.min(776.0f, initialHorizontalSpan), initialVerticalSpan);
                label.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e1) {
                        JPanel contentPane = (JPanel)SwingScoutMessageBox.this.m_swingDialog.getContentPane();
                        if (contentPane.getWidth() > 800) {
                            label.removeComponentListener(this);
                            view.setSize(initialHorizontalSpan, initialVerticalSpan);
                        }
                    }
                });
            }
        });
    }

    private class P_Layout
    extends BorderLayoutEx {
        private static final long serialVersionUID = 1L;

        private P_Layout() {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension d = super.getLayoutSize(parent, sizeflag);
            switch (sizeflag) {
                case 0: 
                case 1: {
                    d.width = Math.min(d.width, 800);
                    d.height = Math.min(d.height, 600);
                    break;
                }
            }
            return d;
        }
    }

    private class P_ScoutMessageBoxListener
    implements MessageBoxListener {
        private P_ScoutMessageBoxListener() {
        }

        public void messageBoxChanged(final MessageBoxEvent e) {
            switch (e.getType()) {
                case 900: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            switch (e.getType()) {
                                case 900: {
                                    SwingScoutMessageBox.this.handleScoutMessageBoxClosed(e);
                                }
                            }
                        }
                    };
                    SwingScoutMessageBox.this.getSwingEnvironment().invokeSwingLater(t);
                }
            }
        }
    }

    private class P_SwingWindowListener
    extends WindowAdapter {
        private P_SwingWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            SwingScoutMessageBox.this.handleSwingWindowClosed(e);
        }
    }

    private class P_TopSeparatorBorder
    implements Border {
        private P_TopSeparatorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.lightGray);
            g.drawLine(x, y, x + width, y);
            g.setColor(Color.white);
            g.drawLine(x, y + 1, x + width, y + 1);
        }
    }
}

