/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import javax.swing.table.TableColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class SwingTableColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;
    private IColumn m_scoutColumn;

    public SwingTableColumn(int swingModelIndex, IColumn scoutColumn) {
        super(swingModelIndex);
        this.m_scoutColumn = scoutColumn;
        int w = this.m_scoutColumn.getWidth();
        this.setMinWidth(0);
        this.setPreferredWidth(w);
        this.setWidth(w);
        if (this.m_scoutColumn.isFixedWidth()) {
            this.setMinWidth(w);
            this.setMaxWidth(w);
        }
    }

    public IColumn getScoutColumn() {
        return this.m_scoutColumn;
    }

    @Override
    public Object getHeaderValue() {
        String text;
        String o = this.m_scoutColumn.getHeaderCell().getText();
        if (o != null && SwingUtility.isMultilineLabelText(text = o.toString())) {
            String string = SwingUtility.createHtmlLabelText(text, false);
        }
        return o;
    }
}

