/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.ext.JButtonEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;

public class JSection
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int VERTICAL_GAP = 2;
    private final JButton m_button;
    private final JPanel m_head;
    private final JPanel m_body;
    private boolean m_expandable = true;
    private boolean m_expanded = true;

    public JSection(Component comp) {
        this.setOpaque(false);
        this.m_button = this.createButton();
        this.m_button.setIcon(new ExpandedIcon(this.m_button.getForeground()));
        this.m_button.setRolloverIcon(new ExpandedIcon(this.m_button.getForeground()));
        this.m_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSection.this.setExpanded(!JSection.this.isExpanded());
            }
        });
        this.m_head = new JPanelEx(new HeadLayout());
        this.m_head.setOpaque(false);
        this.m_head.add(this.m_button);
        this.m_body = new JPanelEx(new SingleLayout());
        this.m_body.setOpaque(false);
        this.m_body.add(comp);
        this.setLayout(new SectionLayout());
        this.add(this.m_head);
        this.add(this.m_body);
    }

    protected JButton createButton() {
        SectionButton button = new SectionButton();
        button.setVerticalAlignment(1);
        button.setHorizontalAlignment(10);
        button.setFocusPainted(false);
        return button;
    }

    public JComponent getContentPane() {
        return this.m_body;
    }

    public String getText() {
        return this.m_button.getText();
    }

    public void setText(String s) {
        this.m_button.setText(s);
    }

    public boolean isExpandable() {
        return this.m_expandable;
    }

    public void setExpandable(boolean expandable) {
        if (this.m_expandable != expandable) {
            this.m_expandable = expandable;
            this.m_button.setIcon(this.m_expandable ? new ExpandedIcon(this.m_button.getForeground()) : null);
            this.m_button.setRolloverIcon(this.m_expandable ? new ExpandedIcon(this.m_button.getForeground()) : null);
            this.firePropertyChange("expandable", !this.m_expandable, this.m_expandable);
            this.repaint();
        }
    }

    public boolean isExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean expanded) {
        if (expanded != this.m_expanded) {
            this.m_expanded = expanded;
            this.m_body.setVisible(this.m_expanded);
            this.firePropertyChange("expanded", !this.m_expanded, this.m_expanded);
            this.m_head.revalidate();
            this.repaint();
        }
    }

    private class ExpandedIcon
    implements Icon {
        private static final long serialVersionUID = 1L;
        private Color m_color;

        public ExpandedIcon(Color col) {
            this.m_color = col;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.m_color);
            if (JSection.this.isExpanded()) {
                int dx = 4;
                int dy = 6;
                int w = 8;
                int i = 0;
                while (i < 4) {
                    g.drawLine(x + dx, y + dy, x + dx + w - 1, y + dy);
                    ++dx;
                    ++dy;
                    w -= 2;
                    ++i;
                }
            } else {
                int dx = 6;
                int dy = 4;
                int w = 8;
                int i = 0;
                while (i < 4) {
                    g.drawLine(x + dx, y + dy, x + dx, y + dy + w - 1);
                    ++dx;
                    ++dy;
                    w -= 2;
                    ++i;
                }
            }
        }
    }

    private class HeadLayout
    extends AbstractLayoutManager2 {
        private HeadLayout() {
        }

        @Override
        protected void validateLayout(Container parent) {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension d = new Dimension();
            Dimension buttonSize = JSection.this.m_button.getPreferredSize();
            d.width = buttonSize.width;
            d.height = buttonSize.height;
            Insets insets = parent.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int buttonHeight = ((JSection)JSection.this).m_button.getPreferredSize().height;
            if (JSection.this.isExpanded()) {
                int expandedExcessHeight = ((JSection)JSection.this).m_button.getInsets().bottom;
                JSection.this.m_button.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, buttonHeight + expandedExcessHeight);
            } else {
                JSection.this.m_button.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, buttonHeight);
            }
        }
    }

    private class SectionButton
    extends JButtonEx {
        private static final long serialVersionUID = 1L;

        private SectionButton() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (JSection.this.isExpanded()) {
                int w = this.getWidth();
                int h = this.getHeight();
                int expandedExcessHeight = this.getInsets().bottom;
                Rectangle oldClip = g.getClipBounds();
                Rectangle narrowedClip = oldClip.intersection(new Rectangle(0, 0, w, h - expandedExcessHeight));
                g.setClip(narrowedClip);
                super.paintComponent(g);
                g.setClip(oldClip);
                Graphics2D g2d = (Graphics2D)g;
                Container tmp = this.getParent();
                while (tmp != null && !tmp.isOpaque()) {
                    tmp = tmp.getParent();
                }
                int backgroundRGB = (tmp != null ? tmp.getBackground() : Color.white).getRGB() & 0xFFFFFF;
                int y = 0;
                while (y <= expandedExcessHeight) {
                    int f = Math.min(255, 256 * y / expandedExcessHeight);
                    g2d.setColor(new Color(0x1000000 * f | backgroundRGB, true));
                    g2d.drawLine(0, h - expandedExcessHeight - expandedExcessHeight + y, w, h - expandedExcessHeight - expandedExcessHeight + y);
                    ++y;
                }
                g2d.setColor(new Color(0xFF000000 | backgroundRGB, true));
                g2d.fillRect(0, h - expandedExcessHeight, w, expandedExcessHeight);
                g.setClip(narrowedClip);
            } else {
                super.paintComponent(g);
            }
        }
    }

    private class SectionLayout
    extends AbstractLayoutManager2 {
        private SectionLayout() {
        }

        @Override
        protected void validateLayout(Container parent) {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension d = new Dimension();
            Dimension headSize = JSection.this.m_head.getPreferredSize();
            Dimension bodySize = SwingLayoutUtility.getValidatedSize(JSection.this.m_body, sizeflag);
            d.width = Math.max(headSize.width, bodySize.width);
            d.height = headSize.height;
            if (JSection.this.isExpanded()) {
                d.height += 4;
                d.height += bodySize.height;
            }
            Insets insets = parent.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int headHeight = ((JSection)JSection.this).m_head.getPreferredSize().height;
            JSection.this.m_head.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, headHeight);
            if (JSection.this.isExpanded()) {
                JSection.this.m_body.setBounds(insets.left, insets.top + 4 + headHeight, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom - 4 - headHeight);
            }
        }
    }
}

