/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CompareUtility;

public class OnFieldLabelDecorator {
    private JComponent m_component;
    private FocusListener m_focusListener;
    private String m_label;
    private boolean m_mandatory;

    public OnFieldLabelDecorator(JComponent c, boolean mandatory) {
        this.m_component = c;
        this.m_mandatory = mandatory;
        this.m_focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                OnFieldLabelDecorator.this.m_component.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                OnFieldLabelDecorator.this.m_component.repaint();
            }
        };
        this.m_component.addFocusListener(this.m_focusListener);
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String s) {
        if (!CompareUtility.equals((Object)this.m_label, (Object)s)) {
            this.m_label = s;
            this.m_component.repaint();
        }
    }

    public void paintOnFieldLabel(Graphics g, JComponent field) {
        if (field == null) {
            return;
        }
        if (field.hasFocus()) {
            return;
        }
        if (field instanceof JTextComponent && ((JTextComponent)field).getDocument().getLength() > 0) {
            return;
        }
        if (this.m_label != null && this.m_label.length() > 0) {
            int baseline = field.getBaseline(field.getWidth(), field.getHeight());
            g.setColor(Color.lightGray);
            if (this.m_mandatory) {
                Font f = field.getFont().deriveFont(1);
                g.setFont(f);
            }
            g.drawString(this.m_label, field.getInsets().left, baseline);
        }
    }
}

