/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.filechooser;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.window.filechooser.ISwingScoutFileChooser;

public class SwingScoutFileChooser
implements ISwingScoutFileChooser {
    private ISwingEnvironment m_env;
    private IFileChooser m_scoutFileChooser;
    private Window m_owner;
    private boolean m_useAWT;

    public SwingScoutFileChooser(ISwingEnvironment env, IFileChooser fc, Window owner, boolean useAWT) {
        this.m_env = env;
        this.m_scoutFileChooser = fc;
        this.m_owner = owner;
        this.m_useAWT = useAWT;
    }

    @Override
    public void showFileChooser() {
        File[] files = null;
        try {
            files = this.m_useAWT && !this.m_scoutFileChooser.isFolderMode() ? this.showFileChooserAWT() : this.showFileChooserSwing();
        }
        catch (Throwable throwable) {
            File[] finalFiles = files;
            Runnable t = new Runnable(finalFiles){
                private final /* synthetic */ File[] val$finalFiles;
                {
                    this.val$finalFiles = fileArray;
                }

                @Override
                public void run() {
                    SwingScoutFileChooser.this.m_scoutFileChooser.setFiles(this.val$finalFiles);
                }
            };
            this.m_env.invokeScoutLater(t, 0L);
            throw throwable;
        }
        File[] finalFiles = files;
        Runnable t = new /* invalid duplicate definition of identical inner class */;
        this.m_env.invokeScoutLater(t, 0L);
    }

    protected File[] showFileChooserSwing() {
        File[] fileArray;
        File f;
        block13: {
            int result;
            JFileChooser dlg;
            String[] extensions = this.m_scoutFileChooser.getFileExtensions();
            boolean openMode = this.m_scoutFileChooser.isTypeLoad();
            File curDir = this.m_scoutFileChooser.getDirectory();
            boolean folderMode = this.m_scoutFileChooser.isFolderMode();
            String fileName = this.m_scoutFileChooser.getFileName();
            try {
                SecurityManager sm = System.getSecurityManager();
                System.setSecurityManager(null);
                dlg = this.createFileChooserSwing(curDir);
                System.setSecurityManager(sm);
            }
            catch (Exception exception) {
                dlg = this.createFileChooserSwing(curDir);
            }
            if (folderMode) {
                dlg.setFileSelectionMode(1);
            } else {
                dlg.setFileSelectionMode(0);
            }
            if (extensions != null && extensions.length > 0) {
                FileFilter[] filters = dlg.getChoosableFileFilters();
                int i = 0;
                while (filters != null && i < filters.length) {
                    dlg.removeChoosableFileFilter(filters[i]);
                    ++i;
                }
                i = 0;
                while (i < extensions.length) {
                    String oneExt = extensions[i];
                    dlg.addChoosableFileFilter(new ExtensionFileFilter(oneExt));
                    ++i;
                }
            }
            if (StringUtility.hasText((String)fileName) && !folderMode) {
                dlg.setSelectedFile(new File(fileName));
            }
            f = null;
            while ((result = openMode ? dlg.showOpenDialog(this.m_owner) : dlg.showSaveDialog(this.m_owner)) == 0) {
                int msgBoxResult;
                f = dlg.getSelectedFile();
                if (!folderMode && f != null && dlg.getFileFilter() instanceof ExtensionFileFilter) {
                    String selectedExt = ((ExtensionFileFilter)dlg.getFileFilter()).getExt();
                    String path = f.getAbsolutePath();
                    if (selectedExt.length() > 0 && !path.toLowerCase().endsWith(selectedExt)) {
                        f = new File(String.valueOf(path) + "." + selectedExt);
                    }
                }
                if (!openMode && f != null && f.exists() && !f.isDirectory() && (msgBoxResult = JOptionPane.showConfirmDialog(this.m_owner, SwingUtility.getNlsText("FileExistsOwerwriteQuestion", new String[0]), null, 0)) != 0) continue;
                break block13;
            }
            f = null;
        }
        if (f != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = f;
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    protected JFileChooser createFileChooserSwing(File curDir) {
        if (curDir != null) {
            return new JFileChooser(curDir);
        }
        return new JFileChooser();
    }

    protected File[] showFileChooserAWT() {
        File[] fileArray;
        File f;
        FileDialog dlg;
        String fileName;
        boolean folderMode;
        File curDir;
        String[] extensions;
        block27: {
            extensions = this.m_scoutFileChooser.getFileExtensions();
            boolean openMode = this.m_scoutFileChooser.isTypeLoad();
            curDir = this.m_scoutFileChooser.getDirectory();
            folderMode = this.m_scoutFileChooser.isFolderMode();
            fileName = this.m_scoutFileChooser.getFileName();
            SecurityManager sm = System.getSecurityManager();
            try {
                try {
                    System.setSecurityManager(null);
                    StringBuffer buf = new StringBuffer();
                    if (extensions != null) {
                        int i = 0;
                        while (i < extensions.length) {
                            if (i > 0) {
                                buf.append(", ");
                            }
                            buf.append("*." + extensions[i]);
                            ++i;
                        }
                    }
                    if (buf.length() == 0) {
                        buf.append("*.*");
                    }
                    dlg = this.createFileChooserAWT(this.m_owner, buf.toString(), openMode);
                    System.setSecurityManager(sm);
                }
                catch (Exception exception) {
                    dlg = this.createFileChooserAWT(this.m_owner);
                    try {
                        System.setSecurityManager(sm);
                    }
                    catch (Throwable throwable) {}
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    System.setSecurityManager(sm);
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                System.setSecurityManager(sm);
            }
            catch (Throwable throwable) {}
        }
        if (curDir != null) {
            f = curDir;
            if (!f.isDirectory()) {
                f = f.getAbsoluteFile().getParentFile();
            }
            dlg.setDirectory(f.getAbsolutePath());
        }
        if (extensions != null && extensions.length > 0) {
            final String[] extArrayF = extensions;
            if (StringUtility.hasText((String)fileName)) {
                dlg.setFile(fileName);
            } else {
                StringBuffer extBuf = new StringBuffer();
                int i = 0;
                while (i < extArrayF.length) {
                    if (extBuf.length() > 0) {
                        extBuf.append(";");
                    }
                    extBuf.append("*." + extArrayF[i]);
                    ++i;
                }
                dlg.setFile(extBuf.toString());
            }
            dlg.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int i = 0;
                    while (i < extArrayF.length) {
                        if (name.toLowerCase().endsWith("." + extArrayF[i])) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            });
        }
        f = null;
        dlg.setVisible(true);
        if (dlg.getFile() != null) {
            String path;
            f = new File(dlg.getDirectory(), dlg.getFile());
            if (!folderMode && extensions != null && extensions.length == 1 && !(path = f.getAbsolutePath()).toLowerCase().endsWith("." + extensions[0])) {
                f = new File(String.valueOf(path) + "." + extensions[0]);
            }
        } else {
            f = null;
        }
        if (f != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = f;
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    protected FileDialog createFileChooserAWT(Window owner) {
        return this.createFileChooserAWT(owner, "", true);
    }

    protected FileDialog createFileChooserAWT(Window owner, String title, boolean openMode) {
        if (owner instanceof Dialog) {
            return new FileDialog((Dialog)owner, title, openMode ? 0 : 1);
        }
        if (this.m_owner instanceof Frame) {
            return new FileDialog((Frame)this.m_owner, title, openMode ? 0 : 1);
        }
        return new FileDialog(new Frame(), title, openMode ? 0 : 1);
    }

    private class ExtensionFileFilter
    extends FileFilter {
        private String m_ext = "";

        public ExtensionFileFilter(String ext) {
            if (ext != null && !ext.equals("*")) {
                this.m_ext = ext.toLowerCase();
            }
        }

        @Override
        public String getDescription() {
            if (this.m_ext.length() > 0) {
                return "*." + this.m_ext;
            }
            return "*.*";
        }

        public String getExt() {
            return this.m_ext;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.m_ext.length() == 0 || f.getName().toLowerCase().endsWith(this.m_ext);
        }
    }
}

