/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ImageViewer
extends Canvas {
    private int m_xAglin = 0x1000000;
    private int m_yAglin = 0x1000000;
    private boolean m_autoFit = false;
    private Image m_image;
    private Image m_scaledImage;

    public ImageViewer(Composite parent) {
        super(parent, 0);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageViewer.this.handleSwtPaintEvent(e.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageViewer.this.freeResources();
            }
        });
    }

    private void freeResources() {
        if (this.m_scaledImage != null && !this.m_scaledImage.isDisposed()) {
            this.m_scaledImage.dispose();
            this.m_scaledImage = null;
        }
    }

    private Image scaleImage(Image img) {
        this.freeResources();
        if (this.m_autoFit && img != null) {
            Point swtFieldSize = this.getSize();
            Rectangle imageBounds = img.getBounds();
            double scaleFactor = (double)swtFieldSize.x / (double)imageBounds.width;
            scaleFactor = Math.min(scaleFactor, (double)swtFieldSize.y / (double)img.getBounds().height);
            this.m_scaledImage = new Image((Device)this.getDisplay(), img.getImageData().scaledTo((int)(scaleFactor * (double)img.getBounds().width), (int)(scaleFactor * (double)img.getBounds().height)));
            return this.m_scaledImage;
        }
        return img;
    }

    protected void handleSwtPaintEvent(GC gc) {
        Image img = this.getImage();
        Rectangle bounds = gc.getClipping();
        if (img != null) {
            if (this.isAutoFit()) {
                img = this.scaleImage(img);
            }
            Rectangle imgBounds = img.getBounds();
            int x = 0;
            if (imgBounds.width <= bounds.width) {
                switch (this.getAlignmentX()) {
                    case 0x1000000: {
                        x = (bounds.width - imgBounds.width) / 2;
                        break;
                    }
                    case 131072: {
                        x = bounds.width - imgBounds.width;
                        break;
                    }
                    default: {
                        x = 0;
                    }
                }
            }
            int y = 0;
            if (imgBounds.height <= bounds.height) {
                switch (this.getAlignmentY()) {
                    case 0x1000000: {
                        y = (bounds.height - imgBounds.height) / 2;
                        break;
                    }
                    case 131072: {
                        y = bounds.height - imgBounds.height;
                        break;
                    }
                    default: {
                        y = 0;
                    }
                }
            }
            gc.drawImage(img, x, y);
        }
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point size = super.computeSize(hint, hint2, changed);
        if (this.getImage() != null) {
            Rectangle imgBounds = this.getImage().getBounds();
            size.x = imgBounds.width;
            size.y = imgBounds.height;
        }
        return size;
    }

    public void setAlignmentX(int alignment) {
        this.m_xAglin = alignment;
    }

    public int getAlignmentX() {
        return this.m_xAglin;
    }

    public void setAlignmentY(int alignment) {
        this.m_yAglin = alignment;
    }

    public int getAlignmentY() {
        return this.m_yAglin;
    }

    public boolean isAutoFit() {
        return this.m_autoFit;
    }

    public void setAutoFit(boolean autoFit) {
        this.m_autoFit = autoFit;
    }

    public void setImage(Image img) {
        this.m_image = img;
    }

    public Image getImage() {
        return this.m_image;
    }
}

